/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.auth;

import com.google.common.io.BaseEncoding;
import com.twitter.clientlib.Pair;
import com.twitter.clientlib.auth.Authentication;
import com.twitter.clientlib.auth.SortPair;
import com.twitter.joauth.Normalizer;
import com.twitter.joauth.OAuthParams;
import com.twitter.joauth.Request;
import com.twitter.joauth.Signer;
import com.twitter.joauth.UrlCodec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

public class TwitterApiKeyOAuth
implements Authentication {
    private final String headerName = "Authorization";
    private static Normalizer normalizer = Normalizer.StandardNormalizer.getStandardNormalizer();
    private static Signer signer = Signer.getStandardSigner();
    private Random r = new Random(System.currentTimeMillis());
    private String consumerKey;
    private String consumerSecret;
    private String token;
    private String tokenSecret;

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    private String generateRandomNonce() {
        byte[] bytes = new byte[10];
        this.r.nextBytes(bytes);
        return UrlCodec.normalize((String)BaseEncoding.base64().encode(bytes)).substring(0, 9);
    }

    private List<Request.Pair> createRequestParamsForJOAuth(List<Pair> inputQueryParams) {
        ArrayList<Request.Pair> queryParameters = new ArrayList<Request.Pair>();
        for (Pair nextVale : inputQueryParams) {
            queryParameters.add(new Request.Pair(nextVale.getName(), UrlCodec.normalize((String)UrlCodec.encode((String)nextVale.getValue()))));
        }
        return queryParameters;
    }

    private String buildAuthHeader(OAuthParams.OAuth1Params oAuth1Params, String signature) {
        List pairs = oAuth1Params.toList(false);
        pairs.add(new Request.Pair("oauth_signature", signature));
        pairs.sort(new SortPair());
        ArrayList<String> results = new ArrayList<String>();
        ListIterator pairListIterator = pairs.listIterator();
        while (pairListIterator.hasNext()) {
            Request.Pair nextValue = (Request.Pair)pairListIterator.next();
            results.add(nextValue.key + "=\"" + nextValue.value + "\"");
        }
        return "OAuth " + String.join((CharSequence)",", results);
    }

    @Override
    public void applyToParams(String path, String method, List<Pair> inputQueryParams, Map<String, String> headerParams, Map<String, String> cookieParams) {
        List<Request.Pair> queryParameters = this.createRequestParamsForJOAuth(inputQueryParams);
        long timeStampSecs = System.currentTimeMillis() / 1000L;
        String timeStampSecsString = String.valueOf(timeStampSecs);
        String nonce = this.generateRandomNonce();
        OAuthParams.OAuth1Params oAuth1Params = new OAuthParams.OAuth1Params(this.getToken(), this.getConsumerKey(), nonce, Long.valueOf(timeStampSecs), timeStampSecsString, null, "HMAC-SHA1", "1.0");
        String normalizedRequest = normalizer.normalize("HTTPS", "api.twitter.com", 443, method, path, queryParameters, oAuth1Params);
        try {
            String signature = signer.getString(normalizedRequest, this.getTokenSecret(), this.getConsumerSecret());
            String authHeader = this.buildAuthHeader(oAuth1Params, signature);
            headerParams.put("Authorization", authHeader);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

