/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.ApiException;
import java.util.Calendar;
import java.util.List;

public class ApiCommon {
    protected ApiClient localVarApiClient;

    public void setClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    protected OAuth2AccessToken refreshToken() throws ApiException {
        return this.localVarApiClient.refreshToken();
    }

    protected String[] reduceAuthNames(String[] localVarAuthNames) {
        return this.localVarApiClient.reduceAuthNames(localVarAuthNames);
    }

    protected boolean isOAUth2AutoRefreshToken() {
        return this.localVarApiClient.isOAUth2AutoRefreshToken();
    }

    public boolean handleRateLimit(ApiException e, Integer retries) throws ApiException {
        boolean retryCall = false;
        if (e.getCode() == 429 && retries > 0) {
            long timeToWait = this.getTimeToWait(e);
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            retryCall = true;
        }
        return retryCall;
    }

    long getTimeToWait(ApiException e) {
        List<String> xRateLimitReset;
        long timeToWait = 1000L;
        if (this.isRateLimitRemaining(e) && (xRateLimitReset = e.getResponseHeaders().get("x-rate-limit-reset")) != null && xRateLimitReset.get(0) != null) {
            timeToWait = Long.parseLong(xRateLimitReset.get(0)) * 1000L - Calendar.getInstance().getTimeInMillis();
        }
        return timeToWait;
    }

    boolean isRateLimitRemaining(ApiException e) {
        List<String> xRateLimitRemaining = e.getResponseHeaders().get("x-rate-limit-remaining");
        return xRateLimitRemaining != null && xRateLimitRemaining.get(0) != null && Long.parseLong(xRateLimitRemaining.get(0)) == 0L;
    }
}

