/*
 * Decompiled with CFR 0.152.
 */
package com.ning.compress.lzf.util;

import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.impl.UnsafeChunkEncoders;
import com.ning.compress.lzf.impl.VanillaChunkEncoder;

public class ChunkEncoderFactory {
    public static ChunkEncoder optimalInstance() {
        return ChunkEncoderFactory.optimalInstance(65535);
    }

    public static ChunkEncoder optimalInstance(int totalLength) {
        try {
            return UnsafeChunkEncoders.createEncoder(totalLength);
        }
        catch (Exception e) {
            return ChunkEncoderFactory.safeInstance(totalLength);
        }
    }

    public static ChunkEncoder optimalNonAllocatingInstance(int totalLength) {
        try {
            return UnsafeChunkEncoders.createNonAllocatingEncoder(totalLength);
        }
        catch (Exception e) {
            return ChunkEncoderFactory.safeNonAllocatingInstance(totalLength);
        }
    }

    public static ChunkEncoder safeInstance() {
        return ChunkEncoderFactory.safeInstance(65535);
    }

    public static ChunkEncoder safeInstance(int totalLength) {
        return new VanillaChunkEncoder(totalLength);
    }

    public static ChunkEncoder safeNonAllocatingInstance(int totalLength) {
        return VanillaChunkEncoder.nonAllocatingEncoder(totalLength);
    }
}

