/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

interface Connect {
    public PreparedStatement open(Connection var1) throws SQLException;

    public static final class WithKeys
    implements Connect {
        private final transient String sql;

        WithKeys(String query) {
            this.sql = query;
        }

        @Override
        public PreparedStatement open(Connection conn) throws SQLException {
            return conn.prepareStatement(this.sql, 1);
        }
    }

    public static final class Plain
    implements Connect {
        private final transient String sql;

        Plain(String query) {
            this.sql = query;
        }

        @Override
        public PreparedStatement open(Connection conn) throws SQLException {
            return conn.prepareStatement(this.sql);
        }
    }

    public static final class Call
    implements Connect {
        private final String sql;

        Call(String query) {
            this.sql = query;
        }

        @Override
        public PreparedStatement open(Connection conn) throws SQLException {
            return conn.prepareCall(this.sql);
        }
    }
}

