/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.util;

import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import java.util.Date;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateFunction {
    private final Date date;
    private final String column;
    private String comparisonExpression = "$eq";

    public DateFunction(String format, String value, String column, ComparisonOperator comparisonOperator) throws ParseException {
        if ("natural".equals(format)) {
            this.date = SqlUtils.parseNaturalLanguageDate(value);
        } else {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format).withZoneUTC();
            this.date = dateTimeFormatter.parseDateTime(value).toDate();
        }
        this.column = column;
        this.setComparisonFunction(comparisonOperator);
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public String getColumn() {
        return this.column;
    }

    private void setComparisonFunction(ComparisonOperator comparisonFunction) throws ParseException {
        if (GreaterThanEquals.class.isInstance(comparisonFunction)) {
            this.comparisonExpression = "$gte";
        } else if (GreaterThan.class.isInstance(comparisonFunction)) {
            this.comparisonExpression = "$gt";
        } else if (MinorThanEquals.class.isInstance(comparisonFunction)) {
            this.comparisonExpression = "$lte";
        } else if (MinorThan.class.isInstance(comparisonFunction)) {
            this.comparisonExpression = "$lt";
        } else {
            throw new ParseException("could not parseNaturalLanguageDate string expression: " + comparisonFunction.getStringExpression());
        }
    }

    public String getComparisonExpression() {
        return this.comparisonExpression;
    }
}

