/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter.processor;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryConverter;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.ExpressionHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.FromHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLCommandInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.WhereClauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.ExpVisitorEraseAliasTableBaseBuilder;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.OnVisitorLetsBuilder;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.OnVisitorMatchLookupBuilder;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.WhereVisitorMatchAndLookupPipelineMatchBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.bson.Document;

public final class JoinProcessor {
    private JoinProcessor() {
    }

    private static Document generateLetsFromON(FromHolder tholder, Expression onExp, String aliasTableName) {
        Document onDocument = new Document();
        onExp.accept((ExpressionVisitor)new OnVisitorLetsBuilder(onDocument, aliasTableName, tholder.getBaseAliasTable()));
        return onDocument;
    }

    private static Document generateMatchJoin(FromHolder tholder, Expression onExp, Expression wherePartialExp, String joinTableAlias) throws ParseException {
        Document matchJoinStep = new Document();
        onExp.accept((ExpressionVisitor)new OnVisitorMatchLookupBuilder(joinTableAlias, tholder.getBaseAliasTable()));
        WhereClauseProcessor whereClauseProcessor = new WhereClauseProcessor(FieldType.UNKNOWN, Collections.emptyMap(), true);
        matchJoinStep.put("$match", whereClauseProcessor.parseExpression(new Document(), (Expression)(wherePartialExp != null ? new AndExpression(onExp, wherePartialExp) : onExp), null));
        return matchJoinStep;
    }

    private static List<Document> generateSubPipelineLookup(FromHolder tholder, Expression onExp, Expression wherePartialExp, String aliasTableName, List<Document> subqueryDocs) throws ParseException {
        List<Document> ldoc = subqueryDocs;
        ldoc.add(JoinProcessor.generateMatchJoin(tholder, onExp, wherePartialExp, aliasTableName));
        return ldoc;
    }

    private static Document generateInternalLookup(FromHolder tholder, String joinTableName, String joinTableAlias, Expression onExp, Expression wherePartialExp, List<Document> subqueryDocs) throws ParseException {
        Document lookupInternal = new Document();
        lookupInternal.put("from", (Object)joinTableName);
        lookupInternal.put("let", (Object)JoinProcessor.generateLetsFromON(tholder, onExp, joinTableAlias));
        lookupInternal.put("pipeline", JoinProcessor.generateSubPipelineLookup(tholder, onExp, wherePartialExp, joinTableAlias, subqueryDocs));
        lookupInternal.put("as", (Object)joinTableAlias);
        return lookupInternal;
    }

    private static Document generateLookupStep(FromHolder tholder, String joinTableName, String joinTableAlias, Expression onExp, Expression mixedOnAndWhereExp, List<Document> subqueryDocs) throws ParseException {
        Document lookup = new Document();
        lookup.put("$lookup", (Object)JoinProcessor.generateInternalLookup(tholder, joinTableName, joinTableAlias, onExp, mixedOnAndWhereExp, subqueryDocs));
        return lookup;
    }

    private static Document generateUnwindInternal(FromHolder tholder, String joinTableAlias, boolean isLeft) {
        Document internalUnwind = new Document();
        internalUnwind.put("path", (Object)("$" + joinTableAlias));
        internalUnwind.put("preserveNullAndEmptyArrays", (Object)isLeft);
        return internalUnwind;
    }

    private static Document generateUnwindStep(FromHolder tholder, String joinTableAlias, boolean isLeft) throws ParseException {
        Document unwind = new Document();
        unwind.put("$unwind", (Object)JoinProcessor.generateUnwindInternal(tholder, joinTableAlias, isLeft));
        return unwind;
    }

    private static Document generateInternalMatchAfterJoin(String baseAliasTable, Expression whereExpression) throws ParseException {
        WhereClauseProcessor whereClauseProcessor = new WhereClauseProcessor(FieldType.UNKNOWN, Collections.emptyMap());
        whereExpression.accept((ExpressionVisitor)new ExpVisitorEraseAliasTableBaseBuilder(baseAliasTable));
        return (Document)whereClauseProcessor.parseExpression(new Document(), whereExpression, null);
    }

    private static Document generateMatchAfterJoin(FromHolder tholder, Expression whereExpression) throws ParseException {
        Document match = new Document();
        match.put("$match", (Object)JoinProcessor.generateInternalMatchAfterJoin(tholder.getBaseAliasTable(), whereExpression));
        return match;
    }

    public static List<Document> toPipelineSteps(QueryConverter queryConverter, FromHolder tholder, List<Join> ljoins, Expression whereExpression) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        LinkedList<Document> ldoc = new LinkedList<Document>();
        MutableBoolean haveOrExpression = new MutableBoolean();
        for (Join j : ljoins) {
            if (j.isInner() || j.isLeft()) {
                if (j.getRightItem() instanceof Table || j.getRightItem() instanceof SubSelect) {
                    String joinTableAlias = j.getRightItem().getAlias().getName();
                    String joinTableName = tholder.getSQLHolder(j.getRightItem()).getBaseTableName();
                    ExpressionHolder whereExpHolder = new ExpressionHolder(null);
                    if (whereExpression != null) {
                        haveOrExpression.setValue(false);
                        whereExpression.accept((ExpressionVisitor)new WhereVisitorMatchAndLookupPipelineMatchBuilder(joinTableAlias, whereExpHolder, haveOrExpression));
                        if (!haveOrExpression.booleanValue() && whereExpHolder.getExpression() != null) {
                            whereExpHolder.getExpression().accept((ExpressionVisitor)new ExpVisitorEraseAliasTableBaseBuilder(joinTableAlias));
                        } else {
                            whereExpHolder.setExpression(null);
                        }
                    }
                    LinkedList<Document> subqueryDocs = new LinkedList();
                    if (j.getRightItem() instanceof SubSelect) {
                        subqueryDocs = queryConverter.fromSQLCommandInfoHolderToAggregateSteps((SQLCommandInfoHolder)tholder.getSQLHolder(j.getRightItem()));
                    }
                    ldoc.add(JoinProcessor.generateLookupStep(tholder, joinTableName, joinTableAlias, j.getOnExpression(), whereExpHolder.getExpression(), subqueryDocs));
                    ldoc.add(JoinProcessor.generateUnwindStep(tholder, joinTableAlias, j.isLeft()));
                    continue;
                }
                throw new ParseException("From join not supported");
            }
            throw new ParseException("Only inner join and left supported");
        }
        if (haveOrExpression.booleanValue()) {
            ldoc.add(JoinProcessor.generateMatchAfterJoin(tholder, whereExpression));
        }
        return ldoc;
    }
}

