/*
 * Decompiled with CFR 0.152.
 */
package com.github.vincentrussell.query.mongodb.sql.converter;

import com.github.vincentrussell.query.mongodb.sql.converter.FieldType;
import com.github.vincentrussell.query.mongodb.sql.converter.MongoDBQueryHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.ParseException;
import com.github.vincentrussell.query.mongodb.sql.converter.QueryResultIterator;
import com.github.vincentrussell.query.mongodb.sql.converter.SQLCommandType;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.AliasHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.ExpressionHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.FromHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.holder.from.SQLCommandInfoHolder;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.HavingClauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.JoinProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.processor.WhereClauseProcessor;
import com.github.vincentrussell.query.mongodb.sql.converter.util.SqlUtils;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.ExpVisitorEraseAliasTableBaseBuilder;
import com.github.vincentrussell.query.mongodb.sql.converter.visitor.WhereVisitorMatchAndLookupPipelineMatchBuilder;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StreamProvider;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

public final class QueryConverter {
    private final CCJSqlParser jSqlParser;
    private final Integer aggregationBatchSize;
    private final Boolean aggregationAllowDiskUse;
    private MongoDBQueryHolder mongoDBQueryHolder;
    private final Map<String, FieldType> fieldNameToFieldTypeMapping;
    private final FieldType defaultFieldType;
    private SQLCommandInfoHolder sqlCommandInfoHolder;
    private static final JsonWriterSettings RELAXED = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build();

    private QueryConverter(InputStream inputStream, Map<String, FieldType> fieldNameToFieldTypeMapping, FieldType defaultFieldType, Boolean aggregationAllowDiskUse, Integer aggregationBatchSize) throws ParseException {
        try {
            this.aggregationAllowDiskUse = aggregationAllowDiskUse;
            this.aggregationBatchSize = aggregationBatchSize;
            this.jSqlParser = new CCJSqlParser((Provider)new StreamProvider(inputStream, Charsets.UTF_8.name()));
            this.defaultFieldType = defaultFieldType != null ? defaultFieldType : FieldType.UNKNOWN;
            this.sqlCommandInfoHolder = SQLCommandInfoHolder.Builder.create(defaultFieldType, fieldNameToFieldTypeMapping).setStatement(this.jSqlParser.Statement()).build();
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping != null ? fieldNameToFieldTypeMapping : Collections.emptyMap();
            Token nextToken = this.jSqlParser.getNextToken();
            SqlUtils.isTrue(StringUtils.isEmpty((String)nextToken.image) || ";".equals(nextToken.image), "unable to parse complete sql string. one reason for this is the use of double equals (==)");
            this.mongoDBQueryHolder = this.getMongoQueryInternal(this.sqlCommandInfoHolder);
            this.validate();
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        catch (net.sf.jsqlparser.parser.ParseException e) {
            throw SqlUtils.convertParseException(e);
        }
    }

    private void validate() throws ParseException {
        List<SelectItem> selectItems = this.sqlCommandInfoHolder.getSelectItems();
        ArrayList filteredItems = Lists.newArrayList((Iterable)Iterables.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && Column.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }

            public boolean test(SelectItem input) {
                return this.apply(input);
            }
        }));
        SqlUtils.isFalse((selectItems.size() > 1 || SqlUtils.isSelectAll(selectItems)) && this.sqlCommandInfoHolder.isDistinct(), "cannot run distinct one more than one column");
        SqlUtils.isFalse(this.sqlCommandInfoHolder.getGroupBys().size() == 0 && selectItems.size() != filteredItems.size() && !SqlUtils.isSelectAll(selectItems) && !SqlUtils.isCountAll(selectItems) && !this.sqlCommandInfoHolder.isTotalGroup(), "illegal expression(s) found in select clause.  Only column names supported");
    }

    public MongoDBQueryHolder getMongoQuery() {
        return this.mongoDBQueryHolder;
    }

    public List<Document> fromSQLCommandInfoHolderToAggregateSteps(SQLCommandInfoHolder sqlCommandInfoHolder) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        MongoDBQueryHolder mqueryHolder = this.getMongoQueryInternal(sqlCommandInfoHolder);
        return this.generateAggSteps(mqueryHolder, sqlCommandInfoHolder);
    }

    private MongoDBQueryHolder getMongoQueryInternal(SQLCommandInfoHolder sqlCommandInfoHolder) throws ParseException, net.sf.jsqlparser.parser.ParseException {
        MongoDBQueryHolder mongoDBQueryHolder = new MongoDBQueryHolder(sqlCommandInfoHolder.getBaseTableName(), sqlCommandInfoHolder.getSqlCommandType());
        Document document = new Document();
        if (sqlCommandInfoHolder.getFromHolder().getBaseFrom().getClass() == SubSelect.class) {
            mongoDBQueryHolder.setPrevSteps(this.fromSQLCommandInfoHolderToAggregateSteps((SQLCommandInfoHolder)sqlCommandInfoHolder.getFromHolder().getBaseSQLHolder()));
            mongoDBQueryHolder.setRequiresMultistepAggregation(true);
        }
        if (sqlCommandInfoHolder.isDistinct()) {
            document.put(sqlCommandInfoHolder.getSelectItems().get(0).toString(), (Object)1);
            mongoDBQueryHolder.setProjection(document);
            mongoDBQueryHolder.setDistinct(sqlCommandInfoHolder.isDistinct());
        } else if (sqlCommandInfoHolder.getGroupBys().size() > 0) {
            List<String> groupBys = this.preprocessGroupBy(sqlCommandInfoHolder.getGroupBys(), sqlCommandInfoHolder.getFromHolder());
            List<SelectItem> selects = this.preprocessSelect(sqlCommandInfoHolder.getSelectItems(), sqlCommandInfoHolder.getFromHolder());
            if (sqlCommandInfoHolder.getGroupBys().size() > 0) {
                mongoDBQueryHolder.setGroupBys(groupBys);
            }
            mongoDBQueryHolder.setProjection(this.createProjectionsFromSelectItems(selects, groupBys));
            mongoDBQueryHolder.setAliasProjection(this.createAliasProjectionForGroupItems(selects, groupBys));
            mongoDBQueryHolder.setRequiresMultistepAggregation(true);
        } else if (sqlCommandInfoHolder.isTotalGroup()) {
            List<SelectItem> selects = this.preprocessSelect(sqlCommandInfoHolder.getSelectItems(), sqlCommandInfoHolder.getFromHolder());
            Document d = this.createProjectionsFromSelectItems(selects, null);
            mongoDBQueryHolder.setProjection(d);
            mongoDBQueryHolder.setAliasProjection(this.createAliasProjectionForGroupItems(selects, null));
        } else if (!SqlUtils.isSelectAll(sqlCommandInfoHolder.getSelectItems())) {
            document.put("_id", (Object)0);
            for (SelectItem selectItem : sqlCommandInfoHolder.getSelectItems()) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                if (selectExpressionItem.getExpression() instanceof Column) {
                    Column c = (Column)selectExpressionItem.getExpression();
                    String columnName = SqlUtils.removeAliasFromColumn(c, sqlCommandInfoHolder.getFromHolder().getBaseAliasTable()).getColumnName();
                    Alias alias = selectExpressionItem.getAlias();
                    document.put(alias != null ? alias.getName() : columnName, alias != null ? "$" + columnName : Integer.valueOf(1));
                    continue;
                }
                if (selectExpressionItem.getExpression() instanceof SubSelect) {
                    throw new ParseException("Unsupported subselect expression");
                }
                throw new ParseException("Unsupported project expression");
            }
            mongoDBQueryHolder.setProjection(document);
        }
        if (sqlCommandInfoHolder.isCountAll()) {
            mongoDBQueryHolder.setCountAll(sqlCommandInfoHolder.isCountAll());
        }
        if (sqlCommandInfoHolder.getJoins() != null) {
            mongoDBQueryHolder.setRequiresMultistepAggregation(true);
            mongoDBQueryHolder.setJoinPipeline(JoinProcessor.toPipelineSteps(this, sqlCommandInfoHolder.getFromHolder(), sqlCommandInfoHolder.getJoins(), SqlUtils.cloneExpression(sqlCommandInfoHolder.getWhereClause())));
        }
        if (sqlCommandInfoHolder.getOrderByElements() != null && sqlCommandInfoHolder.getOrderByElements().size() > 0) {
            mongoDBQueryHolder.setSort(this.createSortInfoFromOrderByElements(this.preprocessOrderBy(sqlCommandInfoHolder.getOrderByElements(), sqlCommandInfoHolder.getFromHolder()), sqlCommandInfoHolder.getAliasHolder(), sqlCommandInfoHolder.getGroupBys()));
        }
        if (sqlCommandInfoHolder.getWhereClause() != null) {
            WhereClauseProcessor whereClauseProcessor = new WhereClauseProcessor(this.defaultFieldType, this.fieldNameToFieldTypeMapping, mongoDBQueryHolder.isRequiresMultistepAggregation());
            Expression preprocessedWhere = this.preprocessWhere(sqlCommandInfoHolder.getWhereClause(), sqlCommandInfoHolder.getFromHolder());
            if (preprocessedWhere != null) {
                mongoDBQueryHolder.setQuery((Document)whereClauseProcessor.parseExpression(new Document(), preprocessedWhere, null));
            }
        }
        if (sqlCommandInfoHolder.getHavingClause() != null) {
            HavingClauseProcessor havingClauseProcessor = new HavingClauseProcessor(this.defaultFieldType, this.fieldNameToFieldTypeMapping, sqlCommandInfoHolder.getAliasHolder(), mongoDBQueryHolder.isRequiresMultistepAggregation());
            mongoDBQueryHolder.setHaving((Document)havingClauseProcessor.parseExpression(new Document(), sqlCommandInfoHolder.getHavingClause(), null));
        }
        mongoDBQueryHolder.setOffset(sqlCommandInfoHolder.getOffset());
        mongoDBQueryHolder.setLimit(sqlCommandInfoHolder.getLimit());
        return mongoDBQueryHolder;
    }

    private Expression preprocessWhere(Expression exp, FromHolder tholder) {
        Expression returnValue = exp;
        if (this.sqlCommandInfoHolder.getJoins() != null && !this.sqlCommandInfoHolder.getJoins().isEmpty()) {
            ExpressionHolder partialWhereExpHolder = new ExpressionHolder(null);
            MutableBoolean haveOrExpression = new MutableBoolean(false);
            returnValue.accept((ExpressionVisitor)new WhereVisitorMatchAndLookupPipelineMatchBuilder(tholder.getBaseAliasTable(), partialWhereExpHolder, haveOrExpression));
            if (haveOrExpression.booleanValue()) {
                return null;
            }
            returnValue = partialWhereExpHolder.getExpression();
        }
        if (returnValue != null) {
            returnValue.accept((ExpressionVisitor)new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return returnValue;
    }

    private List<OrderByElement> preprocessOrderBy(List<OrderByElement> lord, FromHolder tholder) {
        for (OrderByElement ord : lord) {
            ord.getExpression().accept((ExpressionVisitor)new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return lord;
    }

    private List<SelectItem> preprocessSelect(List<SelectItem> lsel, FromHolder tholder) {
        for (SelectItem sel : lsel) {
            sel.accept((SelectItemVisitor)new ExpVisitorEraseAliasTableBaseBuilder(tholder.getBaseAliasTable()));
        }
        return lsel;
    }

    private List<String> preprocessGroupBy(List<String> lgroup, FromHolder tholder) {
        LinkedList<String> lgroupEraseAlias = new LinkedList<String>();
        for (String group : lgroup) {
            int index = group.indexOf(tholder.getBaseAliasTable() + ".");
            if (index != -1) {
                lgroupEraseAlias.add(group.substring(tholder.getBaseAliasTable().length() + 1));
                continue;
            }
            lgroupEraseAlias.add(group);
        }
        return lgroupEraseAlias;
    }

    private Document createSortInfoFromOrderByElements(List<OrderByElement> orderByElements, AliasHolder aliasHolder, List<String> groupBys) throws ParseException {
        if (orderByElements.size() == 0) {
            return new Document();
        }
        final ArrayList functionItems = Lists.newArrayList((Iterable)Iterables.filter(orderByElements, (Predicate)new Predicate<OrderByElement>(){

            public boolean apply(OrderByElement orderByElement) {
                try {
                    if (net.sf.jsqlparser.expression.Function.class.isInstance(orderByElement.getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }

            public boolean test(OrderByElement input) {
                return this.apply(input);
            }
        }));
        ArrayList nonFunctionItems = Lists.newArrayList((Iterable)Collections2.filter(orderByElements, (Predicate)new Predicate<OrderByElement>(){

            public boolean apply(OrderByElement orderByElement) {
                return !functionItems.contains(orderByElement);
            }

            public boolean test(OrderByElement input) {
                return this.apply(input);
            }
        }));
        Document sortItems = new Document();
        for (OrderByElement orderByElement : orderByElements) {
            String sortKey;
            if (nonFunctionItems.contains(orderByElement)) {
                String sortField = SqlUtils.getStringValue(orderByElement.getExpression());
                String projectField = aliasHolder.getFieldFromAliasOrField(sortField);
                if (!groupBys.isEmpty()) {
                    projectField = !SqlUtils.isAggregateExpression(projectField) ? (groupBys.size() > 1 ? "_id." + projectField.replaceAll("\\.", "_") : "_id") : sortField;
                }
                sortItems.put(projectField, (Object)(orderByElement.isAsc() ? 1 : -1));
                continue;
            }
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)orderByElement.getExpression();
            String alias = aliasHolder.getAliasFromFieldExp(function.toString());
            if (alias != null && !alias.equals(function.toString())) {
                sortKey = alias;
            } else {
                Document parseFunctionDocument = new Document();
                this.parseFunctionForAggregation(function, parseFunctionDocument, Collections.emptyList(), null);
                sortKey = (String)Iterables.get((Iterable)parseFunctionDocument.keySet(), (int)0);
            }
            sortItems.put(sortKey, (Object)(orderByElement.isAsc() ? 1 : -1));
        }
        return sortItems;
    }

    private Document createProjectionsFromSelectItems(List<SelectItem> selectItems, List<String> groupBys) throws ParseException {
        Document document = new Document();
        if (selectItems.size() == 0) {
            return document;
        }
        final ArrayList functionItems = Lists.newArrayList((Iterable)Iterables.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }

            public boolean test(SelectItem input) {
                return this.apply(input);
            }
        }));
        ArrayList nonFunctionItems = Lists.newArrayList((Iterable)Collections2.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                return !functionItems.contains(selectItem);
            }

            public boolean test(SelectItem input) {
                return this.apply(input);
            }
        }));
        Document idDocument = new Document();
        for (SelectItem selectItem : nonFunctionItems) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            Column column = (Column)selectExpressionItem.getExpression();
            String columnName = SqlUtils.getStringValue((Expression)column);
            idDocument.put(columnName.replaceAll("\\.", "_"), (Object)("$" + columnName));
        }
        if (!idDocument.isEmpty()) {
            document.append("_id", idDocument.size() == 1 ? Iterables.get((Iterable)idDocument.values(), (int)0) : idDocument);
        }
        for (SelectItem selectItem : functionItems) {
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)((SelectExpressionItem)selectItem).getExpression();
            this.parseFunctionForAggregation(function, document, groupBys, ((SelectExpressionItem)selectItem).getAlias());
        }
        return document;
    }

    private Document createAliasProjectionForGroupItems(List<SelectItem> selectItems, List<String> groupBys) throws ParseException {
        SelectExpressionItem selectExpressionItem;
        Document document = new Document();
        final ArrayList functionItems = Lists.newArrayList((Iterable)Iterables.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                try {
                    if (SelectExpressionItem.class.isInstance(selectItem) && net.sf.jsqlparser.expression.Function.class.isInstance(((SelectExpressionItem)selectItem).getExpression())) {
                        return true;
                    }
                }
                catch (NullPointerException e) {
                    return false;
                }
                return false;
            }

            public boolean test(SelectItem input) {
                return this.apply(input);
            }
        }));
        ArrayList nonFunctionItems = Lists.newArrayList((Iterable)Collections2.filter(selectItems, (Predicate)new Predicate<SelectItem>(){

            public boolean apply(SelectItem selectItem) {
                return !functionItems.contains(selectItem);
            }

            public boolean test(SelectItem input) {
                return this.apply(input);
            }
        }));
        if (nonFunctionItems.size() == 1) {
            SelectExpressionItem selectExpressionItem2 = (SelectExpressionItem)nonFunctionItems.get(0);
            Column column = (Column)selectExpressionItem2.getExpression();
            String columnName = SqlUtils.getStringValue((Expression)column);
            Alias alias = selectExpressionItem2.getAlias();
            String nameOrAlias = alias != null ? alias.getName() : columnName;
            document.put(nameOrAlias, (Object)"$_id");
        } else {
            for (SelectItem selectItem : nonFunctionItems) {
                selectExpressionItem = (SelectExpressionItem)selectItem;
                Column column = (Column)selectExpressionItem.getExpression();
                String columnName = SqlUtils.getStringValue((Expression)column);
                Alias alias = selectExpressionItem.getAlias();
                String nameOrAlias = alias != null ? alias.getName() : columnName;
                document.put(nameOrAlias, (Object)("$_id." + columnName.replaceAll("\\.", "_")));
            }
        }
        for (SelectItem selectItem : functionItems) {
            selectExpressionItem = (SelectExpressionItem)selectItem;
            net.sf.jsqlparser.expression.Function function = (net.sf.jsqlparser.expression.Function)selectExpressionItem.getExpression();
            Alias alias = selectExpressionItem.getAlias();
            document.put(SqlUtils.generateAggField(function, alias), (Object)1);
        }
        document.put("_id", (Object)0);
        return document;
    }

    private void parseFunctionForAggregation(net.sf.jsqlparser.expression.Function function, Document document, List<String> groupBys, Alias alias) throws ParseException {
        String op = function.getName().toLowerCase();
        String aggField = SqlUtils.generateAggField(function, alias);
        switch (op) {
            case "count": {
                document.put(aggField, (Object)new Document("$sum", (Object)1));
                break;
            }
            case "sum": 
            case "min": 
            case "max": 
            case "avg": {
                this.createFunction(op, aggField, document, "$" + SqlUtils.getFieldFromFunction(function));
                break;
            }
            default: {
                throw new ParseException("could not understand function:" + function.getName());
            }
        }
    }

    private void createFunction(String functionName, String aggField, Document document, Object value) {
        document.put(aggField, (Object)new Document("$" + functionName, value));
    }

    public void write(OutputStream outputStream) throws IOException {
        Document queryDocument = this.getQueryAsDocument();
        String collectionName = queryDocument.getString((Object)"collection");
        boolean isAggregation = queryDocument.get((Object)"query") != null && List.class.isInstance(queryDocument.get((Object)"query"));
        boolean isFindQuery = false;
        if (queryDocument.get((Object)"distinct") != null) {
            IOUtils.write((String)("db." + collectionName + ".distinct("), (OutputStream)outputStream);
            IOUtils.write((String)("\"" + queryDocument.get((Object)"distinct") + "\""), (OutputStream)outputStream);
            IOUtils.write((String)" , ", (OutputStream)outputStream);
            IOUtils.write((String)QueryConverter.prettyPrintJson(((Document)queryDocument.get((Object)"query")).toJson(RELAXED)), (OutputStream)outputStream);
        } else if (Boolean.TRUE.equals(queryDocument.getBoolean((Object)"countAll")) && !isAggregation) {
            IOUtils.write((String)("db." + collectionName + ".count("), (OutputStream)outputStream);
            IOUtils.write((String)QueryConverter.prettyPrintJson(((Document)queryDocument.get((Object)"query")).toJson(RELAXED)), (OutputStream)outputStream);
        } else if (isAggregation) {
            IOUtils.write((String)("db." + collectionName + ".aggregate("), (OutputStream)outputStream);
            IOUtils.write((String)"[", (OutputStream)outputStream);
            IOUtils.write((String)Joiner.on((String)",").join((Iterable)Lists.transform((List)queryDocument.getList((Object)"query", Document.class), (Function)new Function<Document, String>(){

                public String apply(@Nonnull Document document) {
                    return QueryConverter.prettyPrintJson(document.toJson(RELAXED));
                }
            })), (OutputStream)outputStream);
            IOUtils.write((String)"]", (OutputStream)outputStream);
            Document options = (Document)queryDocument.get((Object)"options");
            if (options != null && options.size() > 0) {
                IOUtils.write((String)",", (OutputStream)outputStream);
                IOUtils.write((String)QueryConverter.prettyPrintJson(options.toJson(RELAXED)), (OutputStream)outputStream);
            }
        } else {
            SQLCommandType sqlCommandType = SQLCommandType.valueOf(MoreObjects.firstNonNull((Object)queryDocument.get((Object)"commandType"), (Object)SQLCommandType.SELECT.name()).toString());
            if (SQLCommandType.SELECT.equals((Object)sqlCommandType)) {
                isFindQuery = true;
                IOUtils.write((String)("db." + collectionName + ".find("), (OutputStream)outputStream);
            } else if (SQLCommandType.DELETE.equals((Object)sqlCommandType)) {
                IOUtils.write((String)("db." + collectionName + ".remove("), (OutputStream)outputStream);
            }
            IOUtils.write((String)QueryConverter.prettyPrintJson(((Document)queryDocument.get((Object)"query")).toJson(RELAXED)), (OutputStream)outputStream);
            if (queryDocument.get((Object)"projection") != null) {
                IOUtils.write((String)" , ", (OutputStream)outputStream);
                IOUtils.write((String)QueryConverter.prettyPrintJson(((Document)queryDocument.get((Object)"projection")).toJson(RELAXED)), (OutputStream)outputStream);
            }
        }
        IOUtils.write((String)")", (OutputStream)outputStream);
        if (isFindQuery) {
            if (queryDocument.get((Object)"sort") != null) {
                IOUtils.write((String)".sort(", (OutputStream)outputStream);
                IOUtils.write((String)QueryConverter.prettyPrintJson(((Document)queryDocument.get((Object)"sort")).toJson(RELAXED)), (OutputStream)outputStream);
                IOUtils.write((String)")", (OutputStream)outputStream);
            }
            if (queryDocument.get((Object)"offset") != null) {
                IOUtils.write((String)".skip(", (OutputStream)outputStream);
                IOUtils.write((String)(queryDocument.get((Object)"offset") + ""), (OutputStream)outputStream);
                IOUtils.write((String)")", (OutputStream)outputStream);
            }
            if (queryDocument.get((Object)"limit") != null) {
                IOUtils.write((String)".limit(", (OutputStream)outputStream);
                IOUtils.write((String)(queryDocument.get((Object)"limit") + ""), (OutputStream)outputStream);
                IOUtils.write((String)")", (OutputStream)outputStream);
            }
        }
    }

    public Document getQueryAsDocument() {
        Document retValDocument = new Document();
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        boolean isFindQuery = false;
        String collectionName = mongoDBQueryHolder.getCollection();
        if (mongoDBQueryHolder.isDistinct()) {
            retValDocument.put("collection", (Object)collectionName);
            retValDocument.put("distinct", (Object)this.getDistinctFieldName(mongoDBQueryHolder));
            retValDocument.put("query", (Object)mongoDBQueryHolder.getQuery());
        } else if (this.sqlCommandInfoHolder.isCountAll() && !this.isAggregate(mongoDBQueryHolder)) {
            retValDocument.put("countAll", (Object)true);
            retValDocument.put("collection", (Object)collectionName);
            retValDocument.put("query", (Object)mongoDBQueryHolder.getQuery());
        } else if (this.isAggregate(mongoDBQueryHolder)) {
            retValDocument.put("collection", (Object)collectionName);
            List<Document> aggregationDocuments = this.generateAggSteps(mongoDBQueryHolder, this.sqlCommandInfoHolder);
            retValDocument.put("query", aggregationDocuments);
            Document options = new Document();
            if (this.aggregationAllowDiskUse != null) {
                options.put("allowDiskUse", (Object)this.aggregationAllowDiskUse);
            }
            if (this.aggregationBatchSize != null) {
                options.put("cursor", (Object)new Document("batchSize", (Object)this.aggregationBatchSize));
            }
            if (options.size() > 0) {
                retValDocument.put("options", (Object)options);
            }
        } else {
            retValDocument.put("commandType", (Object)this.sqlCommandInfoHolder.getSqlCommandType().name());
            if (this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.SELECT) {
                isFindQuery = true;
                retValDocument.put("collection", (Object)collectionName);
            } else if (this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.DELETE) {
                retValDocument.put("collection", (Object)collectionName);
            }
            retValDocument.put("query", (Object)mongoDBQueryHolder.getQuery());
            if (mongoDBQueryHolder.getProjection() != null && mongoDBQueryHolder.getProjection().size() > 0 && this.sqlCommandInfoHolder.getSqlCommandType() == SQLCommandType.SELECT) {
                retValDocument.put("projection", (Object)mongoDBQueryHolder.getProjection());
            }
        }
        if (isFindQuery) {
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                retValDocument.put("sort", (Object)mongoDBQueryHolder.getSort());
            }
            if (mongoDBQueryHolder.getOffset() != -1L) {
                retValDocument.put("skip", (Object)mongoDBQueryHolder.getOffset());
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                retValDocument.put("limit", (Object)mongoDBQueryHolder.getLimit());
            }
        }
        return retValDocument;
    }

    private boolean isAggregate(MongoDBQueryHolder mongoDBQueryHolder) {
        return this.sqlCommandInfoHolder.getAliasHolder() != null && !this.sqlCommandInfoHolder.getAliasHolder().isEmpty() || this.sqlCommandInfoHolder.getGroupBys().size() > 0 || this.sqlCommandInfoHolder.getJoins() != null && this.sqlCommandInfoHolder.getJoins().size() > 0 || mongoDBQueryHolder.getPrevSteps() != null && !mongoDBQueryHolder.getPrevSteps().isEmpty() || this.sqlCommandInfoHolder.isTotalGroup() && !SqlUtils.isCountAll(this.sqlCommandInfoHolder.getSelectItems());
    }

    private String getDistinctFieldName(MongoDBQueryHolder mongoDBQueryHolder) {
        return (String)Iterables.get((Iterable)mongoDBQueryHolder.getProjection().keySet(), (int)0);
    }

    public <T> T run(MongoDatabase mongoDatabase) throws ParseException {
        MongoDBQueryHolder mongoDBQueryHolder = this.getMongoQuery();
        MongoCollection mongoCollection = mongoDatabase.getCollection(mongoDBQueryHolder.getCollection());
        if (SQLCommandType.SELECT.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            if (mongoDBQueryHolder.isDistinct()) {
                return (T)((Object)new QueryResultIterator(mongoCollection.distinct(this.getDistinctFieldName(mongoDBQueryHolder), (Bson)mongoDBQueryHolder.getQuery(), String.class)));
            }
            if (this.sqlCommandInfoHolder.isCountAll() && !this.isAggregate(mongoDBQueryHolder)) {
                return (T)Long.valueOf(mongoCollection.count((Bson)mongoDBQueryHolder.getQuery()));
            }
            if (this.isAggregate(mongoDBQueryHolder)) {
                AggregateIterable aggregate = mongoCollection.aggregate(this.generateAggSteps(mongoDBQueryHolder, this.sqlCommandInfoHolder));
                if (this.aggregationAllowDiskUse != null) {
                    aggregate.allowDiskUse(this.aggregationAllowDiskUse);
                }
                if (this.aggregationBatchSize != null) {
                    aggregate.batchSize(this.aggregationBatchSize.intValue());
                }
                return (T)((Object)new QueryResultIterator(aggregate));
            }
            FindIterable findIterable = mongoCollection.find((Bson)mongoDBQueryHolder.getQuery()).projection((Bson)mongoDBQueryHolder.getProjection());
            if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
                findIterable.sort((Bson)mongoDBQueryHolder.getSort());
            }
            if (mongoDBQueryHolder.getOffset() != -1L) {
                findIterable.skip((int)mongoDBQueryHolder.getOffset());
            }
            if (mongoDBQueryHolder.getLimit() != -1L) {
                findIterable.limit((int)mongoDBQueryHolder.getLimit());
            }
            return (T)((Object)new QueryResultIterator(findIterable));
        }
        if (SQLCommandType.DELETE.equals((Object)mongoDBQueryHolder.getSqlCommandType())) {
            DeleteResult deleteResult = mongoCollection.deleteMany((Bson)mongoDBQueryHolder.getQuery());
            return (T)Long.valueOf(deleteResult.getDeletedCount());
        }
        throw new UnsupportedOperationException("SQL command type not supported");
    }

    private List<Document> setUpStartPipeline(MongoDBQueryHolder mongoDBQueryHolder) {
        List<Document> documents = mongoDBQueryHolder.getPrevSteps();
        if (documents == null || documents.isEmpty()) {
            documents = new LinkedList<Document>();
        }
        return documents;
    }

    private List<Document> generateAggSteps(MongoDBQueryHolder mongoDBQueryHolder, SQLCommandInfoHolder sqlCommandInfoHolder) {
        Document aliasProjection;
        List<Document> documents = this.setUpStartPipeline(mongoDBQueryHolder);
        if (mongoDBQueryHolder.getQuery() != null && mongoDBQueryHolder.getQuery().size() > 0) {
            documents.add(new Document("$match", (Object)mongoDBQueryHolder.getQuery()));
        }
        if (sqlCommandInfoHolder.getJoins() != null && !sqlCommandInfoHolder.getJoins().isEmpty()) {
            documents.addAll(mongoDBQueryHolder.getJoinPipeline());
        }
        if (!sqlCommandInfoHolder.getGroupBys().isEmpty() || sqlCommandInfoHolder.isTotalGroup()) {
            if (mongoDBQueryHolder.getProjection().get((Object)"_id") == null) {
                Document dgroup = new Document();
                dgroup.put("_id", (Object)new Document());
                for (Map.Entry keyValue : mongoDBQueryHolder.getProjection().entrySet()) {
                    if (((String)keyValue.getKey()).equals("_id")) continue;
                    dgroup.put((String)keyValue.getKey(), keyValue.getValue());
                }
                documents.add(new Document("$group", (Object)dgroup));
            } else {
                documents.add(new Document("$group", (Object)mongoDBQueryHolder.getProjection()));
            }
        }
        if (mongoDBQueryHolder.getHaving() != null && mongoDBQueryHolder.getHaving().size() > 0) {
            documents.add(new Document("$match", (Object)mongoDBQueryHolder.getHaving()));
        }
        if (mongoDBQueryHolder.getSort() != null && mongoDBQueryHolder.getSort().size() > 0) {
            documents.add(new Document("$sort", (Object)mongoDBQueryHolder.getSort()));
        }
        if (mongoDBQueryHolder.getOffset() != -1L) {
            documents.add(new Document("$skip", (Object)mongoDBQueryHolder.getOffset()));
        }
        if (mongoDBQueryHolder.getLimit() != -1L) {
            documents.add(new Document("$limit", (Object)mongoDBQueryHolder.getLimit()));
        }
        if (!(aliasProjection = mongoDBQueryHolder.getAliasProjection()).isEmpty()) {
            documents.add(new Document("$project", (Object)aliasProjection));
        }
        if (sqlCommandInfoHolder.getGroupBys().isEmpty() && !sqlCommandInfoHolder.isTotalGroup() && !mongoDBQueryHolder.getProjection().isEmpty()) {
            Document projection = mongoDBQueryHolder.getProjection();
            documents.add(new Document("$project", (Object)projection));
        }
        return documents;
    }

    private static String toJson(List<Document> documents) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.write((String)"[", (Writer)stringWriter);
        IOUtils.write((String)Joiner.on((String)",").join((Iterable)Lists.transform(documents, (Function)new Function<Document, String>(){

            public String apply(@Nonnull Document document) {
                return document.toJson(RELAXED);
            }
        })), (Writer)stringWriter);
        IOUtils.write((String)"]", (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static String prettyPrintJson(String json) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return gson.toJson(je);
    }

    public static class Builder {
        private Boolean aggregationAllowDiskUse = null;
        private Integer aggregationBatchSize = null;
        private InputStream inputStream;
        private Map<String, FieldType> fieldNameToFieldTypeMapping = new HashMap<String, FieldType>();
        private FieldType defaultFieldType = FieldType.UNKNOWN;

        public Builder sqlInputStream(InputStream inputStream) {
            Validate.notNull((Object)inputStream);
            this.inputStream = inputStream;
            return this;
        }

        public Builder sqlString(String sql) {
            Validate.notNull((Object)sql);
            this.inputStream = new ByteArrayInputStream(sql.getBytes(Charsets.UTF_8));
            return this;
        }

        public Builder fieldNameToFieldTypeMapping(Map<String, FieldType> fieldNameToFieldTypeMapping) {
            Validate.notNull(fieldNameToFieldTypeMapping);
            this.fieldNameToFieldTypeMapping = fieldNameToFieldTypeMapping;
            return this;
        }

        public Builder defaultFieldType(FieldType defaultFieldType) {
            Validate.notNull((Object)((Object)defaultFieldType));
            this.defaultFieldType = defaultFieldType;
            return this;
        }

        public Builder aggregationAllowDiskUse(Boolean aggregationAllowDiskUse) {
            Validate.notNull((Object)aggregationAllowDiskUse);
            this.aggregationAllowDiskUse = aggregationAllowDiskUse;
            return this;
        }

        public Builder aggregationBatchSize(Integer aggregationBatchSize) {
            Validate.notNull((Object)aggregationBatchSize);
            this.aggregationBatchSize = aggregationBatchSize;
            return this;
        }

        public QueryConverter build() throws ParseException {
            return new QueryConverter(this.inputStream, this.fieldNameToFieldTypeMapping, this.defaultFieldType, this.aggregationAllowDiskUse, this.aggregationBatchSize);
        }
    }
}

