/**
 * 文件名: Snippet.java
 * 包路径: com.ultrapower.zq.iscloud.schedule.web.branches2.destory
 * 创建描述
 *
 * @createPerson：牛鹏宇
 * @createDate：2017年10月16日 下午4:43:44 内容描述： 修改描述
 * @updatePerson：牛鹏宇
 * @updateDate：2017年10月16日 下午4:43:44 修改内容: 版本: V1.0
 */
package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.destory.DivDisposableBean;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@Order(6)
public class ShutDownService implements DisposableBean, ExitCodeGenerator {

    private static final Logger logger = LoggerFactory.getLogger(DivDisposableBean.class);

    @Resource(name="scheduler")
    private Scheduler scheduler;

    @Override
    public void destroy() throws Exception {
        logger.info("关闭定时任务");
        scheduler.shutdown();
        logger.info("完成。");
    }

    @Override
    public int getExitCode() {
        return 5;
    }


}