package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.schedule.common2.job.QuartzJob;
import com.github.niupengyu.schedule.mains.bean.Plan;
import com.github.niupengyu.schedule.mains.dao.PlanDao;
import com.github.niupengyu.schedule.mains.util.QuartzManager;
import org.quartz.Scheduler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("planService")
public class PlanService {

    @Autowired
    private PlanDao planDao;

    @Resource(name = "mainService")
    private MainService mainService;

    private static final String PLAN="_PLAN";

    @Resource(name="scheduler")
    private Scheduler scheduler;

    public void add(Plan plan) {
        plan.setName(plan.getTask()+PLAN);
        plan.setId(IdGeneratorUtil.uuid32());
        planDao.insert(plan);

    }

    public Plan selectOne(String id){
        return planDao.selectPlan(id);
    }

    public List<Plan> selectList(){
        List<Plan> plans=planDao.selectPlans();
        for(Plan plan:plans){
            plan.init(scheduler);
            System.out.println("tk "+plan);
        }
        return plans;
    }

    public void active(String id) throws Exception {
        Plan plan=this.selectOne(id);
        String cron=plan.getCron();
        QuartzManager.addJob(
            id,
            "planJobGroup",
            id+"trigger",
            "planTriggerGroup",
                QuartzJob.class,cron,scheduler);
        planDao.updateState(id,1);
    }

    public void close(String id) throws Exception {
        QuartzManager.removeJob(id,"planJobGroup",
                id+"trigger","planTriggerGroup",scheduler);
        planDao.updateState(id,0);
    }

    public void updateStart(String id, String start) {
        planDao.updateStart(id,start);
    }
}
