package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.*;
import com.github.niupengyu.jdbc.bean.DataSourceBean;
import com.github.niupengyu.jdbc.dao.ConnectionFactory;
import com.github.niupengyu.schedule.common2.bean.*;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.face.reader.base.DataReader;
import com.github.niupengyu.schedule.common2.face.writer.base.SaveWriter;
import com.github.niupengyu.schedule.common2.factory.TaskFlowFactory;
import com.github.niupengyu.schedule.common2.job.QuartzJob;
import com.github.niupengyu.schedule.common2.job.ThreadJob;
import com.github.niupengyu.schedule.common2.job.ThreadModel;
import com.github.niupengyu.schedule.common2.log.LoggerManager;
import com.github.niupengyu.schedule.common2.model.TaskFlow;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.beans.LocalTaskInfo;
import com.github.niupengyu.schedule.distributed.client.service.LocalTaskService;
import com.github.niupengyu.schedule.mains.dao.ScheduleDao;
import com.github.niupengyu.schedule.mains.dao.TableMapperDao;
import com.github.niupengyu.schedule.mains.util.QuartzManager;
import com.github.niupengyu.schedule.mains.util.ThreadPool;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.quartz.*;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service("mainService")
public class MainService implements LocalTaskService {

    private static final Logger logger= LoggerFactory.getLogger(MainService.class);

    private boolean independentRunningMode=true;

    @Resource(name="scheduler")
    private Scheduler scheduler;


    public static Map<String,ThreadModel> map=new HashMap<>();

    @Resource(name = "exceptionService")
    private ExceptionService exceptionService;

    @Resource(name = "taskInfoService")
    private TaskInfoService taskInfoService;

    @Resource(name = "connectionFactory")
    private ConnectionFactory connectionFactory;

    @Autowired
    private ScheduleDao scheduleDao;

    @Autowired
    private TableMapperDao tableMapperDao;

    @Resource(name = "moduleService")
    private ModuleService moduleService;

    public MainService() {

    }


    private void startTimerNow(TimerParam param) throws Exception {
        String name=param.getName();
        if(map.containsKey(name)){
            ThreadModel threadJob=map.get(name);
            if(threadJob.isRunning()){
                throw new Exception("正在运行");
            }
        }

        TaskTimer taskTimer=getTimer(name);
        ThreadModel runnable=null;
        runnable=new ThreadJob(param,taskTimer);
        map.put(name,runnable);
        ThreadPool.pools.execute(runnable);

    }

    private void startTimer(Object message) throws Exception {
        //getTimerInfo();
        TaskTimer taskTimer=this.getTimer(String.valueOf(message));

        Class<?> jobClass=Class.forName(taskTimer.getTimerpackage());
        QuartzManager.addJob(taskTimer.getName(),taskTimer.getJobGroup(),
                taskTimer.getTigger(),taskTimer.getTiggerGroup(),jobClass,taskTimer.getTime(),
                scheduler);

    }

    private void stopTimer(Object message) throws ClassNotFoundException, SchedulerException {
        TaskTimer taskTimer=this.getTimer(String.valueOf(message));
        QuartzManager.removeJob(taskTimer.getName(),taskTimer.getJobGroup(),
                taskTimer.getTigger(),taskTimer.getTiggerGroup(),
                scheduler);
        taskTimer.stop();
    }




    public boolean isIndependentRunningMode() {
        return independentRunningMode;
    }

    public void setIndependentRunningMode(boolean independentRunningMode) {
        //getTimerInfo();
        this.independentRunningMode = independentRunningMode;
    }



    public void startNow(TimerParam param) throws Exception  {
        if(isIndependentRunningMode()){
            startTimerNow(param);
        }else{
            throw new SysException("不是独立运行模式");
        }
    }

    public void startAll() throws Exception {
        //getTimerInfo();
//        Map<String,TaskTimer> map=quartzInit.getTimerMap();
        List<TaskTimer> list=this.getTimerList("","","","",0,0);
//        for(Map.Entry<String,TaskTimer> entry: map.entrySet()){
          for(TaskTimer taskTimer:list){
//            TaskTimer taskTimer=entry.getValue();
            Class<?> jobClass= null;
            jobClass = Class.forName(taskTimer.getTimerpackage());
            QuartzManager.addJob(taskTimer.getName(),taskTimer.getJobGroup(),
                    taskTimer.getTigger(),taskTimer.getTiggerGroup(),jobClass,taskTimer.getTime(),
                    scheduler);
        }
    }

    public TaskTimer getTimerInfo(String key){
        TaskTimer taskTimer=this.getTimer(key);
        return taskTimer;
    }

    public JSONObject getTimerInfos(String type,String jobName,String app,String bindTask,int page,int size){
        int start=PageUtil.start(page,size);
        int total=this.scheduleDao.total(type,jobName,app,bindTask);
        List<TaskTimer> list= this.getTimerList(type,jobName,app,bindTask,start,size);
        JSONObject obj=new JSONObject();
        obj.put("total",total);
        obj.put("list",list);
        return obj;
    }

    public List<TaskTimer> getAllTimerInfos(String name,String app,String bindTask){
        List<TaskTimer> list= this.scheduleDao.list("",name,app,bindTask,0,0);
        return list;
    }

    public void stop(String key) throws Exception{
        if(isIndependentRunningMode()){
            stopTimer(key);
        }else{
            throw new SysException("不是独立运行模式");
        }
    }

    public void restart(String id) {
        
    }


    public void add(TaskTimer taskTimer,String cron) throws Exception {
        //TaskTimer taskTimer=this.getTimer(key);
        if(StringUtil.isNull(taskTimer)){
            throw new Exception("未找到任务");
        }
        if(StringUtil.isNull(taskTimer.getTime())){
            throw new Exception("没有填写任务时间");
        }
        SaveWriter saveWriter=null;
        String bean=taskTimer.getBean();
        if(StringUtil.isNull(bean)){
            throw new Exception("没有填写bean对象");
        }
        Class<?> jobClass = QuartzJob.class;
        QuartzManager.addJob(taskTimer.getName(),taskTimer.getJobGroup(),
                taskTimer.getTigger(),taskTimer.getTiggerGroup(),jobClass,
                StringUtil.isNull(cron)?taskTimer.getTime():cron,
                scheduler);
    }

    public void add(String key,String cron) throws Exception {
        TaskTimer taskTimer=this.getTimer(key);
        add(taskTimer,cron);
    }

    public void remove(String key) throws SchedulerException {
        TaskTimer taskTimer=this.getTimer(key);
        QuartzManager.removeJob(taskTimer.getName(),taskTimer.getJobGroup(),
                taskTimer.getTigger(),taskTimer.getTiggerGroup(),scheduler);
    }

    public void removeall() throws SchedulerException {
//        Map<String,TaskTimer> map=quartzInit.getTimerMap();
        List<TaskTimer> list=this.getTimerList("","","","",0,0);

        //        for(Map.Entry<String,TaskTimer> entry: map.entrySet()){
        for(TaskTimer taskTimer:list){
//            TaskTimer taskTimer=entry.getValue();
            Class<?> jobClass= null;
            boolean flag=QuartzManager.removeJob(taskTimer.getName(),taskTimer.getJobGroup(),
                    taskTimer.getTigger(),taskTimer.getTiggerGroup(),scheduler);
            logger.info("flag "+flag);
        }
    }

    public String uppercase(String str){
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public List<TaskTimer> getTimerList(String type,String jobName,String app,String bindTask,int start,int size) {
        List<TaskTimer> list=scheduleDao.list(type,jobName,app,bindTask,start,size);
        for(int i=0;i<list.size();i++){
            TaskTimer timer=list.get(i);
            String name=timer.getName();
            String jobType=timer.getJobType();
            if(map.containsKey(name)){
                boolean run=map.get(name).isRunning();
                timer.setStatus(run);
            }
            if(StringUtil.notNull(timer.getTableId())&&!timer.getJobType().equals("CommonTask")){
                timer.setActive(moduleService.active(timer.getTableId(),timer.getBean()));
            }
            timer.init(scheduler);
        }
        return list;
    }

    public List<JSONObject> timer(){
        return scheduleDao.timer("TIMER");
    }

    public TaskTimer getTimer(String name) {
        return scheduleDao.getByName(name);
    }

    public TaskTimer getTimerById(String id) {
        return scheduleDao.getById(id);
    }


    public void stopNow(TimerParam param) {
        String name=param.getName();
        if(map.containsKey(name)){
            ThreadModel threadJob=map.get(name);
            if (threadJob.isRunning()){
                threadJob.setRunning(false);
            }
        }
    }

    public void resynchronization(String id) throws Exception {
        JSONObject errorData=exceptionService.selectBean(id);
        String bean=StringUtil.valueOf(errorData.get("bean"));
        if(StringUtil.isNull(bean)){
            throw new Exception("没有配置对应实例"+bean);
        }
        String type=errorData.getString("jobType");
        String tid=errorData.getString("tableId");
        String beanName=errorData.getString("bean");
        String name=errorData.getString("name");
        TimerParam param=TaskTimer.paramJson(errorData.getString("param"));
        TaskBean taskBean= TaskFlowFactory.taskBean(type,tid,beanName,name,0,param);
        taskBean.createModel();
        taskBean.init();
        LoggerManager.createLogger(name);
        JSONObject data=errorData.getJSONObject("data");
        //DataReader dataReader=taskBean.getDataReader();

        SaveWriter dataWriter=taskBean.getDataWriter();
        try{
            //dataWriter.init();
            //PrimaryKey primaryKey=dataWriter.goalId();
            //String v=data.getString(primaryKey.columnName());
            //primaryKey.value(v);
            PrimaryKey primaryKey=dataWriter.selectId(data);
                    //=dataReader.selectOne(data);
            taskBean.syncData(primaryKey);
            exceptionService.updateState(id,1);
        }catch(Exception e){
            e.printStackTrace();
            throw new SysException(e.getMessage());
        }finally{
            taskBean.end();
        }


    }

    public void resynchronizationPage(String id) throws Exception {
        JSONObject errorData=exceptionService.selectBean(id);
        String bean=StringUtil.valueOf(errorData.get("bean"));
        if(StringUtil.isNull(bean)){
            throw new Exception("没有配置对应实例"+bean);
        }
        String type=errorData.getString("jobType");
        String tid=errorData.getString("tableId");
        String beanName=errorData.getString("bean");
        String name=errorData.getString("name");

        JSONObject pageData=errorData.getJSONObject("data");
        final int batch=pageData.getIntValue("batch");
        final int page=pageData.getIntValue("startPage");
        final String startTime=pageData.getString("taskStart");
        final String endTime=pageData.getString("taskEnd");
        boolean isDay=pageData.getBooleanValue("isDay");
        final int size=pageData.getIntValue("size");
        int exeBatch=errorData.getIntValue("batch");
        //TimerParam param=TaskTimer.paramJson(errorData.getString("param"));
        TimerParam param=new TimerParam();
        param.setName(name);
        param.setPreviousFireTime(startTime);
        param.setNextFireTime(endTime);
        param.setDay(isDay);
        param.setBatch(batch);
        param.setStartPage(page);
        param.setSize(size);
        TaskInfo taskInfo=new TaskInfo(new Date(),name,startTime,endTime,"REPAGE");
        final String taskId=taskInfo.getId();
        final TaskFlow taskFlow = TaskFlowFactory.taskFlow(type,tid,beanName,name,exeBatch,param);
        LoggerManager.createLogger(name);
        taskInfoService.saveTaskInfo(taskInfo);
        Thread thread=new Thread(new Runnable(){
            @Override
            public void run() {
                try{
                    taskFlow.getTaskBean().init();
                    taskFlow.runSyncOne(startTime,endTime,taskId,size,page,batch);
                    taskInfoService.state(taskId,1);
                }catch(Exception e){
                    e.printStackTrace();
                } catch (StopException e) {
                    e.printStackTrace();
                } finally{
                    if(taskFlow!=null){
                        taskFlow.getTaskBean().end(taskId);
                    }
                }
            }
        });
        thread.start();
        exceptionService.updateState(id,1);
    }

    public void resynchronizationall(String id) throws Exception, StopException {
        List<JSONObject> errorDatas=exceptionService.listJson(id);
        resynchronizations(errorDatas);
    }

    public void resynchronizations(String[] ids) throws Exception, StopException {
        List<JSONObject> errorDatas=exceptionService.selectBeans(ids);
        resynchronizations(errorDatas);

    }

    public void resynchronizations(final List<JSONObject> errorDatas) throws Exception {
        //List<JSONObject> errorDatas=exceptionService.selectBeans(ids);
        if(StringUtil.listIsNull(errorDatas)){
            return;
        }
        JSONObject ed=errorDatas.get(0);
        String bean=StringUtil.valueOf(ed.getString("bean"));
        String name=ed.getString("name");
        int batch=ed.getIntValue("batch");
        String tid=ed.getString("tableID");
        String type=ed.getString("jobType");
        TimerParam param=TaskTimer.paramJson(ed.getString("param"));

        if(StringUtil.isNull(bean)){
            throw new Exception("没有找到对应实例"+bean);
        }
        String date= DateUtil.dateFormat();
        TaskInfo taskInfo=new TaskInfo(new Date(),name,date,date,"RESYNC");
        final String taskId = taskInfo.getId();
        final TaskBean taskBean=TaskFlowFactory.taskBean(type,tid,bean,name,batch,param);
        taskBean.createModel();
        LoggerManager.createLogger(name);
        taskInfoService.saveTaskInfo(taskInfo);
        Thread thread=new Thread(new Runnable(){
            @Override
            public void run() {
                //TaskBean taskBean=null;
                try{
                    taskBean.init();
                    //taskBean.syncDatas1(errorDatas,taskId);
                    for(JSONObject obj:errorDatas){
                        JSONObject data=obj.getJSONObject("data");
                        DataReader dataReader=taskBean.getDataReader();
                        Map<String,Object> newData=dataReader.selectOne(data);
                        taskBean.syncData(newData,taskId);
                    }

                    taskInfoService.state(taskId,1);
                }catch (Exception e){
                    e.printStackTrace();
                } finally {
                    if(taskBean!=null){
                        taskBean.end(taskId);
                    }
                }
            }
        });
        thread.start();
        exceptionService.updateStates(errorDatas,1);
    }

    private Map<String,Object> stringToMap(String str){
        str=str.substring(1,str.lastIndexOf("}"));
        String[] strs=str.split(",");
        Map<String,Object> objectMap=new HashMap<>();
        for(String s:strs){
            String[] s1=s.split("=");
            String key=s1[0].trim();
            String value=s1[1].trim();
            objectMap.put(key,value);
        }
        return objectMap;
    }

    public void deleteInfo(String id) {
        this.taskInfoService.deleteInfo(id);
    }

    public List<TaskInfo> searchdata(String id, String time) {

        return taskInfoService.list(id,time+" 00:00:00");
    }

    public void one(String id, PrimaryKey pk) throws Exception {
        TaskTimer taskTimer=this.getTimerById(id);
        String bean=taskTimer.getBean();
        if(StringUtil.isNull(bean)){
            throw new Exception("没有找到对应实例"+bean);
        }
        taskTimer.setBatch(0);
        TaskBean taskBean=TaskFlowFactory.taskBean(taskTimer,taskTimer.getParamJson());
        taskBean.createModel();
        taskBean.init();
        LoggerManager.createLogger(taskTimer.getName());
        taskBean.syncData(pk);
        taskBean.end();
    }

    public void interrupt(String name) throws UnableToInterruptJobException {
        TaskTimer taskTimer=this.getTimer(name);
        String name1=taskTimer.getName();
        String group=taskTimer.getJobGroup();
        QuartzManager.interrupt(scheduler,name1,group);
    }

    public JSONArray local() throws SchedulerException {
        List<JobExecutionContext> list=scheduler.getCurrentlyExecutingJobs();
        JSONArray jsonArray=new JSONArray();
        for(JobExecutionContext job:list){
            JSONObject jsonObjec=new JSONObject();
            jsonObjec.put("fireTime",job.getFireTime());
            jsonObjec.put("previousFireTime",job.getPreviousFireTime());
            jsonObjec.put("nextFireTime",job.getNextFireTime());
            jsonArray.add(jsonObjec);
        }
        return jsonArray;
    }

    public Map<String, DataSourceBean>  getDb() {
        return connectionFactory.dbMap();
    }

    public List<DbInfo>  getDbs() {
        return this.tableMapperDao.selectDB();
    }

    public void bindTask(String name) throws SysException {

        String id= ServiceUtil.serialNumber();
        System.out.println(name+" "+id);
        TaskTimer taskTimer=this.getTimer(name);
        String binding=taskTimer.getBinding();
        if(StringUtil.isNull(binding)){
            this.scheduleDao.updateBinding(name,id);
        }else{
            throw new SysException("已绑定 ["+binding+"]");
        }
    }

    public void disbindTask(String name) throws SysException {

        String id=ServiceUtil.serialNumber();
        TaskTimer taskTimer=this.getTimer(name);
        String binding=taskTimer.getBinding();
        if(binding!=null&&binding.equals(id)){
            this.scheduleDao.updateBinding(name,"");
        }else{
            throw new SysException("解绑数据失败 ["+binding+"]");
        }
    }



    public List<Table> tableInfo(String type) {
        //int count=tableMapperDao.scheduleTable();
        //if(count>0){
        if("not".equals(type)){
            return this.tableMapperDao.tableInfosNot();
        }else if("has".equals(type)){
            return this.tableMapperDao.tableInfosHas();
        }else{
            return this.tableMapperDao.tableInfos();
        }
        //}
        //return this.tableMapperDao.tableInfos();
    }

    public void savesch(TaskTimer taskTimer,String tableInfo) throws SysException {
        String name=taskTimer.getName();
        if(StringUtil.isNull(name)){
            throw new SysException("任务名不能为空");
        }
        TaskTimer tt=this.scheduleDao.getByName(name);
        //String name=randomName(taskTimer);
        if(tt!=null){
            throw new SysException("任务名已存在");
        }
        taskTimer.setId(IdGeneratorUtil.uuid32());
        taskTimer.setBean("CommonTask");
        taskTimer.setTableId(taskTimer.getTableId());
        //taskTimer.setName(name);
        this.scheduleDao.saveTaskTimer(taskTimer);
        Table table=this.tableMapperDao.tableInfo(tableInfo);
        System.out.println("table"+table.isComparesj());
        if(table.isComparesj()&&!"COMPARE".equals(taskTimer.getJobType())){
            TaskTimer taskTimer1=new TaskTimer();
            taskTimer1.setId(IdGeneratorUtil.uuid32());
            taskTimer1.setApp(taskTimer.getApp());
            taskTimer1.setName(name+"C");
            taskTimer1.setBean("CommonTask");
            taskTimer1.setTableId(taskTimer.getTableId());
            taskTimer1.setSize(taskTimer.getSize());
            taskTimer1.setTime(taskTimer.getTime());
            taskTimer1.setTigger(taskTimer.getTigger()+"C");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setJobType("COMPARE");
            taskTimer1.setJobDesc(taskTimer.getJobDesc()+"对账");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setJobGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setBatch(taskTimer.getBatch());
            this.scheduleDao.saveTaskTimer(taskTimer1);
        }
    }

    public void saveschedule(TaskTimer taskTimer,String moduleid,String compare) throws SysException {
        String name=taskTimer.getName();
        if(StringUtil.isNull(name)){
            throw new SysException("任务名不能为空");
        }
        if(StringUtil.isNull(taskTimer.getBean())){
            throw new SysException("未选择Bean");
        }
        TaskTimer tt=this.scheduleDao.getByName(name);
        //String name=randomName(taskTimer);
        if(tt!=null){
            throw new SysException("任务名已存在");
        }
        taskTimer.setId(IdGeneratorUtil.uuid32());

        taskTimer.setTableId(moduleid);
        //taskTimer.setName(name);
        this.scheduleDao.saveTaskTimer(taskTimer);
        if("COMPARE".equals(compare)&&!"COMPARE".equals(taskTimer.getJobType())){
            TaskTimer taskTimer1=new TaskTimer();
            taskTimer1.setId(IdGeneratorUtil.uuid32());
            taskTimer1.setApp(taskTimer.getApp());
            taskTimer1.setName(name+"C");
            taskTimer1.setBean(taskTimer.getBean());
            taskTimer1.setTableId(taskTimer.getTableId());
            taskTimer1.setSize(taskTimer.getSize());
            taskTimer1.setTime(taskTimer.getTime());
            taskTimer1.setTigger(taskTimer.getTigger()+"C");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setJobType(compare);
            taskTimer1.setJobDesc(taskTimer.getJobDesc()+"对账");
            taskTimer1.setTiggerGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setJobGroup(taskTimer.getTiggerGroup()+"C");
            taskTimer1.setBatch(taskTimer.getBatch());
            taskTimer1.setBeforeHour(0);
            this.scheduleDao.saveTaskTimer(taskTimer1);
        }
    }

    private String randomName(TaskTimer taskTimer) {
        String desc=taskTimer.getJobDesc();
        String name=taskTimer.getName();
        String py=PinYin2Abbreviation.cn2py(desc);
        if(py.length()>20){
            py=py.substring(20);
        }
        return py+"_"+DateUtil.dateFormat("yyyyMMdd");
    }

    public void genCode(String id, String type) throws SysException {
        Table table=tableMapperDao.tableInfo(id);
        if(table!=null){
            throw new SysException("别偷懒，多动手。");
        }
    }




    public Map<String,String> one(String task) throws Exception {
        TaskTimer taskTimer=getTimerById(task);
        //String bean=taskTimer.getBean();
        TaskBean taskBean=TaskFlowFactory.taskBean(taskTimer,taskTimer.getParamJson());
        return taskBean.getDataWriter().goalId().primaryMap();
    }

    public List<TaskTimer> bindingList(String id) {
        return this.scheduleDao.bindingList(id);
    }

    public List<TaskTimer> bindingList(String id,boolean start) {
        return this.scheduleDao.bindingStartList(id,start);
    }

    public List<JSONObject> supportDb() {
        return this.scheduleDao.supportDb();
    }

    public List<JSONObject> supportDialect(String type) {
        return this.scheduleDao.supportDialect(type);
    }

    public List<String> getApps() {
        return this.scheduleDao.getApps();
    }

    @Override
    public List<LocalTaskInfo> taskInfos() throws Exception {
        List<LocalTaskInfo> list=new ArrayList<>();
        Set<JobKey> jobKeySet = scheduler.getJobKeys(GroupMatcher.anyJobGroup());
        for(JobKey jobKey:jobKeySet){
            String job=jobKey.getName();
            LocalTaskInfo localTaskInfo=new LocalTaskInfo();
            localTaskInfo.setScheduleName(job);
            list.add(localTaskInfo);
        }
        for(Map.Entry<String,ThreadModel> entry:map.entrySet()){
            if(entry.getValue().isRunning()){
                LocalTaskInfo localTaskInfo=new LocalTaskInfo();
                localTaskInfo.setScheduleName(entry.getKey());
                list.add(localTaskInfo);
            }
        }
        /*Set<TriggerKey> triggerKeySet=scheduler.getTriggerKeys(GroupMatcher.anyTriggerGroup());
        for(TriggerKey tk:triggerKeySet){
            LocalTaskInfo localTaskInfo=new LocalTaskInfo();
            Trigger t=scheduler.getTrigger(tk);
            if(t!=null){
                localTaskInfo.set
                startTime= value(t.getStartTime());
                nextFireTime=value(t.getNextFireTime());
                previousFireTime=value(t.getPreviousFireTime());
                endTime=value(t.getEndTime());
                this.state=scheduler.getTriggerState(tk).name();
            }else{

            }
        }*/

        return list;
    }

    public void setOpen(boolean open,String name) {
        this.scheduleDao.updateOpen(open,name);
    }

    public void updateSch(TaskTimer taskTimer) {
        System.out.println(taskTimer);
        this.scheduleDao.updateTimer(taskTimer);
    }
}
