package com.github.niupengyu.schedule.mains.service;

import com.github.niupengyu.commons.poi.ExcelReadCallBack;
import com.github.niupengyu.commons.poi.ReadExcelTools;
import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.DateUtil;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.PageUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.jdbc.dao.JdbcDao;
import com.github.niupengyu.jdbc.dao.JdbcUtil;
import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.common2.bean.common.*;
import com.github.niupengyu.schedule.common2.face.conversion.ExeFace;
import com.github.niupengyu.schedule.common2.face.reader.base.DataReader;
import com.github.niupengyu.schedule.common2.face.writer.base.SaveWriter;
import com.github.niupengyu.schedule.common2.factory.ExeFactory;
import com.github.niupengyu.schedule.common2.factory.SqlFactory;
import com.github.niupengyu.schedule.common2.factory.TaskFlowFactory;
import com.github.niupengyu.schedule.common2.factory.db.DBMetadata;
import com.github.niupengyu.schedule.common2.factory.dialect.GenSqlDialect;
import com.github.niupengyu.schedule.common2.factory.dialect.TargetGenSqlDialect;
import com.github.niupengyu.schedule.common2.log.LoggerManager;
import com.github.niupengyu.schedule.common2.service.CommonTaskBeanService;
import com.github.niupengyu.schedule.common2.service.FileTaskBeanService;
import com.github.niupengyu.schedule.common2.service.TaskBean;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.common2.util.ModelType;
import com.github.niupengyu.schedule.mains.dao.ExcelDao;
import com.github.niupengyu.schedule.mains.util.TableSql;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.sql.DataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.*;


@Service("excelService")
public class ExcelService {

    @Resource(name = "scheduleDBDataSource")
    private DataSource dataSource;

    //private Map<String,String> fileMap=new HashMap<>();

    @Resource(name = "taskInfoService")
    private TaskInfoService taskInfoService;

    @Autowired
    private ExcelDao excelDao;

    public JSONArray upload(MultipartFile multipartFile,int sheetNum,int rowNum) throws SysException {
        final JSONArray jsonArray=new JSONArray();
        try(InputStream inputStream=multipartFile.getInputStream()){
            ReadExcelTools readExcelTools=
                    new ReadExcelTools(inputStream,multipartFile.getOriginalFilename(),sheetNum,rowNum,rowNum+1);
            readExcelTools.readExcel( new ExcelReadCallBack() {
                @Override
                public void read(String fileName, int sheetNum,int rowNum, String[] list) {
                    jsonArray.add(list);
                }
            });
        }catch (Exception e){
            e.printStackTrace();
            throw new SysException("系统异常");
        }
        return jsonArray;
    }

    public JSONObject upload(File file,String oriFileName,int sheetNum,int rowNum) throws SysException {
        final JSONArray jsonArray=new JSONArray();

        try(FileInputStream inputStream=new FileInputStream(file)){
            ReadExcelTools readExcelTools=new ReadExcelTools(inputStream,oriFileName,sheetNum,rowNum,rowNum+1);

            readExcelTools.readExcel(new ExcelReadCallBack() {
                @Override
                public void read(String fileName, int sheetNum,int rowNum, String[] list) {
                    jsonArray.add(list);
                }
            });
        }catch (Exception e){
            e.printStackTrace();
            throw new SysException("系统异常");
        }
        JSONObject data=new JSONObject();
        data.put("list",jsonArray);
        data.put("file",file.getName());
        data.put("fileName",oriFileName);
        return data;
    }

    /*public static void main(String[] args) throws SysException {
        JSONArray jsonArray=new JSONArray();
        ReadExcelTools readExcelTools=new ReadExcelTools(1,0,0+1);
        try(InputStream inputStream=new FileInputStream(new File("D:\\data\\实有人口账户信息(含密码明文).xlsx"))){
            readExcelTools.readExcel(inputStream, "实有人口账户信息(含密码明文).xlsx", new ExcelReadCallBack() {
                @Override
                public void read(String fileName, int sheetNum, String[] list) {
                    jsonArray.add(list);
                }
            });
            System.out.println(jsonArray);
        }catch (Exception e){
            e.printStackTrace();
            throw new SysException("系统异常");
        }

    }*/

    /*public void save(String isUpdate, List<Column> columns,String fileName) {
        JdbcUtil jdbcUtil=null;
        try {
            jdbcUtil=new JdbcUtil(dataSource.getConnection());

        } catch (SQLException e) {
            e.printStackTrace();
        }finally{
            JdbcUtil.close(jdbcUtil);
        }

    }*/

    public void genCode(CodeInfo createInfo, List<Column> columns,String exenow,String savenow,String basePath,String filePath,
                        int rowNum,int sheetNum,int batch,String fileName) throws Exception{


        CreateInfo target=createInfo.getTarget();
        DBMetadata targetSql=SqlFactory.getType(target,taskInfoService);
        DbInfo targetDbInfo=targetSql.getDbInfo();
        createInfo.setSyncName("excel-"+createInfo.getSyncName());
        createInfo.setSyncMode("excel");
        Table table=new Table(target,createInfo);
        table.setDbComponent("excel");

        TargetGenSqlDialect targetGenSql=SqlFactory.targetGen(createInfo,targetDbInfo,columns);


        if(StringUtil.booleanValueOf(savenow,false)){
            JdbcUtil jdbcUtil=null;
            String pagec=null;
            String listc=null;
            String countc=null;

            String has=targetGenSql.has();
            String update=targetGenSql.update();
            String delete=targetGenSql.delete();
            String insert=targetGenSql.insert();
            String total=targetGenSql.total();
            String deletes=targetGenSql.deleteIn();
            String allList=targetGenSql.allList();
            try {
                jdbcUtil=new JdbcUtil(dataSource.getConnection());
                Object[] vars=new Object[]{table.getId(),table.getTargetDb(),table.getDb(),table.getTn()
                        ,table.getModel(),table.isPage(),table.isBatch(),table.isGxsjc()
                        ,table.isComparesj(),table.getComparesjValue(),table.getTtn(),"",table.getName(),1
                        ,table.getSyncMode(),table.getPk(),table.getTargetpk(),table.isMin()
                        ,table.getMinsj(),table.isPkReplace(),table.getTdbComponent(),table.getDbComponent()
                        ,table.getGxsjcValue(),table.getTargetComparesjValue(),table.getModel(),table.isTimeOrder()
                        ,table.getOwner(),table.getTargetOwner()};
                jdbcUtil.execute(TableSql.insertExcel,vars);

                vars=new Object[]{IdGeneratorUtil.uuid32(),table.getId(),"","",countc,pagec,"","",has,update
                        ,delete,insert,total,deletes,createInfo.getMinsj(),"",listc,allList};
                jdbcUtil.execute(TableSql.insertSql,vars);
                int i=1;
                List<Object[]> var=new ArrayList<>();
                for(Column column:columns){
                    Object[] v=new Object[]{IdGeneratorUtil.uuid32(),table.getId(),column.getName1()
                            ,column.getDataType(),column.getKey1(),column.getDefaultValue()
                            ,column.isPk(),column.getState(),column.getIndex1(),column.isUpdate1()
                            ,column.isSelect1(),column.isGxsjc(),column.isCompare(),column.isConvertData()
                            ,column.getSourceType(),column.getFormat()};
                    var.add(v);
                }
                jdbcUtil.executeBatch(TableSql.insertColumn,var);
                jdbcUtil.commit();
            } catch (Exception e) {
                JdbcUtil.rollBack(jdbcUtil);
                e.printStackTrace();
                throw new SysException(e.getMessage());
            }finally {
                JdbcUtil.close(jdbcUtil);
            }
        }
        if(StringUtil.booleanValueOf(exenow,false)){
            Sql sql=new Sql(table,targetGenSql);
            this.exe(table,columns,sql,basePath,filePath,rowNum,sheetNum,fileName,batch);
        }

    }

    private void exe(final Table table, final List<Column> columns,
                     final Sql sql, String basePath, String filePath, final int rowNum, final int sheetNum, final String fileName
    , final int batch) throws Exception {
        String date= DateUtil.dateFormat();
        TaskInfo taskInfo=new TaskInfo(new Date(),fileName,date,date,"FILE-EXCEL");
        final String taskId = taskInfo.getId();
        LoggerManager.createLogger(fileName);
        taskInfoService.saveTaskInfo(taskInfo);
        System.out.println(table.getPk());

        final File file=new File(basePath+filePath);
        System.out.println(file.getPath());

        Thread thread=new Thread(new Runnable(){
            @Override
            public void run() {
                try(InputStream input=new FileInputStream(file)){
                    ReadExcelTools readExcelTools=new ReadExcelTools(input,fileName, sheetNum,rowNum+1);
                    //List<Map<String,Object>> data=new ArrayList<>();
                    TimerParam timerParam=new TimerParam();
                    timerParam.setBatch(batch);
                    final TaskBean taskBean=new FileTaskBeanService("file",table,columns,sql,fileName,batch,timerParam,taskInfoService);
                    taskBean.init();
                    readExcelTools.readExcel(new ExcelReadCallBack() {
                        @Override
                        public void read(String fileName, int sheetNum,int rowNum, String[] list) {
                            //System.out.println(Arrays.toString(list));
                            int length=list.length;
                            Map<String,Object> map=new HashMap<>();
                            for(Column column:columns){
                                String name=column.getName1();
                                int i=name.lastIndexOf("-");
                                int index=StringUtil.integerValueOf(name.substring(i+1),0);
                                if(index<length){
                                    map.put(column.getName1(),list[index]);
                                }else{
                                    map.put(column.getName1(),null);
                                }
                            }
                            //System.out.println(map);
                            try {
                                taskBean.syncData(map,taskId);
                                //exeFace.exe(map,taskId);
                            } catch (Exception e) {
                                LoggerManager.error(fileName,"什么情况 同步失败"+map,e);
                                taskInfoService.exceptionInfo(map,taskId,e.getMessage(),1);
                            }
                        }
                    });
                    taskBean.end(taskId);
                }catch (Exception e){
                    e.printStackTrace();
                    LoggerManager.info(fileName,"异常");
                    taskInfoService.exceptionInfo("",taskId,e.getMessage());
                }finally {
                    LoggerManager.info(fileName,"结束");
                    taskInfoService.state(taskId,1);
                }

            }
        });
        thread.start();

    }


    public JSONObject excelInfo(int page,int size) {
        int start= PageUtil.start(page,size);
        int total=this.excelDao.total();
        List<Map<String,Object>> list=this.excelDao.excelInfos(start,size);
        JSONObject obj=new JSONObject();
        obj.put("total",total);
        obj.put("list",list);
        return obj;
    }

    public static void main(String[] args) {
        String str="ssdfsf-sdfsdf-sdf";
        int index=str.lastIndexOf("-");
        System.out.println(str.substring(0,index));
        System.out.println(str.substring(index+1));
    }
}
