package com.github.niupengyu.schedule.mains.init;

import com.github.niupengyu.core.init.InitService;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service("quartzInit")
public class QuartzInit implements InitService{

    private static final Logger logger= LoggerFactory.getLogger(QuartzInit.class);

    @Resource(name="mainService")
    private MainService mainService;

    @Resource(name = "mapperService")
    private MapperService mapperService;

    @Resource(name = "moduleService")
    private ModuleService moduleService;

    @Override
    public void run(ApplicationArguments applicationArguments) {
        // 查询绑定  设置为开机启动的
        try {
            List<TaskTimer> list=mainService.bindingList(ServiceUtil.serialNumber(),true);
            logger.info("获取绑定列表["+list.size()+"]");
            for(TaskTimer taskTimer:list){
                if("STOP".equals(taskTimer.getState())){//停用状态的不启动
                    continue;
                }
                mainService.add(taskTimer,taskTimer.getTime());
                logger.info("启动任务["+taskTimer.getName()+"]");
            }
        } catch (Exception e) {
            //e.printStackTrace();
            logger.error("开机启动失败",e);
        }
        try{
            mapperService.initdb();
        }catch(Exception e){
            //e.printStackTrace();
            logger.error("数据库信息初始化失败",e);
        }
        try{
            moduleService.initModules();
        }catch (Exception e){
            e.printStackTrace();
            logger.error("模块初始化失败",e);
        }

    }

}
