package com.github.niupengyu.schedule.mains.dao;

import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import org.apache.ibatis.annotations.*;

import java.util.Date;
import java.util.List;

public interface TaskInfoDao {


    @Insert("insert into guiyjz_schedule_task(task_id,task_schedule,task_state,task_start" +
            ",task_end,task_total,task_success,task_error,task_previous,task_next,task_type,task_insert,task_update" +
            ",task_delete,task_real_total) " +
            "values(#{id},#{schedule},#{state},#{start},#{end},#{total},#{success},#{error},#{previous},#{next},#{type}," +
            "#{insertSuccess},#{updateSuccess},#{deleteSuccess},#{realTotal})")
    public void insertTask(TaskInfo taskInfo);

    @Update("update guiyjz_schedule_task set task_success=task_success+#{num} where task_id=#{id}")
    public void success(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_error=task_error+#{num} where task_id=#{id}")
    public void error(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_total=#{num} where task_id=#{id}")
    public void total(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_total=task_total+#{num} where task_id=#{id}")
    public void addTotal(@Param("id") String id, @Param("num") int num);

    //@Update("update guiyjz_schedule_task set task_state=#{state},task_end=#{end},task_real_total=#{total} where task_id=#{id}")
    //public void state(@Param("id") String id, @Param("state") int state, @Param("end") Date end, @Param("total") int total);

    @Update("update guiyjz_schedule_task set task_real_total=task_real_total+#{total} where task_id=#{id}")
    public void updateTealTotal(@Param("id") String id, @Param("total") int total);

    @Update("update guiyjz_schedule_task set task_state=#{state},task_end=#{end} where task_id=#{id}")
    public void state(@Param("id") String id, @Param("state") int state, @Param("end") Date end);

    @Update("update guiyjz_schedule_task set task_page_total=#{num} where task_id=#{id}")
    public void taskPageTotal(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_local_page=#{page} where task_id=#{id}")
    public void updatePage(@Param("id") String id, @Param("page") int page);

    @Select("select task_id as id," +
            "task_schedule as schedule," +
            "task_type as type," +
            "task_state as state," +
            "task_start as start," +
            "task_end as end," +
            "task_total as total," +
            "task_success as success," +
            "task_insert as insertSuccess," +
            "task_update as updateSuccess," +
            "task_delete as deleteSuccess," +
            "task_real_total as realTotal," +
            "task_error as error," +
            "task_previous as previous," +
            "task_next as next," +
            "task_local_page as localPage," +
            "task_total_batches as totalBatches," +
            "task_current_batch as currentBatch," +
            "task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage from guiyjz_schedule_task where task_schedule=#{name} " +
            "and task_start >= #{time} " +
            "order by task_start desc")
    public List<TaskInfo> list(@Param("name") String name, @Param("time") String time);


    @Select("select task_id as id," +
            "task_schedule as schedule," +
            "task_type as type," +
            "task_state as state," +
            "task_start as start," +
            "task_end as end," +
            "task_total as total," +
            "task_success as success," +
            "task_insert as insertSuccess," +
            "task_update as updateSuccess," +
            "task_delete as deleteSuccess," +
            "task_real_total as realTotal," +
            "task_error as error," +
            "task_previous as previous," +
            "task_next as next," +
            "task_local_page as localPage," +
            "task_total_batches as totalBatches," +
            "task_current_batch as currentBatch," +
            "task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage from guiyjz_schedule_task where task_schedule=#{name} " +
            "and task_start >= #{time} and task_start<=#{end}" +
            "order by task_start desc")
    public List<TaskInfo> dayList(@Param("name") String name, @Param("time") String time, @Param("end") String end);


    @Select("<script>" +
            "select task_id as id," +
            "task_schedule as schedule," +
            "task_type as type," +
            "task_state as state," +
            "task_start as start," +
            "task_end as end," +
            "task_total as total," +
            "task_success as success," +
            "task_insert as insertSuccess," +
            "task_update as updateSuccess," +
            "task_delete as deleteSuccess," +
            "task_real_total as realTotal," +
            "task_error as error," +
            "task_previous as previous," +
            "task_next as next," +
            "task_local_page as localPage," +
            "task_total_batches as totalBatches," +
            "task_current_batch as currentBatch," +
            "task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage from guiyjz_schedule_task t left join " +
            "guiyjz_schedule s on s.schedule_name=t.task_schedule where " +
            " 1=1 " +
            "<if test=\"taskstate=='now'\">" +
            " and task_state=0 " +
            "</if>" +
            "<if test=\"app!='' and app!=null\">" +
            " and schedule_app = #{app} " +
            "</if>" +
            "<if test=\"name!='' and name!=null\">" +
            " and task_schedule=#{name} " +
            "</if>" +
            "<if test=\"tasktype=='error'\">" +
            " and (task_error&gt;0 " +
            " or task_success&lt;1) " +
            "</if>" +
            "<if test=\"timeFrame=='day'\">" +
            "and task_start &gt;= #{time} and task_start&lt;=#{end}" +
            "</if>" +
            "order by task_start desc" +
            "</script>")
    public List<TaskInfo>  dayNowList(@Param("app") String app,@Param("name") String name, @Param("timeFrame") String timeFrame,
                                      @Param("taskstate") String taskstate, @Param("tasktype") String tasktype,
                                      @Param("time") String time, @Param("end") String end);

    @Select("<script>" +
            "select task_id as id," +
            "task_schedule as schedule," +
            "task_type as type," +
            "task_state as state," +
            "date_format(task_start,'%Y-%m-%d %T') as start," +
            "date_format(task_end,'%Y-%m-%d %T') as end," +
            "task_total as total," +
            "task_success as success," +
            "task_insert as insertSuccess," +
            "task_update as updateSuccess," +
            "task_delete as deleteSuccess," +
            "task_real_total as realTotal," +
            "task_error as error," +
            "date_format(task_previous,'%Y-%m-%d %T') as previous," +
            "date_format(task_next,'%Y-%m-%d %T') as next," +
            "task_local_page as localPage," +
            "task_total_batches as totalBatches," +
            "task_current_batch as currentBatch," +
            "task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage from guiyjz_schedule_task t left join " +
            "guiyjz_schedule s on s.schedule_name=t.task_schedule where " +
            " 1=1 " +
            "<if test=\"taskstate=='now'\">" +
            " and task_state=0 " +
            "</if>" +
            "<if test=\"app!='' and app!=null\">" +
            " and schedule_app = #{app} " +
            "</if>" +
            "<if test=\"name!='' and name!=null\">" +
            " and task_schedule=#{name} " +
            "</if>" +
            "<if test=\"tasktype=='error'\">" +
            " and (task_error&gt;0 " +
            " or task_success&lt;1) " +
            "</if>" +
            "<if test=\"timeFrame=='day'\">" +
            "and task_start &gt;= #{time} and task_start&lt;=#{end}" +
            "</if>" +
            "order by task_start desc" +
            " limit #{page},#{size}"+
            "</script> "
            )
    public List<TaskInfo>  dayNowPageList(@Param("app") String app,@Param("name") String name, @Param("timeFrame") String timeFrame,
                                      @Param("taskstate") String taskstate, @Param("tasktype") String tasktype,
                                      @Param("time") String time, @Param("end") String end,
                                          @Param("page") int page, @Param("size") int size);

    @Select("<script>" +
            "select count(*) from guiyjz_schedule_task t left join " +
            "guiyjz_schedule s on s.schedule_name=t.task_schedule where " +
            " 1=1 " +
            "<if test=\"taskstate=='now'\">" +
            " and task_state=0 " +
            "</if>" +
            "<if test=\"app!='' and app!=null\">" +
            " and schedule_app = #{app} " +
            "</if>" +
            "<if test=\"name!='' and name!=null\">" +
            " and task_schedule=#{name} " +
            "</if>" +
            "<if test=\"tasktype=='error'\">" +
            " and (task_error&gt;0 " +
            " or task_success&lt;1) " +
            "</if>" +
            "<if test=\"timeFrame=='day'\">" +
            "and task_start &gt;= #{time} and task_start&lt;=#{end}" +
            "</if>" +
            "order by task_start desc" +
            "</script>")
    public int  dayNowPageCount(@Param("app") String app,@Param("name") String name, @Param("timeFrame") String timeFrame,
                                      @Param("taskstate") String taskstate, @Param("tasktype") String tasktype,
                                      @Param("time") String time, @Param("end") String end);

    @Select("select task_id as id," +
            "task_schedule as schedule," +
            "task_type as type," +
            "task_state as state," +
            "task_start as start," +
            "task_end as end," +
            "task_total as total," +
            "task_success as success," +
            "task_insert as insertSuccess," +
            "task_update as updateSuccess," +
            "task_delete as deleteSuccess," +
            "task_real_total as realTotal," +
            "task_error as error," +
            "task_previous as previous," +
            "task_next as next," +
            "task_local_page as localPage," +
            "task_total_batches as totalBatches," +
            "task_current_batch as currentBatch," +
            "task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage " +
            "from guiyjz_schedule_task where task_schedule=#{name} and task_error>0 " +
            "order by task_start desc")
    public List<TaskInfo> dayErrorList(@Param("name") String name);



    @Update("update guiyjz_schedule_task set task_total_batches=#{day}," +
            "task_all_total=#{batchTotal},task_target_total=#{target} where task_id=#{id}")
    void updateBatch(@Param("day") long day, @Param("batchTotal") int batchTotal
            , @Param("id") String id, @Param("target") long target);

    @Update("update guiyjz_schedule_task set task_current_batch=#{day} where task_id=#{id}")
    void updateCurrentBatch(@Param("day") long day, @Param("id") String id);

    @Update("update guiyjz_schedule_task set task_current_batch=task_current_batch+#{day} where task_id=#{id}")
    void updateAddCurrentBatch(@Param("day") long day, @Param("id") String id);

    @Delete("delete from guiyjz_schedule_task where task_id=#{id}")
    void deleteInfo(String id);

    @Update("update guiyjz_schedule_task set task_insert=task_insert+#{num} where task_id=#{id}")
    public void insert(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_update=task_update+#{num} where task_id=#{id}")
    public void update(@Param("id") String id, @Param("num") int num);

    @Update("update guiyjz_schedule_task set task_insert=task_insert+#{num},task_success=task_success+#{success} where task_id=#{id}")
    public void insertSuccess(@Param("id") String id, @Param("num") int num, @Param("success") int success);

    @Update("update guiyjz_schedule_task set task_update=task_update+#{num},task_success=task_success+#{success} where task_id=#{id}")
    public void updateSuccess(@Param("id") String id, @Param("num") int num, @Param("success") int success);

    @Update("update guiyjz_schedule_task set task_update=task_update+#{upd},task_insert=task_insert+#{num}," +
            "task_success=task_success+#{success} where task_id=#{id}")
    void insertUpdateSuccess(@Param("id") String id, @Param("num") int num,
                             @Param("upd") int upd, @Param("success") int success);

    @Update("update guiyjz_schedule_task set task_update=task_update+#{upd}," +
            "task_insert=task_insert+#{num}," +
            "task_delete=task_delete+#{num}," +
            "task_success=task_success+#{success} where task_id=#{id}")
    void insertUpdateDeleteSuccess(@Param("id") String id, @Param("num") int num,
                                   @Param("upd") int upd, @Param("del") int del, @Param("success") int success);


    @Update("update guiyjz_schedule_task set task_delete=task_delete+#{num} where task_id=#{id}")
    void updateDelete(@Param("id") String id, @Param("num") int num);


    @Select("select " +
            "t.task_id as id," +
            "t.task_schedule as schedule," +
            "t.task_type as type," +
            "t.task_state as state," +
            "t.task_start as start," +
            "t.task_end as end," +
            "t.task_total as total," +
            "t.task_success as success," +
            "t.task_insert as insertSuccess," +
            "t.task_update as updateSuccess," +
            "t.task_delete as deleteSuccess," +
            "t.task_real_total as realTotal," +
            "t.task_error as error," +
            "t.task_previous as previous," +
            "t.task_next as next," +
            "t.task_local_page as localPage," +
            "t.task_total_batches as totalBatches," +
            "t.task_current_batch as currentBatch," +
            "t.task_all_total as batchTotal," +
            "task_target_total as targetTotal," +
            "if(task_end is null,task_success/TIMESTAMPDIFF(MINUTE,task_start,NOW())," +
            "task_success/TIMESTAMPDIFF(MINUTE,task_start,task_end)) as speed, "+
            "task_page_total as totalPage " +
            "from guiyjz_schedule_task t,(" +
            "select s.schedule_name,s.schedule_table " +
            "from guiyjz_schedule s,(" +
            "select t.table_id " +
            "from guiyjz_schedule_table t,guiyjz_schedule_db d " +
            "where t.table_db=d.db_id and d.db_name=#{name}) t " +
            "where t.table_id=s.schedule_table) s " +
            "where s.schedule_name=t.task_schedule and t.task_state=0 " +
            "order by t.task_start desc")
    List<TaskInfo> taskInfo(@Param("name") String name);

    /**
     * "task_schedule as schedule," +
     "task_type as type," +
     "task_state as state," +
     "date_format(task_start, '%Y-%m-%d %H:%m:%S') as start," +
     "date_format(task_end, '%Y-%m-%d %H:%m:%S') as end," +
     "task_total as total," +
     "task_success as success," +
     "task_error as error," +
     "date_format(task_previous, '%Y-%m-%d %H:%m:%S') as previous," +
     "date_format(task_next, '%Y-%m-%d %H:%m:%S') as next," +
     "task_local_page as localPage," +
     "task_page_total as totalPage from guiyjz_schedule_task where task_schedule=#{name} " +
     */
}
