package com.github.niupengyu.schedule.mains.dao;

import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import com.github.niupengyu.schedule.common2.bean.common.Sql;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.*;

import java.util.List;
import java.util.Map;

public interface TableMapperDao {


    @Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state<>0")
    List<DbInfo> selectDB();


    @Insert("insert into guiyjz_schedule_db(db_id,db_driver,db_url,db_username,db_password,db_owner," +
            "db_state,db_type,db_alias,db_name) " +
            "values(#{id},#{driver},#{url},#{username},#{password},#{owner},#{state},#{type},#{dbAlias},#{dbName})")
    void saveDb(DbInfo dbInfo);

    @Select("select count(schedule_table) from guiyjz_schedule")
    int scheduleTable();

    @Select("select table_id as id,table_name as name from guiyjz_schedule_table where table_state<>0")
    List<Table> tableInfos();

    @Select("select * from (select t.table_id as id,t.table_name as name,s.schedule_table " +
            "from guiyjz_schedule_table t LEFT JOIN guiyjz_schedule s " +
            "on s.schedule_table=t.table_id where s.schedule_type<>'COMPARE' OR s.schedule_type IS NULL) t where schedule_table is null")
    List<Table> tableInfosNot();

    @Select("select * from (select t.table_id as id,t.table_name as name,s.schedule_table " +
            "from guiyjz_schedule_table t LEFT JOIN guiyjz_schedule s " +
            "on s.schedule_table=t.table_id where s.schedule_type<>'COMPARE') t where schedule_table is not null")
    List<Table> tableInfosHas();

    @Select("select table_id as id,table_name as name,table_tn as tn,table_ttn as ttn," +
            "table_tdbcomponent as tdbComponent,table_dbcomponent as dbComponent,"+
            "table_ispage as page,table_iscomparesj as comparesj," +
            "table_comparesj as comparesjValue," +
            "table_target_comparesj as targetComparesjValue," +
            "table_isbatch as batch," +
            "table_ismin as min,table_minsj as minsj,table_db as db,table_target_db as targetDb," +
            "table_exemodel as model,table_pk as pk,table_tpk as targetpk,table_pk_replace as pkReplace," +
            "table_isgxsjc as gxsjc," +
            "table_gxsjc as gxsjcValue," +
            "table_sql as tableSql, " +
            "table_owner as owner, " +
            "table_towner as targetOwner, " +
            "table_timeorder as timeOrder, " +
            "table_syncmodel as syncMode " +
            " from guiyjz_schedule_table where table_state<>0 and table_id=#{id}")
    Table tableInfo(@Param("id") String id);

    @Select("select " +
            "sql_id as id, " +
            "sql_table as table1," +
            "sql_count as totalSql," +
            "sql_page as pageListSql," +
            "sql_pagec as comparePageListSql," +
            "sql_list as listSql," +
            "sql_listc as compareListSql," +
            "sql_countc as compareTotalSql," +
            "sql_one as selectOneSql," +
            "sql_max as maxSql," +
            "sql_minsj as minSql," +
            "sql_g_has as hasOneSql," +
            "sql_g_update as updateSql," +
            "sql_g_delete as deleteSql  ," +
            "sql_g_insert as insertSql," +
            "sql_g_totalc as targetCompareTotalSql," +
            "sql_g_deletes as deleteInSql, " +
            "sql_all_list as targetCompareAllListSql " +
            " from guiyjz_schedule_table_sql where sql_table=#{id}")
    Sql sql(@Param("id") String id);

    @Select("SELECT column_id as id," +
            "column_table as table1," +
            "column_name as name1," +
            "column_data_type as dataType," +
            "column_key as key1," +
            "column_index as index1," +
            "column_pk as pk," +
            "column_default_value as defaultValue," +
            "column_update as update1," +
            "column_select as select1," +
            "column_gxsjc as gxsjc," +
            "column_compare as compare," +
            "column_convert as convertData," +
            "column_source as sourceType," +
            "column_format as format," +
            "column_state as state FROM guiyjz_schedule_table_column WHERE column_table=#{id} order by column_index")
    List<Column> column(@Param("id") String id);

    @Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state<>0 and db_id=#{id}")
    DbInfo selectDbInfo(@Param("id") String id);

    @Select("<script>"  +
            "select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state &lt;&gt; 0 and db_id in" +
            "<foreach collection=\"ids\" index=\"index\" item=\"id\" open=\"(\" separator=\",\" close=\")\">" +
            "#{id}" +
            "</foreach>" +
            "</script>")
    List<DbInfo> selectDbInfos(@Param("ids") String[] ids);

    @Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state<>0 and db_name=#{name}")
    DbInfo selectDbInfoName(@Param("name") String name);

    @Select("<script>"  +
            "select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state &lt;&gt; 0 and db_alias in" +
            "<foreach collection=\"alias\" index=\"name\" item=\"id\" open=\"(\" separator=\",\" close=\")\">" +
            "#{name}" +
            "</foreach>" +
            "</script>")
    List<DbInfo> selectDbInfosAlias(@Param("alias") String[] alias);

    /*@Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_state<>0 and db_alias=#{alias}")
    DbInfo selectDbAlias(@Param("alias") String alias);*/



    @Delete("delete from guiyjz_schedule_table_sql where sql_table=#{id}")
    void deleteSql(@Param("id") String id);

    @Delete("delete from guiyjz_schedule_table_column where column_table=#{id}")
    void deleteColumns(@Param("id") String id);

    @Delete("delete from guiyjz_schedule_table where table_id=#{id}")
    void deleteTable(@Param("id") String id);

    @Update("update guiyjz_schedule_table set " +
            "table_pk=${pk}," +
            "table_tpk=#{targetpk} where table_id=#{id}")
    void updateTable(Table table);


    @Update("update guiyjz_schedule_table_sql set where sql_table=#{sql}")
    void updateSql(@Param("sql") Sql sql);

    @Select("select * from guiyjz_schedule_mapper ")
    List<JSONObject> columnTypes();

    @Select("select * from guiyjz_schedule_table where table_name=#{name}")
    Map<String,Object> tableName(@Param("name") String name);
}
