package com.github.niupengyu.schedule.mains.dao;

import com.github.niupengyu.schedule.mains.bean.Plan;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

public interface PlanDao {

    @Insert("insert into guiyjz_schedule_plan(plan_id,plan_name,plan_task,plan_state," +
            "plan_data_start,plan_data_end,plan_cron,plan_hours,plan_count,plan_size,plan_create_date) " +
            "values(#{id},#{name},#{task},0,#{dataStart},#{dataEnd},#{cron},#{hours},#{count},#{size},#{createDate})")
    public void insert(Plan plan);

    @Update("update guiyjz_schedule_plan set plan_state=#{state} where plan_id=#{id}")
    void updateState(@Param("id") String id, @Param("state") int state);
//    DATE_FORMAT(schedule_start,'%Y-%m-%d %T')
    @Select("select " +
            "p.plan_id as id," +
            "p.plan_task as task," +
            "p.plan_name as name," +
            "p.plan_state as state," +
            "DATE_FORMAT(p.plan_data_start,'%Y-%m-%d %T') as dataStart," +
            "DATE_FORMAT(p.plan_data_end,'%Y-%m-%d %T') as dataEnd," +
            "DATE_FORMAT(p.plan_data_exe,'%Y-%m-%d %T') as exe," +
            "p.plan_cron as cron," +
            "p.plan_hours as hours," +
            "p.plan_count as count," +
            "p.plan_size as size," +
            "s.schedule_bean as bean" +
            " from guiyjz_schedule_plan p,guiyjz_schedule s " +
            "where p.plan_task=s.schedule_name and plan_id=#{id}")
    Plan selectPlan(String id);

    @Update("update guiyjz_schedule_plan set plan_data_exe=#{start},plan_count=plan_count+1 where plan_id=#{id}")
    void updateStart(@Param("id") String id, @Param("start") String start);

    @Select("select " +
            "p.plan_id as id," +
            "p.plan_task as task," +
            "p.plan_name as name," +
            "p.plan_state as state," +
            "DATE_FORMAT(p.plan_data_start,'%Y-%m-%d %T') as dataStart," +
            "DATE_FORMAT(p.plan_data_end,'%Y-%m-%d %T') as dataEnd," +
            "DATE_FORMAT(p.plan_data_exe,'%Y-%m-%d %T') as exe," +
            "p.plan_cron as cron," +
            "p.plan_hours as hours," +
            "p.plan_count as count," +
            "p.plan_size as size," +
            "s.schedule_bean as bean" +
            " from guiyjz_schedule_plan p,guiyjz_schedule s " +
            "where p.plan_task=s.schedule_name")
    List<Plan> selectPlans();

}
