package com.github.niupengyu.schedule.mains.dao;

import com.alibaba.fastjson.JSONObject;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ExceptionDao {

    @Insert("insert into guiyjz_schedule_exception(exception_id,exception_data,exception_message,exception_task,exception_time) " +
            "values(#{id},#{data},#{message},#{task},#{date})")
    public void saveException(@Param("id") String id, @Param("task") String task,
                              @Param("message") String message, @Param("data") String data, @Param("date") Date date);

    @Select("select * from guiyjz_schedule_exception where exception_type=#{type} and exception_task=#{task} " +
            "order by exception_time desc limit #{start},#{size}")
    List<Map<String,Object>> list(@Param("task") String task, @Param("type") String type,
                                  @Param("start") int start, @Param("size") int size);

    @Select("<script>" +
            "select * from guiyjz_schedule_exception where 1=1 " +
            "<if test=\"type!=null and type!=''\">" +
            "and exception_type=#{type} " +
            "</if>" +
            "<if test=\"task!=null and task!=''\">" +
            "and exception_task=#{task} " +
            "</if>" +
            "order by exception_time desc limit #{start},#{size} " +
            "</script>")
    List<Map<String,Object>> allException(@Param("task") String task, @Param("type") String type,
                                  @Param("start") int start, @Param("size") int size);


    @Update("update guiyjz_schedule_exception set exception_state=#{i} where exception_id=#{id}")
    void updateState(@Param("id") String id, @Param("i") int i);


    @Update("" +
            "<script>" +
            "update guiyjz_schedule_exception set exception_state=#{i} where exception_id in" +
            "<foreach collection=\"data\" index=\"index\" item=\"item\" open=\"(\" separator=\",\" close=\")\">" +
            "#{item.eid}" +
            "</foreach>" +
            "</script>" +
            "")
    void updateStates(@Param("data") List<JSONObject> data, @Param("i") int i);

    @Select("select s.schedule_bean as bean," +
            "s.schedule_batch as batch," +
            "s.schedule_name as name," +
            "s.schedule_type as jobType," +
            "s.schedule_table as tableId,"+
            "s.schedule_param as param,"+
            "e.exception_data as data " +
            //"e.exception_batch as batch " +
            //"e.exception_page as page " +
            //"e.exception_start as startTime " +
            //"e.exception_end as endTime " +
            "from guiyjz_schedule s " +
            "left join guiyjz_schedule_task t on t.task_schedule=s.schedule_name " +
            "left join guiyjz_schedule_exception e on e.exception_task=t.task_id where exception_id=#{id}")
    public JSONObject selectBean(@Param("id") String id);

    @Select("<script>" +
            "select s.schedule_bean as bean,s.schedule_batch as batch," +
            "s.schedule_table as tableID," +
            "s.schedule_type as jobType," +
            "s.schedule_param as param,"+
            "s.schedule_name as name," +
            "e.exception_data as data, " +
            "e.exception_id as eid " +
            "from guiyjz_schedule s " +
            "left join guiyjz_schedule_task t on t.task_schedule=s.schedule_name " +
            "left join guiyjz_schedule_exception e on e.exception_task=t.task_id " +
            "where exception_type='DATA' and exception_id in " +
            "<foreach collection=\"ids\" index=\"index\" item=\"item\" open=\"(\" separator=\",\" close=\")\">" +
            "#{item}" +
            "</foreach>" +
            "</script>")
    List<JSONObject> selectBeans(@Param("ids") String[] ids);

    @Select("select s.schedule_bean as bean,s.schedule_batch as batch,s.schedule_name as name," +
            "s.schedule_table as tableID," +
            "e.exception_data as data, " +
            "e.exception_id as eid, " +
            "s.schedule_type as jobType," +
            "s.schedule_param as param "+
            " from guiyjz_schedule_exception e,guiyjz_schedule_task t, " +
            " guiyjz_schedule s " +
            " where t.task_schedule=s.schedule_name and e.exception_task=t.task_id " +
            " and exception_task=#{task} and exception_type='DATA' order by exception_time desc")
    List<JSONObject> listJson(@Param("task") String task);

    @Select("select count(exception_id) from guiyjz_schedule_exception where exception_task=#{task} and " +
            "exception_type=#{type}")
    int total(@Param("task") String task, @Param("type") String type);

    @Select("<script>" +
            "select count(exception_id) from guiyjz_schedule_exception where 1=1 " +
            "<if test=\"type!=null and type!=''\">" +
            "and exception_type=#{type} " +
            "</if>" +
            "<if test=\"task!=null and task!=''\">" +
            "and exception_task=#{task} " +
            "</if>" +
            "</script>")
    int allTotal(@Param("task") String task, @Param("type") String type);
}
