package com.github.niupengyu.schedule.mains.dao;

import com.github.niupengyu.schedule.common2.bean.common.DbInfo;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Map;

public interface DataSourceDao {

    @Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db")
    List<DbInfo> list();

    @Update("update guiyjz_schedule_db set db_state=#{i} where db_id=#{id}")
    void updateState(@Param("id") String id, @Param("i") int i);

    @Insert("insert into guiyjz_schedule_db(db_id,db_driver,db_url,db_username,db_password," +
            "db_owner,db_state,db_alias,db_name,db_param,db_type) " +
            "values(#{id},#{driver},#{url},#{username},#{password}," +
            "#{owner},#{state},#{dbAlias},#{dbName},#{param},#{type})")
    void saveDb(DbInfo dbInfo);

    @Select("select * from guiyjz_scheudle_db_dialect")
    List<Map<String,Object>> dialects();

    @Select("select * from guiyjz_scheudle_db_support")
    List<Map<String,Object>> database();

    @Select("select " +
            "db_id as id," +
            "db_driver as driver," +
            "db_url as url," +
            "db_username as username," +
            "db_password as password," +
            "db_owner as owner," +
            "db_state as state," +
            "db_alias as dbAlias," +
            "db_name as dbName," +
            "db_param as param," +
            "db_type as type" +
            " from guiyjz_schedule_db where db_id=#{id}")
    DbInfo getById(@Param("id") String id);

    @Update("update guiyjz_schedule_db set db_driver =#{driver} ,db_url =#{url}," +
            "db_username =#{username} ,db_password =#{password}," +
            "db_owner =#{owner} ,db_alias =#{dbAlias} ,db_name =#{dbName}," +
            "db_param =#{param} ,db_type =#{type} where db_id =#{id} ")
    void updateDb(DbInfo dbInfo);
}
