package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.schedule.mains.bean.Plan;
import com.github.niupengyu.schedule.mains.service.PlanService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("plan")
public class PlanController extends ClientContent {

    @Resource(name = "planService")
    private PlanService planService;

    @RequestMapping("add")
    public ResponseData add(Plan plan){
        planService.add(plan);
        return this.rdSuccess();
    }

    @RequestMapping("active")
    public ResponseData active(String id) throws Exception {
        planService.active(id);
        return this.rdSuccess();
    }

    @RequestMapping("close")
    public ResponseData close(String id) throws Exception {
        planService.close(id);
        return this.rdSuccess();
    }



}
