package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.FileUtil;
import com.github.niupengyu.core.util.ZipTools;
import com.github.niupengyu.schedule.common2.service.ModuleService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.github.niupengyu.web.util.TransferTo;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;

@RestController
@RequestMapping("module")
public class ModuleController extends ClientContent{

    @Resource(name = "moduleService")
    private ModuleService moduleService;

    @RequestMapping("load")
    public ResponseData loadModule(String id) throws Exception {
        //String modules="hczz";
        //String version="1.2.6-RELEASE";
        //String packages="com.github.niupengyu.schedule.hczz";

        /*String baseDir="D:\\IdeaProjects\\aframe\\ahead-frame-schedule";
        String modules="test";
        String version="1.0-SNAPSHOT";
        String packages="com.ultrapower.df.sechedule.develop";*/

        moduleService.loadModule(id);
        return this.rdSuccess();
    }

    @RequestMapping("uninstallModule")
    public ResponseData uninstallModule(String id) throws Exception {

        moduleService.uninstallModule(id);
        return this.rdSuccess();
    }

    @RequestMapping("save")
    public ResponseData saveModule(String name, String module, String version,
                                   String packages,@RequestParam("file") MultipartFile file) throws Exception {
        String baseDir= FileUtil.root()+"modules/"+module;
        String fileName=module+"-"+version;
        File dir=new File(baseDir,fileName);
        if(dir.isDirectory()){
            throw new SysException("版本已存在");
        }
        FileUtil.mkdirs1(baseDir);
        File newFile=TransferTo.file(file,baseDir,fileName);
        ZipTools.unZipToFolder(newFile.getPath(),baseDir);
        new File(baseDir,FileUtil.getFileName0(file.getOriginalFilename())).renameTo(dir);
        moduleService.saveModule(name,module,version,packages,dir);
        return this.rdSuccess();
    }


    @RequestMapping("modules")
    public ResponseData modules(String module,String state,int page,int size){
        JSONObject map=this.moduleService.modules(module,state,page,size);
        return this.rdSuccess(map);
    }


    @RequestMapping("activeModules")
    public ResponseData modules(){
        List map=this.moduleService.selectLoad();
        return this.rdSuccess(map);
    }

    @RequestMapping("modulesgroup")
    public ResponseData modulesGroup(){
        List map=this.moduleService.modulesGroup();
        return this.rdSuccess(map);
    }

    @RequestMapping("beanNames")
    public ResponseData beanNames(String id){
        String[] map=this.moduleService.beans(id);
        return this.rdSuccess(map);
    }

}
