package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.IdGeneratorUtil;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.common.CodeInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.common2.bean.common.CreateInfo;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.mains.service.GenProService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpRequest;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.*;

@RestController
@RequestMapping("mapper")
public class MapperController extends ClientContent{

    @Resource(name = "mapperService")
    private MapperService mapperService;

    @Resource(name = "genProService")
    private GenProService genProService;

    @RequestMapping("tables")
    public ResponseData tables(CreateInfo createInfo) throws Exception {
        List<String> list= mapperService.tables(createInfo);
        return this.rdSuccess(list);
    }

    @RequestMapping("views")
    public ResponseData views(CreateInfo createInfo) throws Exception {
        List<String> list= mapperService.views(createInfo);
        return this.rdSuccess(list);
    }

    @RequestMapping("initdb")
    public ResponseData initdb() throws Exception {
        mapperService.initdb();
        return this.rdSuccess();
    }

    @RequestMapping("columns")
    public ResponseData columns(CreateInfo createInfo,String tableName) throws Exception {
        List<Map<String,Object>> list= mapperService.columns(createInfo,tableName);
        return this.rdSuccess(list);
    }

    @RequestMapping("exesql")
    public ResponseData exeSql(CreateInfo createInfo,String sqlselect,
                               String sqlfrom,String sqlwhere) throws Exception {
        List<Map<String,Object>> list= mapperService.exeSql(createInfo,sqlselect,sqlfrom,sqlwhere);
        return this.rdSuccess(list);
    }

    @RequestMapping("tableinfo")
    public ResponseData tableInfo(String id) throws SysException {
        Table list= mapperService.tableinfo(id);
        return this.rdSuccess(list);
    }


    @RequestMapping("gencode")
    public ResponseData genCode(CodeInfo codeInfo,
                                HttpServletRequest request) throws Exception {

        List<Column> columns=new ArrayList<>();
        if(StringUtil.arrNotNull(codeInfo.getColumnNames())){
            String pkValue="";
            String targetPkValue="";
            int i=1;
            for(String name:codeInfo.getColumnNames()){
                String key=request.getParameter(name+"columnKey");
                String defaultValue=request.getParameter(name+"columnDefault");
                String defaultType=request.getParameter(name+"dataType");
                String convert=request.getParameter(name+"convertData");
                String sourceType=request.getParameter(name+"sourcedataType");
                String format=request.getParameter(name+"format");
                if(StringUtil.isNull(key)) {
                    throw new SysException(name + " 目标库字段名称为空 " + i);
                }
                i++;
                Column column=new Column();
                column.setName1(name);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf(defaultValue));
                column.setDataType(defaultType);
                column.setSourceType(StringUtil.isNull(sourceType)?defaultType:sourceType);
                column.setFormat(format);
                column.setState(1);
                if(name.equals(codeInfo.getComparesjValue())){
                    column.setCompare(true);
                    codeInfo.setTargetComparesjValue(key);
                }

                if(name.equals(codeInfo.getGxsjcValue())){
                    column.setGxsjc(true);
                }

                boolean pk=StringUtil.booleanValueOf(request.getParameter(name+"pk"),false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                if(pk){
                    pkValue=pkValue+","+name;
                    targetPkValue=targetPkValue+","+key;
                }
                column.setConvertData(StringUtil.booleanValueOf(convert,false));
                columns.add(column);
            }
            boolean rksj=codeInfo.isRksj();
            if(rksj){

                Column insert=new Column();
                insert.setPk(false);
                insert.setDataType("Timestamp");
                insert.setKey1(codeInfo.getInsertTime());
                insert.setName1(codeInfo.getInsertTime());
                insert.setUpdate1(false);
                insert.setDefaultValue("now");
                insert.setSelect1(false);
                insert.setState(1);

                Column update=new Column();
                update.setPk(false);
                update.setDataType("Timestamp");
                update.setKey1(codeInfo.getUpdateTime());
                update.setName1(codeInfo.getUpdateTime());
                update.setUpdate1(true);
                update.setDefaultValue("now");
                update.setSelect1(false);
                update.setState(1);
                columns.add(insert);
                columns.add(update);
            }

            String[] customizeCols=codeInfo.getCustomizeCols();
            //List<Column> customizeList=new ArrayList<>();
            i=1;
            for(String name:customizeCols){

                Column column=new Column();
                String columnName=request.getParameter(name+"name");

                if(StringUtil.isNull(columnName)){
                    column.setSelect1(false);
                }

                String key=request.getParameter(name+"Key");

                if(StringUtil.isNull(key)){
                    throw new SysException(name+" 目标库字段名称为空 "+i);
                }
                i++;
                String defaultValue=request.getParameter(name+"columnDefault");
                String defaultType=request.getParameter(name+"dataType");
                String convert=request.getParameter(name+"convertData");

                String sourceType=request.getParameter(name+"sourcedataType");
                String format=request.getParameter(name+"format");
                column.setSourceType(StringUtil.isNull(sourceType)?defaultType:sourceType);
                column.setFormat(format);

                column.setName1(columnName);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf(defaultValue));
                column.setDataType(defaultType);
                column.setConvertData(StringUtil.booleanValueOf(convert,false));
                boolean pk=StringUtil.booleanValueOf(request.getParameter(name+"pk"),false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                column.setState(2);
                if(pk){
                    pkValue=pkValue+","+name;
                    targetPkValue=targetPkValue+","+key;
                }

                if(name.equals(codeInfo.getComparesjValue())){
                    column.setCompare(true);
                    codeInfo.setTargetComparesjValue(key);
                }

                if(name.equals(codeInfo.getGxsjcValue())){
                    column.setGxsjc(true);
                }
                //customizeList.add(column);
                columns.add(column);
            }
            if(StringUtil.isNull(pkValue)||StringUtil.isNull(targetPkValue)||
                    pkValue.length()==1||targetPkValue.length()==1){
                return this.rdError("没有选择主键 或主键为空");
            }
            codeInfo.setPk(pkValue.substring(1));
            codeInfo.setTargetpk(targetPkValue.substring(1));
            mapperService.genCode(codeInfo,columns);
        }else{
            return this.rdError("没有选字段呀");
        }
        return this.rdSuccess();
    }

    @RequestMapping("gencodes")
    public ResponseData genCodes(CodeInfo codeInfo,
                                HttpServletRequest request) throws Exception {

        mapperService.genCodes(codeInfo);
        return this.rdSuccess();
    }

    @RequestMapping("createTable")
    public ResponseData createTable(CreateInfo createInfo,String part, HttpSession session) throws Exception {
        StringBuilder stringBuilder=mapperService.createTable(createInfo,part);
        session.setAttribute("ddl",stringBuilder);
        return this.rdSuccess();
    }

    @RequestMapping("updateTable")
    public ResponseData updateTable(Table table) throws Exception {
        mapperService.updateTable(table);
        return this.rdSuccess();
    }

    @RequestMapping("updateColumns")
    public ResponseData updateColumns(String[] columnIds,String tableId,
                                      String columngxsjc,String columncompare,
                                      boolean comparesj,
                                      boolean pkReplace,
                                      boolean page,
                                      String[] customizeCols,
                                      String owner,HttpServletRequest request) throws Exception {
        List<Column> list=new ArrayList<>();
        String pkColumn="";
        String targetPkColumn="";
        String compareColumn="";
        String targetCompareColumn="";
        String gxsjcColumn="";
        int i=0;
        for(String id:columnIds){
            Column column=new Column();

            String name=request.getParameter(id+"name1");
            String key=request.getParameter(id+"key1");
            String dataType=request.getParameter(id+"dataType");
            String defaultValue=request.getParameter(id+"defaultValue");


            String convert=request.getParameter(id+"convertData");

            String sourceType=request.getParameter(id+"sourceType");
            String format=request.getParameter(id+"format");
            column.setSourceType(StringUtil.isNull(sourceType)?dataType:sourceType);
            column.setFormat(format);
            column.setConvertData(StringUtil.booleanValueOf(convert,false));


            boolean pk=StringUtil.booleanValueOf(request.getParameter(id+"pk"),false);
            boolean update=StringUtil.booleanValueOf(request.getParameter(id+"update1"),false);
            boolean select=StringUtil.booleanValueOf(request.getParameter(id+"select1"),false);
            //boolean compare=StringUtil.booleanValueOf(request.getParameter(id+"compare"),false);
            //boolean gxsjc=StringUtil.booleanValueOf(request.getParameter(id+"gxsjc"),false);
            column.setId(id);
            column.setName1(name);
            column.setKey1(key);
            column.setDefaultValue(StringUtil.valueOf(defaultValue));
            column.setDataType(dataType);
            column.setPk(pk);
            column.setUpdate1(update);
            column.setSelect1(select);
            boolean compare=name.equals(columncompare);
            boolean gxsjc=name.equals(columngxsjc);
            column.setCompare(compare);
            column.setGxsjc(gxsjc);
            i++;
            column.setIndex1(i);
            column.setState(1);
            if(pk){
                pkColumn=pkColumn+","+name;
                targetPkColumn=targetPkColumn+","+key;
            }
            if(compare){
                compareColumn=name;
                targetCompareColumn=key;
            }
            if(gxsjc){
                gxsjcColumn=name;
            }

            list.add(column);
        }

        i=1;
        if(customizeCols!=null&&customizeCols.length>0){
            for(String name:customizeCols){
                Column column=new Column();
                String columnName=request.getParameter(name+"name");
                if(StringUtil.isNull(columnName)){
                    column.setSelect1(false);
                }

                String key=request.getParameter(name+"Key");

                if(StringUtil.isNull(key)){
                    throw new SysException(name+" 目标库字段名称为空 "+i);
                }
                i++;
                String defaultValue=request.getParameter(name+"columnDefault");
                String defaultType=request.getParameter(name+"dataType");
                String convert=request.getParameter(name+"convertData");

                String sourceType=request.getParameter(name+"sourcedataType");
                String format=request.getParameter(name+"format");
                column.setSourceType(StringUtil.isNull(sourceType)?defaultType:sourceType);
                column.setFormat(format);

                column.setName1(columnName);
                column.setKey1(key);
                column.setDefaultValue(StringUtil.valueOf(defaultValue));
                column.setDataType(defaultType);
                column.setConvertData(StringUtil.booleanValueOf(convert,false));
                boolean pk=StringUtil.booleanValueOf(request.getParameter(name+"pk"),false);
                column.setPk(pk);
                column.setUpdate1(!pk);
                column.setState(2);
                if(pk){
                    pkColumn=pkColumn+","+name;
                    targetPkColumn=targetPkColumn+","+key;
                }

                if(name.equals(columncompare)){
                    column.setCompare(true);
                    compareColumn=name;
                    targetCompareColumn=key;
                }

                if(name.equals(columngxsjc)){
                    column.setGxsjc(true);
                    gxsjcColumn=name;
                }
                column.setId(IdGeneratorUtil.uuid32());
                //customizeList.add(column);
                list.add(column);
            }
        }


        mapperService.updateColumn(tableId,list,pkColumn,targetPkColumn,compareColumn,comparesj,
                targetCompareColumn,(StringUtil.notNull(gxsjcColumn)),gxsjcColumn,pkReplace,page);
        return this.rdSuccess();
    }

    @RequestMapping("deleteTable")
    public ResponseData deleteTable(String[] ids) throws Exception {
        mapperService.deleteTable(ids);
        return this.rdSuccess();
    }

    @RequestMapping("download")
    public void download(HttpServletResponse response, HttpSession session){
        StringBuilder stringBuilder= (StringBuilder) session.getAttribute("ddl");
        response.setCharacterEncoding("utf-8");
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/octet-stream");
        //3.设置content-disposition响应头控制浏览器以下载的形式打开文件
        try {
            response.addHeader("Content-Disposition","attachment;filename=" + new String("create.txt".getBytes(),"utf-8"));
            OutputStream out = response.getOutputStream();
            if(stringBuilder==null){
                stringBuilder=new StringBuilder();
            }
            out.write(stringBuilder.toString().getBytes());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping("genfile")
    public void genFile(String packageName,String[] ids) throws Exception {
        File file=genProService.gen(packageName,ids);
        this.download1(file,file.getName());
    }

    @RequestMapping("datatotal")
    public ResponseData datatotal(String[] ids) throws Exception {
        return this.rdSuccess(mapperService.datatotal(ids));
    }

    @RequestMapping("datattotal")
    public ResponseData datattotal(String[] ids) throws Exception {
        return this.rdSuccess(mapperService.datattotal(ids));
    }

}
