package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.init.BaseSysinitBean;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.PrimaryKey;
import com.github.niupengyu.schedule.common2.bean.TaskTimer;
import com.github.niupengyu.schedule.common2.bean.TimerParam;
import com.github.niupengyu.schedule.common2.bean.common.Table;
import com.github.niupengyu.schedule.common2.exception.StopException;
import com.github.niupengyu.schedule.common2.util.ServiceUtil;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.alibaba.fastjson.JSONObject;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequestMapping("main")
@RestController
public class MainController extends ClientContent{

    @Resource(name="mainService")
    private MainService mainService;



    @RequestMapping(value="startnow")
    public ResponseData startNow(@RequestBody TimerParam param) throws Exception {
        mainService.startNow(param);
        return this.rdSuccess();
    }

    @RequestMapping(value="stopnow")
    public ResponseData stopnow(@RequestBody TimerParam param) throws Exception {
        mainService.stopNow(param);
        return this.rdSuccess();
    }



    @RequestMapping(value="startall")
    public ResponseData startAll() throws Exception {
        mainService.startAll();
        return this.rdSuccess();
    }

    @RequestMapping(value="info")
    public ResponseData info(String key, HttpServletResponse response) throws SysException {
        if(StringUtil.isNull(key)){
            throw new SysException("哈哈哈");
        }
        TaskTimer taskTimer=mainService.getTimerInfo(key);
        return this.rdSuccess(taskTimer);
    }

    @RequestMapping(value="infos")
    public ResponseData infos(String type, String app, String bindTask,String jobName,
                              @RequestParam(defaultValue = "1") int page,
                              @RequestParam(defaultValue = "10") int size)  {
        JSONObject map=mainService.getTimerInfos(type,jobName,app,bindTask,page,size);
        map.put("id", ServiceUtil.serialNumber());
        return this.rdSuccess(map);
    }

    @RequestMapping(value="timerinfos")
    public ResponseData timerinfos(String app)  {
        List<TaskTimer> map=mainService.getAllTimerInfos("",app,"");
        return this.rdSuccess(map);
    }

    @RequestMapping(value="stop")
    public ResponseData stop(String key) throws Exception {
        mainService.stop(key);
        return this.rdSuccess();
    }

    @RequestMapping(value="restart")
    public ResponseData restart(String id){
        mainService.restart(id);
        return this.rdSuccess();
    }


    @RequestMapping(value="remove")
    public ResponseData remove(String key) throws SchedulerException {
        String msg="";
        mainService.remove(key);
        return this.rdSuccess();
    }

    @RequestMapping(value="removeall")
    public ResponseData removeall() throws SchedulerException {
        String msg="";
        mainService.removeall();
        return this.rdSuccess();
    }

    @RequestMapping(value="add")
    public ResponseData add(String key,String cron) throws Exception{
        mainService.add(key,cron);
        return this.rdSuccess();
    }

    @RequestMapping(value="one")
    public ResponseData one(HttpServletRequest request) throws Exception{
        Map<String,String> param=new HashMap<>();
        for(Map.Entry<String,String[]> map:
                request.getParameterMap().entrySet()){
            param.put(map.getKey(),map.getValue()[0]);
        }
        String task=param.get("task");
        param.remove("task");
        PrimaryKey pk=PrimaryKey.createPrimaryKey(param);
        mainService.one(task,pk);
        return this.rdSuccess();
    }

    @RequestMapping(value="onecolumn")
    public ResponseData oneColumn(String task) throws Exception{
        Map<String,String> map=this.mainService.one(task);
        //SaveFace saveFace= BaseSysinitBean.getBean(this.mainService.getTimerById(task).getBean());
        //PrimaryKey pk=saveFace.goalId().primaryMap();
        //mainService.one(task,pk);
        return this.rdSuccess(map);
    }

    @RequestMapping("resynchronization")
    public ResponseData resynchronization(String id) throws Exception {
        mainService.resynchronization(id);
        return this.rdSuccess();
    }

    @RequestMapping("resynchronizationpage")
    public ResponseData resynchronizationPage(String id) throws Exception {
        mainService.resynchronizationPage(id);
        return this.rdSuccess();
    }


    @RequestMapping("resynchronizationall")
    public ResponseData resynchronizationall(String id) throws Exception, StopException {
        mainService.resynchronizationall(id);
        return this.rdSuccess();
    }

    @RequestMapping("resynchronizations")
    public ResponseData resynchronizations(String[] ids) throws Exception, StopException {
        mainService.resynchronizations(ids);
        return this.rdSuccess();
    }

    @RequestMapping("delete")
    public ResponseData deleteInfo(String id){
        mainService.deleteInfo(id);
        return this.rdSuccess();
    }

    @RequestMapping("interrupt")
    public ResponseData interrupt(String name) throws UnableToInterruptJobException {
        mainService.interrupt(name);
        return this.rdSuccess();
    }


    @RequestMapping("currentjob")
    public ResponseData currentJob() throws Exception {
        return this.rdSuccess(mainService.local());
    }

    @RequestMapping("bindTask")
    public ResponseData bindTask(String name) throws Exception {
        this.mainService.bindTask(name);
        return this.rdSuccess();
    }

    @RequestMapping("disbindTask")
    public ResponseData disbindTask(String name) throws Exception {
        this.mainService.disbindTask(name);
        return this.rdSuccess();
    }

    @RequestMapping("setOpen")
    public ResponseData setOpen(boolean open,String name) throws Exception {
        this.mainService.setOpen(open,name);
        return this.rdSuccess();
    }

    @RequestMapping("savesch")
    public ResponseData saveSch(TaskTimer taskTimer,String tableInfo) throws Exception {
        this.mainService.savesch(taskTimer,tableInfo);
        return this.rdSuccess();
    }

    @RequestMapping("saveschedule")
    public ResponseData saveschedule(TaskTimer taskTimer,String moduleid,String compare) throws Exception {
        this.mainService.saveschedule(taskTimer,moduleid,compare);
        return this.rdSuccess();
    }

    @RequestMapping("gencode")
    public ResponseData genCode(String id,String type) throws Exception {
        this.mainService.genCode(id,type);
        return this.rdSuccess();
    }


    @RequestMapping("getById")
    public ResponseData getById(String id) throws Exception {
        TaskTimer taskTimer=this.mainService.getTimerById(id);
        return this.rdSuccess(taskTimer);
    }


    @RequestMapping("tables")
    public ResponseData tables(){
        List<Table> list=this.mainService.tableInfo("not");
        return this.rdSuccess(list);
    }

    @RequestMapping("updatesch")
    public ResponseData updateSch(TaskTimer taskTimer,String tableInfo){
        this.mainService.updateSch(taskTimer);
        return this.rdSuccess();
    }

}
