package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.schedule.common2.bean.TaskInfo;
import com.github.niupengyu.schedule.common2.service.TaskInfoService;
import com.github.niupengyu.schedule.mains.service.MainService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("restlistener")
public class ListenerRestController  extends ClientContent {

    @Resource(name="mainService")
    private MainService mainService;

    @Resource(name = "taskInfoService")
    private TaskInfoService taskInfoService;

    @RequestMapping("jobgroup")
    public ResponseData jobGroup(){
        return this.rdSuccess(mainService.getApps());
    }

    @RequestMapping("timers")
    public ResponseData timers(String bingTask,String app){
        return this.rdSuccess(this.mainService.getAllTimerInfos("",app,bingTask));
    }

    @RequestMapping("taskInfos")
    public ResponseData taskInfos( String app, String name, String timeFrame,
                               String taskstate, String tasktype, String time,int page,int size){
        JSONObject taskInfos=  taskInfoService.allNowList(app,name,timeFrame,taskstate,tasktype,time,page,size);
        return this.rdSuccess(taskInfos);
    }

}
