package com.github.niupengyu.schedule.mains.controller;

import com.github.niupengyu.core.exception.SysException;
import com.github.niupengyu.core.util.StringUtil;
import com.github.niupengyu.schedule.common2.bean.common.CodeInfo;
import com.github.niupengyu.schedule.common2.bean.common.Column;
import com.github.niupengyu.schedule.mains.service.ExcelService;
import com.github.niupengyu.schedule.mains.service.MapperService;
import com.github.niupengyu.web.beans.ResponseData;
import com.github.niupengyu.web.content.ClientContent;
import com.github.niupengyu.web.util.TransferTo;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("excel")
public class ExcelController extends ClientContent {

    @Resource(name = "excelService")
    private ExcelService excelService;

    @Resource(name = "mapperService")
    private MapperService mapperService;

    public ResponseData readColumn(){
        return null;
    }

    @RequestMapping("upload")
    public ResponseData upload(@RequestParam("file") MultipartFile multipartFile,
                               @RequestParam(defaultValue = "0") int rowNum,
                               @RequestParam(defaultValue = "1") int sheetNum) throws Exception {
        File file= TransferTo.file(multipartFile,this.filePath("excel/"));
        //JSONArray data=excelService.upload(multipartFile,sheetNum,rowNum);
        JSONObject data=excelService.upload(file,multipartFile.getOriginalFilename(),sheetNum,rowNum);
        return this.rdSuccess(data);
    }

    @RequestMapping("save")
    public ResponseData upload(HttpServletRequest request,
                               CodeInfo codeInfo,
                               @RequestParam(defaultValue = "true") String exenow,
                               @RequestParam(defaultValue = "false") String savenow,
                               String filePath,String fileName,
                               @RequestParam(defaultValue = "0") int rowNum,
                               @RequestParam(defaultValue = "10000") int executeBatch,
                               @RequestParam(defaultValue = "1") int sheetNum) throws Exception {
        String[] columnName=request.getParameterValues("columnNames");
        if(StringUtil.arrNotNull(columnName)){
            List<Column> columns=new ArrayList<>();
            String pkValue="";
            String targetPkValue="";
            for(int i=0;i<columnName.length;i++){
                String name=columnName[i];
                //int index=name.lastIndexOf("-");
                //String[] arr=columnName[i].split("-");
                //String str=name.substring(0,index);
                String str=name;
                //String index=name.;
                String key=request.getParameter(str+"Key");
                if(StringUtil.isNull(key)) {
                    throw new SysException(str + " 目标库字段名称为空 " + i);
                }
                boolean convertData=StringUtil.booleanValueOf(request.getParameter(str+"convertData"),false);
                boolean pk=StringUtil.booleanValueOf(request.getParameter(str+"pk"),false);
                String source=request.getParameter(str+"sourcedataType");
                String dataType=request.getParameter(str+"dataType");
                String format=request.getParameter(str+"format");

                Column column=new Column();
                column.setName1(name);
                column.setKey1(key);
                column.setSourceType(StringUtil.isNull(source)?dataType:source);
                column.setConvertData(convertData);
                column.setPk(pk);
                column.setUpdate1(!pk);
                if(pk){
                    pkValue=pkValue+","+name;
                    targetPkValue=targetPkValue+","+key;
                }
                column.setDataType(dataType);
                column.setFormat(format);
                column.setIndex1(i+1);
                columns.add(column);
            }
            if(StringUtil.isNull(targetPkValue)||
                    targetPkValue.length()==1||StringUtil.isNull(pkValue)||
                    pkValue.length()==1){
                return this.rdError("没有选择主键 或主键为空");
            }
            codeInfo.setPk(pkValue.substring(1));
            codeInfo.setTargetpk(targetPkValue.substring(1));
            //codeInfo.setDb(codeInfo.getTarget().getDb());
            //codeInfo.setdb
            excelService.genCode(codeInfo,columns,exenow,savenow,
                    this.filePath("excel/"),filePath,rowNum,sheetNum,executeBatch, fileName);
        }else{
            throw new SysException("没有选择任何字段");
        }

        return this.rdSuccess();
    }

    @RequestMapping("list")
    public ResponseData upload(int page,int size) throws Exception {
        JSONObject data=excelService.excelInfo(page,size);
        return this.rdSuccess(data);
    }


}
