package com.github.niupengyu.schedule.mains.config;

import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/** 
*Description: <应用配置类>. <br>
*<p>
	<负责注册除Controller等web层以外的所有bean，包括aop代理，service层，dao层，缓存，等等>
 </p>
*Makedate:2014年9月3日 上午9:58:15 
* @author Administrator  
* @version V1.0                             
*/  
@Configuration
public class AppConfig {

	private static final Logger logger = LoggerFactory.getLogger(AppConfig.class);

	@Bean(name = "schedulerFactory")
	public SchedulerFactory schedulerFactory() {
		return new StdSchedulerFactory();
	}

	@Bean(name = "scheduler")
	public Scheduler scheduler() throws SchedulerException {
		return schedulerFactory().getScheduler();
	}

}