/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.versioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.CharsKt;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.enumeration.Enums;
import org.kingdoms.versioning.VersionBase;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0004\u000b\f\r\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0000H&J\b\u0010\u0007\u001a\u00020\bH&J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\nH\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/versioning/VersionPart;", "Lorg/kingdoms/versioning/VersionBase;", "supersedes", "", "other", "precedes", "canBeComparedTo", "hashCode", "", "equals", "", "Numeric", "Unknown", "PreReleaseType", "Stage", "shared"})
public interface VersionPart
extends VersionBase<VersionPart> {
    @Override
    default public boolean supersedes(@NotNull VersionPart other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0;
    }

    @Override
    default public boolean precedes(@NotNull VersionPart other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    @Override
    public boolean canBeComparedTo(@NotNull VersionPart var1);

    @Override
    public int hashCode();

    @Override
    public boolean equals(@Nullable Object var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0013\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/versioning/VersionPart$Numeric;", "Lorg/kingdoms/versioning/VersionPart;", "number", "", "<init>", "(I)V", "getNumber", "()I", "canBeComparedTo", "", "other", "getFriendlyString", "", "short", "hashCode", "equals", "", "compareTo", "toString", "shared"})
    public static final class Numeric
    implements VersionPart {
        private final int number;

        public Numeric(int number) {
            this.number = number;
        }

        public final int getNumber() {
            return this.number;
        }

        @Override
        public boolean canBeComparedTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof Numeric;
        }

        @Override
        @NotNull
        public String getFriendlyString(boolean bl) {
            return String.valueOf(this.number);
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.number);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof Numeric && this.number == ((Numeric)other).number;
        }

        @Override
        public int compareTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            VersionPart versionPart = other;
            return versionPart instanceof Numeric ? Intrinsics.compare((int)this.number, (int)((Numeric)other).number) : (versionPart instanceof Stage ? (((Stage)other).getType().getUnstable() ? 1 : 0) : 0);
        }

        @NotNull
        public String toString() {
            return "VerPart.Numeric(" + this.number + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0013B%\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012j\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/versioning/VersionPart$PreReleaseType;", "", "", "unstable", "", "aliases", "", "", "<init>", "(Ljava/lang/String;IZ[Ljava/lang/String;)V", "getUnstable", "()Z", "ALPHA", "BETA", "RELEASE_CANDIDATE", "RELEASE", "", "getAliases", "()Ljava/util/Set;", "Companion", "shared"})
    @SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\norg/kingdoms/versioning/VersionPart$PreReleaseType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1557#2:200\n1628#2,3:201\n*S KotlinDebug\n*F\n+ 1 Version.kt\norg/kingdoms/versioning/VersionPart$PreReleaseType\n*L\n58#1:200\n58#1:201,3\n*E\n"})
    public static final class PreReleaseType
    extends Enum<PreReleaseType>
    implements Comparable<PreReleaseType> {
        @NotNull
        public static final Companion Companion;
        private final boolean unstable;
        @NotNull
        private final Set<String> aliases;
        @JvmField
        @NotNull
        public static final Map<String, PreReleaseType> MAPPING;
        public static final /* enum */ PreReleaseType ALPHA;
        public static final /* enum */ PreReleaseType BETA;
        public static final /* enum */ PreReleaseType RELEASE_CANDIDATE;
        public static final /* enum */ PreReleaseType RELEASE;
        private static final /* synthetic */ PreReleaseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        /*
         * WARNING - void declaration
         */
        private PreReleaseType(boolean unstable, String ... aliases) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.unstable = unstable;
            Iterable iterable = SetsKt.plus((Set)SetsKt.setOf((Object)this.name()), (Object[])aliases);
            PreReleaseType preReleaseType = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var14_15 = it;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string2 = var14_15.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            preReleaseType.aliases = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        public final boolean getUnstable() {
            return this.unstable;
        }

        @NotNull
        public final Set<String> getAliases() {
            return this.aliases;
        }

        public static PreReleaseType[] values() {
            return (PreReleaseType[])$VALUES.clone();
        }

        public static PreReleaseType valueOf(String value) {
            return Enum.valueOf(PreReleaseType.class, value);
        }

        @NotNull
        public static EnumEntries<PreReleaseType> getEntries() {
            return $ENTRIES;
        }

        private static final Iterable MAPPING$lambda$1(PreReleaseType it) {
            return it.aliases;
        }

        static {
            String[] stringArray = new String[]{"a", "unstable"};
            ALPHA = new PreReleaseType(true, stringArray);
            stringArray = new String[]{"b", "dev", "prerelease", "snapshot"};
            BETA = new PreReleaseType(true, stringArray);
            stringArray = new String[]{"rc"};
            RELEASE_CANDIDATE = new PreReleaseType(true, stringArray);
            stringArray = new String[]{"distribution", "dist", "stable"};
            RELEASE = new PreReleaseType(false, stringArray);
            $VALUES = preReleaseTypeArray = new PreReleaseType[]{PreReleaseType.ALPHA, PreReleaseType.BETA, PreReleaseType.RELEASE_CANDIDATE, PreReleaseType.RELEASE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Map map = Enums.createMultiMapping((Enum[])PreReleaseType.values(), PreReleaseType::MAPPING$lambda$1, (Map)new HashMap());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createMultiMapping(...)");
            MAPPING = map;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/versioning/VersionPart$PreReleaseType$Companion;", "", "<init>", "()V", "MAPPING", "", "", "Lorg/kingdoms/versioning/VersionPart$PreReleaseType;", "shared"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0011\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/versioning/VersionPart$Stage;", "Lorg/kingdoms/versioning/VersionPart;", "type", "Lorg/kingdoms/versioning/VersionPart$PreReleaseType;", "<init>", "(Lorg/kingdoms/versioning/VersionPart$PreReleaseType;)V", "getType", "()Lorg/kingdoms/versioning/VersionPart$PreReleaseType;", "canBeComparedTo", "", "other", "getFriendlyString", "", "short", "hashCode", "", "equals", "", "compareTo", "toString", "shared"})
    @SourceDebugExtension(value={"SMAP\nVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Version.kt\norg/kingdoms/versioning/VersionPart$Stage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1#2:200\n*E\n"})
    public static final class Stage
    implements VersionPart {
        @NotNull
        private final PreReleaseType type;

        public Stage(@NotNull PreReleaseType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final PreReleaseType getType() {
            return this.type;
        }

        @Override
        public boolean canBeComparedTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof Stage;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getFriendlyString(boolean bl) {
            String string;
            String string2 = this.type.name();
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string2 = StringsKt.replace$default((String)string3, (String)"_", (String)"-", (boolean)false, (int)4, null);
            if (((CharSequence)string2).length() > 0) {
                String string4;
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale2 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                    string4 = CharsKt.titlecase((char)it, (Locale)locale2);
                } else {
                    string4 = String.valueOf((char)it);
                }
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
                String string5 = string2;
                int n = 1;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string = stringBuilder2.append(string6).toString();
            } else {
                string = string2;
            }
            return string;
        }

        @Override
        public int hashCode() {
            return this.type.ordinal();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof Stage && this.type == ((Stage)other).type;
        }

        @Override
        public int compareTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            VersionPart versionPart = other;
            return versionPart instanceof Stage ? this.type.compareTo((Enum)((Stage)other).type) : (versionPart instanceof Numeric ? (this.type.getUnstable() ? -1 : 0) : 0);
        }

        @NotNull
        public String toString() {
            return "VerPart.Stage(" + this.type.name() + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\u0011\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/versioning/VersionPart$Unknown;", "Lorg/kingdoms/versioning/VersionPart;", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "canBeComparedTo", "", "other", "getFriendlyString", "short", "hashCode", "", "equals", "", "compareTo", "toString", "shared"})
    public static final class Unknown
    implements VersionPart {
        @NotNull
        private final String id;

        public Unknown(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Override
        public boolean canBeComparedTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof Unknown;
        }

        @Override
        @NotNull
        public String getFriendlyString(boolean bl) {
            return this.id;
        }

        @Override
        public int hashCode() {
            return this.id.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof Unknown && Intrinsics.areEqual((Object)this.id, (Object)((Unknown)other).id);
        }

        @Override
        public int compareTo(@NotNull VersionPart other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return other instanceof Unknown ? this.id.compareTo(((Unknown)other).id) : 0;
        }

        @NotNull
        public String toString() {
            return "VerPart.Unknown(" + this.id + ')';
        }
    }
}

