/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.versioning;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.MatchGroup;
import org.kingdoms.libs.kotlin.text.MatchGroupCollection;
import org.kingdoms.libs.kotlin.text.MatchResult;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.kingdoms.versioning.AbstractVersion;
import org.kingdoms.versioning.Version;
import org.kingdoms.versioning.VersionPart;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/versioning/SemVer;", "Lorg/kingdoms/versioning/AbstractVersion;", "originalString", "", "parts", "", "Lorg/kingdoms/versioning/VersionPart;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "majorVersion", "", "getMajorVersion", "()I", "minorVersion", "getMinorVersion", "patchVersion", "getPatchVersion", "toString", "Companion", "shared"})
public class SemVer
extends AbstractVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    @NotNull
    private static final Regex REGEX = new Regex("^(?<version>(?:(?:\\d+\\.)+)?\\d+)(?:-(?<prerelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<buildmetadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemVer(@NotNull String originalString, @NotNull List<? extends VersionPart> parts) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        super(originalString, parts);
        VersionPart versionPart = parts.get(0);
        Intrinsics.checkNotNull((Object)versionPart, (String)"null cannot be cast to non-null type org.kingdoms.versioning.VersionPart.Numeric");
        this.majorVersion = ((VersionPart.Numeric)versionPart).getNumber();
        if (parts.size() > 1) {
            VersionPart versionPart2 = parts.get(1);
            Intrinsics.checkNotNull((Object)versionPart2, (String)"null cannot be cast to non-null type org.kingdoms.versioning.VersionPart.Numeric");
            n2 = ((VersionPart.Numeric)versionPart2).getNumber();
        } else {
            n2 = this.minorVersion = 0;
        }
        if (parts.size() > 2) {
            VersionPart versionPart3 = parts.get(2);
            Intrinsics.checkNotNull((Object)versionPart3, (String)"null cannot be cast to non-null type org.kingdoms.versioning.VersionPart.Numeric");
            n = ((VersionPart.Numeric)versionPart3).getNumber();
        } else {
            n = 0;
        }
        this.patchVersion = n;
    }

    public final int getMajorVersion() {
        return this.majorVersion;
    }

    public final int getMinorVersion() {
        return this.minorVersion;
    }

    public final int getPatchVersion() {
        return this.patchVersion;
    }

    @Override
    @NotNull
    public String toString() {
        return "Version(majorVersion=" + this.majorVersion + ", minorVersion=" + this.minorVersion + ", patchVersion=" + this.patchVersion + ", " + this.getOriginalString() + ')';
    }

    @JvmStatic
    @NotNull
    public static final SemVer of(@NotNull String string) {
        return Companion.of(string);
    }

    @JvmStatic
    @NotNull
    public static final SemVer of(int majorVersion, int minorVersion, int patchVersion) {
        return Companion.of(majorVersion, minorVersion, patchVersion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/versioning/SemVer$Companion;", "", "<init>", "()V", "REGEX", "Lorg/kingdoms/libs/kotlin/text/Regex;", "of", "Lorg/kingdoms/versioning/SemVer;", "string", "", "majorVersion", "", "minorVersion", "patchVersion", "shared"})
    @SourceDebugExtension(value={"SMAP\nSemVer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemVer.kt\norg/kingdoms/versioning/SemVer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n1557#2:56\n1628#2,3:57\n1557#2:60\n1628#2,3:61\n1557#2:64\n1628#2,3:65\n*S KotlinDebug\n*F\n+ 1 SemVer.kt\norg/kingdoms/versioning/SemVer$Companion\n*L\n32#1:56\n32#1:57,3\n35#1:60\n35#1:61,3\n39#1:64\n39#1:65,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SemVer of(@NotNull String string) {
            List parts;
            block6: {
                String it;
                Collection collection;
                Object item$iv$iv;
                Iterator iterator;
                char[] $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Object $this$map$iv;
                Collection collection2;
                Iterable $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                MatchResult matchResult = REGEX.matchEntire((CharSequence)string);
                if (matchResult == null) {
                    throw new IllegalArgumentException("Unknown version string: " + string);
                }
                MatchResult matcher = matchResult;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matcher.getGroups(), (String)"version");
                Intrinsics.checkNotNull((Object)matchGroup);
                MatchGroup version = matchGroup;
                MatchGroup prerelease = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matcher.getGroups(), (String)"prerelease");
                MatchGroup buildmetadata = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matcher.getGroups(), (String)"buildmetadata");
                parts = new ArrayList();
                Object object = new char[]{'.'};
                object = StringsKt.split$default((CharSequence)version.getValue(), (char[])object, (boolean)false, (int)0, (int)6, null);
                List list = parts;
                boolean $i$f$map = false;
                void var9_12 = $this$map$iv2;
                Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    String string2 = (String)item$iv$iv2;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(Integer.parseInt((String)it2));
                }
                $this$map$iv2 = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv2 = $this$map$iv2;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    int it2 = ((Number)item$iv$iv2).intValue();
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new VersionPart.Numeric(it2));
                }
                list.addAll((List)destination$iv$iv);
                MatchGroup matchGroup2 = prerelease;
                if (matchGroup2 != null) {
                    Object item$iv$iv2;
                    MatchGroup pr = matchGroup2;
                    boolean bl = false;
                    destination$iv$iv = new char[1];
                    destination$iv$iv[0] = 46;
                    destination$iv$iv = StringsKt.split$default((CharSequence)pr.getValue(), (char[])destination$iv$iv, (boolean)false, (int)0, (int)6, null);
                    List list2 = parts;
                    boolean $i$f$map2 = false;
                    item$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        item$iv$iv = iterator.next();
                        String string3 = (String)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(Version.Companion.parsePart(it));
                    }
                    list2.addAll((List)destination$iv$iv2);
                }
                MatchGroup matchGroup3 = buildmetadata;
                if (matchGroup3 == null) break block6;
                MatchGroup build = matchGroup3;
                boolean bl = false;
                $this$map$iv = new char[]{'.'};
                $this$map$iv = StringsKt.split$default((CharSequence)build.getValue(), (char[])$this$map$iv, (boolean)false, (int)0, (int)6, null);
                List list3 = parts;
                boolean $i$f$map3 = false;
                $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    it = (String)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl3 = false;
                    collection.add(Version.Companion.parsePart(it));
                }
                list3.addAll((List)destination$iv$iv3);
            }
            return new SemVer(string, parts);
        }

        @JvmStatic
        @NotNull
        public final SemVer of(int majorVersion, int minorVersion, int patchVersion) {
            Object[] objectArray = new VersionPart.Numeric[]{new VersionPart.Numeric(majorVersion), new VersionPart.Numeric(minorVersion), new VersionPart.Numeric(patchVersion)};
            return new SemVer("" + 'v' + majorVersion + '.' + minorVersion + '.' + patchVersion, CollectionsKt.listOf((Object[])objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

