/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.versionsupport;

import javax.annotation.Nonnull;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Openable;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.versionsupport.VersionSupport;

final class OldVersionSupport {
    OldVersionSupport() {
    }

    protected static void rotate(Block block, Material material, Player player) {
        if (material.name().contains("SKULL")) {
            block.setType(Material.getMaterial((String)"SKULL"));
            BlockState state = block.getState();
            Skull skull = (Skull)state;
            skull.setSkullType(SkullType.PLAYER);
            skull.setRawData((byte)1);
            state.update(true);
        }
    }

    protected static Block getOtherHalfIfDoor(BlockState state) {
        MaterialData data = state.getData();
        if (!(data instanceof Door)) {
            return null;
        }
        Door door = (Door)data;
        return state.getBlock().getRelative(door.isTopHalf() ? BlockFace.DOWN : BlockFace.UP);
    }

    protected static void putSign(Block block, BlockFace facing) {
        byte data;
        switch (facing) {
            case NORTH: {
                data = 2;
                break;
            }
            case EAST: {
                data = 5;
                break;
            }
            case WEST: {
                data = 4;
                break;
            }
            case SOUTH: {
                data = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Sign facing cannot be: " + facing);
            }
        }
        Sign sign = (Sign)block.getState();
        sign.setRawData(data);
        sign.update(true);
    }

    protected static @Nullable Block getAttachedBlock(@Nonnull Block sign) {
        MaterialData data = sign.getState().getData();
        if (!(data instanceof org.bukkit.material.Sign)) {
            return null;
        }
        org.bukkit.material.Sign signData = (org.bukkit.material.Sign)data;
        BlockFace facing = signData.getAttachedFace();
        return sign.getRelative(facing);
    }

    protected static void addDurability(@NonNull ItemStack item, int durability) {
        item.setDurability((short)Math.max(0, item.getDurability() + durability));
    }

    protected static VersionSupport.Openable openable(Block block) {
        BlockState state = block.getState();
        MaterialData data = state.getData();
        if (!(data instanceof Openable)) {
            return null;
        }
        return new OldOpenable(block, state, (Openable)data);
    }

    private static final class OldOpenable
    implements VersionSupport.Openable {
        private final Block block;
        private final BlockState state;
        private final Openable openable;

        private OldOpenable(Block block, BlockState state, Openable openable) {
            this.block = block;
            this.state = state;
            this.openable = openable;
        }

        @Override
        public boolean isOpen() {
            return this.openable.isOpen();
        }

        @Override
        public void setOpen(boolean open) {
            this.openable.setOpen(open);
            this.state.update(true);
        }
    }
}

