/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.string.tree.ContainerPrinter;
import org.kingdoms.utils.string.tree.StringPrinter;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeStyle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012$\u0010\u0002\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00060\u00040\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\t\u0010\u000bJ.\u0010\u000f\u001a\u00020\u00102\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rj\u0002`\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0004J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rj\u0002`\u000eH\u0002J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rj\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/utils/string/tree/StringPathBuilder;", "", "strings", "", "Lorg/kingdoms/data/Pair;", "", "Ljava/util/function/Function;", "sig", "Ljava/lang/Void;", "<init>", "(Ljava/util/List;Ljava/lang/Void;)V", "(Ljava/util/List;)V", "tree", "Ljava/util/LinkedHashMap;", "Lorg/kingdoms/utils/string/tree/Folder;", "put", "", "list", "Ljava/util/LinkedList;", "getEntryOf", "Lorg/kingdoms/utils/string/tree/ContainerPrinter;", "name", "folder", "build", "toStringTree", "Lorg/kingdoms/utils/string/tree/StringTree;", "style", "Lorg/kingdoms/utils/string/tree/TreeStyle;", "core"})
@SourceDebugExtension(value={"SMAP\nStringTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringTree.kt\norg/kingdoms/utils/string/tree/StringPathBuilder\n+ 2 KoltinInternalExtensions.kt\norg/kingdoms/utils/internal/KoltinInternalExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,395:1\n8#2,3:396\n1557#3:399\n1628#3,3:400\n*S KotlinDebug\n*F\n+ 1 StringTree.kt\norg/kingdoms/utils/string/tree/StringPathBuilder\n*L\n125#1:396,3\n87#1:399\n87#1:400,3\n*E\n"})
public class StringPathBuilder {
    @NotNull
    private final LinkedHashMap<String, Object> tree;

    /*
     * WARNING - void declaration
     */
    public StringPathBuilder(@NotNull List<Pair<String, Function<String, String>>> strings, @Nullable Void sig) {
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        this.tree = new LinkedHashMap(5);
        if (strings.isEmpty()) {
            throw new IllegalArgumentException("Path string list is empty");
        }
        for (Pair<String, Function<String, String>> str : strings) {
            String string;
            void it;
            List split;
            String string2 = str.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-key>(...)");
            char[] cArray = new char[]{'/'};
            List $this$replaceLast$iv = split = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            boolean $i$f$replaceLast = false;
            if ($this$replaceLast$iv.isEmpty()) {
                throw new IllegalStateException("Cannot replace last element in an empty list: " + $this$replaceLast$iv);
            }
            String string3 = (String)$this$replaceLast$iv.get($this$replaceLast$iv.size() - 1);
            int n = $this$replaceLast$iv.size() - 1;
            List list = $this$replaceLast$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)str.getValue().apply((String)it), (String)"apply(...)");
            list.set(n, string);
            LinkedList<String> sections = new LinkedList<String>(split);
            this.put(this.tree, sections);
        }
    }

    /*
     * WARNING - void declaration
     */
    public StringPathBuilder(@NotNull List<String> strings) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(strings, (String)"strings");
        Iterable iterable = strings;
        StringPathBuilder stringPathBuilder = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair<void, Function<String, String>>(it, StringPathBuilder::_init_$lambda$1$lambda$0));
        }
        stringPathBuilder((List)destination$iv$iv, null);
    }

    protected final void put(@NotNull LinkedHashMap<String, Object> tree, @NotNull LinkedList<String> list) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        String string = list.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeFirst(...)");
        String first = string;
        boolean isFile = list.isEmpty();
        Object previous = tree.get(first);
        LinkedHashMap<String, Object> nextTree = null;
        if (previous == null) {
            if (isFile) {
                ((Map)tree).put(first, true);
                nextTree = null;
            } else {
                nextTree = new LinkedHashMap<String, Object>();
                ((Map)tree).put(first, nextTree);
            }
        } else {
            if (isFile) {
                throw new IllegalStateException("Folder and file name are the same: " + first);
            }
            if (previous instanceof Boolean) {
                nextTree = new LinkedHashMap<String, Object>();
                ((Map)tree).put(first, nextTree);
            } else {
                nextTree = (LinkedHashMap<String, Object>)previous;
            }
        }
        if (nextTree != null) {
            this.put(nextTree, list);
        }
    }

    private final ContainerPrinter getEntryOf(String name, LinkedHashMap<String, Object> folder) {
        ContainerPrinter entry = new ContainerPrinter(name);
        Iterator<Map.Entry<String, Object>> iterator = folder.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            String k;
            Object v;
            Map.Entry<String, Object> entry2;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry2.getKey(), (String)"component1(...)");
            Intrinsics.checkNotNullExpressionValue((Object)entry2.getValue(), (String)"component2(...)");
            if (v instanceof Boolean) {
                bl = entry.getChildren$core().add(new StringPrinter(k));
                continue;
            }
            LinkedHashMap nest = (LinkedHashMap)v;
            bl = entry.getChildren$core().add(this.getEntryOf(k, nest));
        }
        return entry;
    }

    @NotNull
    public final ContainerPrinter build() {
        return this.getEntryOf("", this.tree);
    }

    @NotNull
    public final StringTree toStringTree(@NotNull TreeStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return new StringTree(this.build(), style);
    }

    private static final String _init_$lambda$1$lambda$0(String x) {
        return x;
    }
}

