/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.snakeyaml.comments.CommentLine;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.common.reference.AnciasNodeReference;
import org.kingdoms.libs.snakeyaml.common.reference.CrossNodeReference;
import org.kingdoms.libs.snakeyaml.common.reference.NodeReference;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.stacktrace.StackTraces;
import org.kingdoms.utils.string.Strings;

public final class ConfigPrinter {
    private ConfigPrinter() {
    }

    public static void printConfig(ConfigurationSection section) {
        if (section == null) {
            MessageHandler.sendConsolePluginMessage("&4Attempt to print null config section");
            StackTraces.printStackTrace();
            return;
        }
        MessageHandler.sendConsolePluginMessage("&4" + section.getName() + " &7->");
        ConfigPrinter.printConfig(section, "");
    }

    public static void printConfig(ConfigurationSection section, String nestLevel) {
        for (Map.Entry entry : section.getValues(false).entrySet()) {
            Object value = entry.getValue();
            if (value instanceof ConfigurationSection) {
                MessageHandler.sendConsolePluginMessage(nestLevel + "&6" + (String)entry.getKey() + "&8:");
                ConfigPrinter.printConfig((ConfigurationSection)value, nestLevel + ' ');
                continue;
            }
            String printer = Objects.toString(value);
            if (value == null) {
                printer = "&4null";
            } else if (value instanceof String) {
                printer = printer.contains(" ") || !Strings.isEnglish(printer) ? "&f\"" + printer + "&f\"" : "&f" + printer;
            } else if (value instanceof Integer) {
                printer = "&9" + printer;
            } else if (value instanceof Number) {
                printer = "&5" + printer;
            } else if (value instanceof Boolean) {
                printer = ((Boolean)value != false ? "&a" : "&c") + printer;
            } else if (value instanceof List) {
                CharSequence[] elements = (String[])((List)value).stream().map(Object::toString).toArray(String[]::new);
                printer = "&3[&b" + String.join((CharSequence)"&7, &b", elements) + "&3]";
            } else {
                printer = "&e" + printer;
            }
            MessageHandler.sendConsolePluginMessage(nestLevel + "&6" + (String)entry.getKey() + "&8: " + printer);
        }
    }

    public static void printConfig(ConfigSection section) {
        List<String> lines = ConfigPrinter.printNode(section.getNode(), "");
        for (String line : lines) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
        }
    }

    public static List<String> printNode(Node node, String nestLevel) {
        ArrayList<String> lines = new ArrayList<String>(1);
        if (!node.getComments().isEmpty()) {
            for (CommentLine comment : node.getComments()) {
                switch (comment.getCommentType()) {
                    case BLOCK_BEFORE: {
                        lines.add(nestLevel + "&8# " + comment.getValue());
                        break;
                    }
                    case BLANK_LINE: {
                        lines.add(nestLevel);
                        break;
                    }
                }
            }
        }
        block4 : switch (node.getNodeType()) {
            case SCALAR: {
                lines.addAll(ConfigPrinter.printScalar(null, nestLevel, node));
                break;
            }
            case SEQUENCE: {
                SequenceNode seq = (SequenceNode)node;
                List nodeList = seq.getValue().stream().flatMap(x -> ConfigPrinter.printNode(x, nestLevel).stream()).collect(Collectors.toList());
                switch (seq.getFlowStyle()) {
                    case AUTO: 
                    case FLOW: {
                        lines.add(ConfigPrinter.printAnchor(seq) + "&8[&6" + String.join((CharSequence)"&7, &6", nodeList) + "&8]");
                        break;
                    }
                    case BLOCK: {
                        lines.add(nestLevel + ConfigPrinter.printAnchor(seq));
                        for (String line : nodeList) {
                            lines.add(nestLevel + "&8- &6" + line);
                        }
                        break;
                    }
                }
                break;
            }
            case MAPPING: {
                MappingNode mapping = (MappingNode)node;
                String ref = ConfigPrinter.printAnchor(node);
                switch (mapping.getFlowStyle()) {
                    case AUTO: 
                    case BLOCK: {
                        for (NodePair pair : mapping.getValue()) {
                            List<String> keyLines = ConfigPrinter.printScalar("&f", nestLevel, pair.getKey());
                            if (keyLines.size() != 1) {
                                throw new IllegalStateException("Key size not 1: " + keyLines);
                            }
                            String keyStr = nestLevel + keyLines.get(0) + "&8: " + ref;
                            List<String> valueLines = ConfigPrinter.printNode(pair.getValue(), nestLevel + "  ");
                            if (!(pair.getValue() instanceof MappingNode) || ((MappingNode)pair.getValue()).getFlowStyle() == FlowStyle.FLOW) {
                                valueLines.set(0, keyStr + valueLines.get(0));
                            } else {
                                lines.add(keyStr);
                            }
                            lines.addAll(valueLines);
                        }
                        break block4;
                    }
                    case FLOW: {
                        StringJoiner joiner = new StringJoiner("&7, ", ref + "&8{ ", " &8}");
                        for (NodePair pair : mapping.getValue()) {
                            List<String> keyLines = ConfigPrinter.printScalar("&f", nestLevel, pair.getKey());
                            if (keyLines.size() != 1) {
                                throw new IllegalStateException("Key size not 1: " + keyLines);
                            }
                            String keyStr = keyLines.get(0) + "&8: ";
                            String value = String.join((CharSequence)('\n' + nestLevel), ConfigPrinter.printNode(pair.getValue(), nestLevel));
                            joiner.add(keyStr + value);
                        }
                        lines.add(joiner.toString());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type " + (Object)((Object)node.getNodeType()));
            }
        }
        return lines;
    }

    private static String printAnchor(Node node) {
        NodeReference ref = node.getReference();
        if (ref == null) {
            return "";
        }
        if (ref instanceof AnciasNodeReference) {
            AnciasNodeReference anciasRef = (AnciasNodeReference)ref;
            switch (anciasRef.getType()) {
                case ALIAS: {
                    return "&5*" + anciasRef.getReference().getIdentifier() + ' ';
                }
                case ANCHOR: {
                    return "&5&n&" + anciasRef.getReference().getIdentifier() + ' ';
                }
            }
            throw new AssertionError((Object)("Unknown ref: " + ref));
        }
        if (ref instanceof CrossNodeReference) {
            return "";
        }
        throw new AssertionError((Object)("Unknown ref " + ref));
    }

    @NotNull
    private static List<String> printScalar(String specialColor, String nestLevel, Node node) {
        String str = ((ScalarNode)node).getValue();
        Tag tag = node.getTag();
        String specialTag = "";
        if (specialColor != null) {
            str = specialColor + str;
        } else if (tag == Tag.INT) {
            str = "&2" + str;
        } else if (tag == Tag.FLOAT) {
            str = "&3" + str;
        } else if (tag == Tag.STR) {
            str = "&6" + str;
        } else if (tag == Tag.BOOL) {
            str = "&9" + str;
        } else if (tag == Tag.NULL) {
            str = "&c" + str;
        } else {
            specialTag = "&e&n!!" + tag.getValue() + ' ';
            str = "&6" + str;
        }
        ArrayList<String> lines = new ArrayList<String>();
        String prefix = specialTag + ConfigPrinter.printAnchor(node);
        switch (((ScalarNode)node).getScalarStyle()) {
            case SINGLE_QUOTED: {
                str = prefix + "&e'" + str + "&e'";
                lines.add(str);
                break;
            }
            case DOUBLE_QUOTED: {
                str = prefix + "&e\"" + str + "&e\"";
                lines.add(str);
                break;
            }
            case LITERAL: {
                lines.add(prefix + "&e|");
                for (String line : str.split("\n")) {
                    lines.add(nestLevel + "  " + line);
                }
                break;
            }
            case FOLDED: {
                lines.add(prefix + "&e>");
                for (String line : str.split("\n")) {
                    lines.add(nestLevel + "  " + line);
                }
                break;
            }
            default: {
                lines.add(prefix + str);
            }
        }
        return lines;
    }
}

