/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.playerselector;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.kingdoms.RelationUtil;
import org.kingdoms.utils.playerselector.AbstractPlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorByRelation;
import org.kingdoms.utils.playerselector.PlayerSelectorInfo;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.SimplePlayerSelectorProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByRelation;", "Lorg/kingdoms/utils/playerselector/AbstractPlayerSelector;", "<init>", "()V", "relation", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "getRelation", "()Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "setRelation", "(Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;)V", "isValid", "", "()Z", "provider", "Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "getProvider", "()Lorg/kingdoms/utils/playerselector/PlayerSelectorProvider;", "test", "info", "Lorg/kingdoms/utils/playerselector/PlayerSelectorInfo;", "serialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "deserialize", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "addMessageContextEdits", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "toString", "", "Companion", "core"})
public final class PlayerSelectorByRelation
extends AbstractPlayerSelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public KingdomRelation relation;
    private final boolean isValid;
    @JvmField
    @NotNull
    public static final SimplePlayerSelectorProvider<PlayerSelectorByRelation> PROVIDER;

    public PlayerSelectorByRelation() {
        super(PROVIDER.getNamespace());
        this.isValid = true;
    }

    @NotNull
    public final KingdomRelation getRelation() {
        KingdomRelation kingdomRelation = this.relation;
        if (kingdomRelation != null) {
            return kingdomRelation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"relation");
        return null;
    }

    public final void setRelation(@NotNull KingdomRelation kingdomRelation) {
        Intrinsics.checkNotNullParameter((Object)((Object)kingdomRelation), (String)"<set-?>");
        this.relation = kingdomRelation;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public PlayerSelectorProvider<PlayerSelectorByRelation> getProvider() {
        return PROVIDER;
    }

    @Override
    public boolean test(@NotNull PlayerSelectorInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        KingdomPlayer kp = info.getKingdomPlayer();
        if (info.getOwner() instanceof Land) {
            Kingdom kingdom = ((Land)info.getOwner()).getKingdom();
            if (kingdom == null) {
                return true;
            }
            Kingdom ownerKingdom = kingdom;
            Kingdom kingdom2 = kp.getKingdom();
            if (kingdom2 == null) {
                return this.getRelation() == KingdomRelation.NEUTRAL;
            }
            Kingdom playerKingdom = kingdom2;
            return ownerKingdom.getRelationWith(playerKingdom) == this.getRelation();
        }
        throw new IllegalStateException("Unknown owner object: " + info.getOwner());
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        context.getDataProvider().setString("relation", this.getRelation().name());
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        String string = context.getDataProvider().getString("relation");
        Intrinsics.checkNotNull((Object)string);
        this.setRelation(KingdomRelation.valueOf(string));
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.raw("relation_name", this.getRelation().getName());
        context.parse("relation_color", this.getRelation().getColor());
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + (Object)((Object)this.getRelation()) + ')';
    }

    static {
        Namespace namespace = Namespace.kingdoms("RELATION");
        Supplier<PlayerSelectorByRelation> supplier = PlayerSelectorByRelation::new;
        PROVIDER = new SimplePlayerSelectorProvider<PlayerSelectorByRelation>(namespace, supplier){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, $super_call_param$2);
            }

            public CompletionStage<PlayerSelectorByRelation> prompt(Player player, PlayerSelectorByRelation selector) {
                Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                KingdomsLang.PLAYER_SELECTORS_RELATION_PROMPT.sendMessage((CommandSender)player);
                CompletableFuture<PlayerSelectorByRelation> completableFuture = ChatInputManager.awaitInput(player, arg_0 -> Companion.PROVIDER.1.prompt$lambda$1(player, arg_0));
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"awaitInput(...)");
                return completableFuture;
            }

            private static final PlayerSelectorByRelation prompt$lambda$1(Player $player, String input) {
                PlayerSelectorByRelation playerSelectorByRelation;
                KingdomRelation relation = RelationUtil.getRelation(input, LanguageManager.localeOf($player));
                if (relation == null) {
                    Object[] objectArray = new Object[]{"relation", input};
                    KingdomsLang.NOT_FOUND_RELATION.sendError((CommandSender)$player, objectArray);
                    return null;
                }
                PlayerSelectorByRelation $this$prompt_u24lambda_u241_u24lambda_u240 = playerSelectorByRelation = new PlayerSelectorByRelation();
                boolean bl = false;
                $this$prompt_u24lambda_u241_u24lambda_u240.setRelation(relation);
                return playerSelectorByRelation;
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/playerselector/PlayerSelectorByRelation$Companion;", "", "<init>", "()V", "PROVIDER", "Lorg/kingdoms/utils/playerselector/SimplePlayerSelectorProvider;", "Lorg/kingdoms/utils/playerselector/PlayerSelectorByRelation;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

