/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.paper;

import java.util.function.Consumer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.potion.PotionEffect;

public final class PaperEvents {
    public static Listener create(Consumer<BeaconEffectEvent> beaconEffectEvent) {
        return new BeaconManager(beaconEffectEvent);
    }

    public static boolean supportsBeaconEffectEvent() {
        return PaperEvents.isSupported("com.destroystokyo.paper.event.block.BeaconEffectEvent");
    }

    private static boolean isSupported(String event) {
        try {
            Class.forName(event);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static final class BeaconManager
    implements Listener {
        private final Consumer<BeaconEffectEvent> beaconEffectEvent;

        private BeaconManager(Consumer<BeaconEffectEvent> beaconEffectEvent) {
            this.beaconEffectEvent = beaconEffectEvent;
        }

        @EventHandler(ignoreCancelled=true)
        public void onBeaconEffect(com.destroystokyo.paper.event.block.BeaconEffectEvent event) {
            if (this.beaconEffectEvent != null) {
                this.beaconEffectEvent.accept(new BeaconEffectEvent(event));
            }
        }
    }

    public static final class BeaconEffectEvent {
        private final com.destroystokyo.paper.event.block.BeaconEffectEvent event;

        public BeaconEffectEvent(com.destroystokyo.paper.event.block.BeaconEffectEvent event) {
            this.event = event;
        }

        public Block getBlock() {
            return this.event.getBlock();
        }

        public void setCancelled(boolean cancelled) {
            this.event.setCancelled(cancelled);
        }

        public Player getPlayer() {
            return this.event.getPlayer();
        }

        public PotionEffect getEffect() {
            return this.event.getEffect();
        }
    }
}

