/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import com.google.common.base.Strings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public final class XBook {
    private static final Object MAIN_HAND;
    private static final MethodHandle CHAT_SERIALIZER;
    private static final MethodHandle OPEN_BOOK_METHOD;
    private static final MethodHandle AS_NMS_COPY;
    private static final MethodHandle PAGES;
    private static final boolean SUPPORTED;
    private static final boolean ADD_PAGES;

    public static void openBook(ItemStack book, Player ... players) {
        Object nmsBook;
        Objects.requireNonNull(book, "Cannot open null book");
        Objects.requireNonNull(players, "Cannot open book to null players");
        if (SUPPORTED) {
            for (Player player : players) {
                player.openBook(book);
            }
            return;
        }
        try {
            nmsBook = AS_NMS_COPY.invoke(book);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        for (Player player : players) {
            PlayerInventory inventory = player.getInventory();
            int slot = inventory.getHeldItemSlot();
            ItemStack previous = inventory.getItem(slot);
            inventory.setItem(slot, book);
            Object nmsPlayer = MinecraftConnection.getHandle((Player)player);
            try {
                OPEN_BOOK_METHOD.invoke(nmsPlayer, nmsBook, MAIN_HAND);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            inventory.setItem(slot, previous);
        }
    }

    public static ItemStack getBook(List<String> pages, Player player, String title, boolean editable, boolean raw) {
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player);
        MessageCompilerSettings compilerSettings = MessageCompilerSettings.none().colorize().translatePlaceholders();
        return XBook.getBook(pages, player.getName(), title, editable, raw ? null : page -> MessageCompiler.compile(page, compilerSettings).buildComplex(settings).createSingular());
    }

    public static ItemStack getBook(List<String> pages, String author, String title, boolean editable, Function<String, BaseComponent[]> pageTranslator) {
        ItemStack book = (editable ? XMaterial.WRITABLE_BOOK : XMaterial.WRITTEN_BOOK).parseItem();
        BookMeta bookMeta = (BookMeta)book.getItemMeta();
        bookMeta.setAuthor(author);
        bookMeta.setTitle(title);
        if (pageTranslator == null) {
            bookMeta.setPages(pages.toArray(new String[0]));
        } else {
            for (String page : pages) {
                if (Strings.isNullOrEmpty((String)page)) {
                    bookMeta.addPage(new String[]{""});
                    continue;
                }
                BaseComponent[] msg = pageTranslator.apply(page);
                bookMeta.spigot().addPage((BaseComponent[][])new BaseComponent[][]{msg});
            }
        }
        book.setItemMeta((ItemMeta)bookMeta);
        return book;
    }

    private static void setPages(BookMeta bookMeta, List<String> rawPages) {
    }

    static {
        boolean addPages;
        boolean openBook;
        CHAT_SERIALIZER = null;
        PAGES = null;
        try {
            Player.class.getDeclaredMethod("openBook", ItemStack.class);
            openBook = true;
        }
        catch (NoSuchMethodException ex) {
            openBook = false;
        }
        SUPPORTED = openBook;
        try {
            BookMeta.class.getDeclaredMethod("spigot", new Class[0]);
            addPages = true;
        }
        catch (NoSuchMethodException ex) {
            addPages = false;
        }
        ADD_PAGES = addPages;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle openBookMethod = null;
        MethodHandle asNMSCopy = null;
        Object chatSerializer = null;
        Object pages = null;
        Object mainHand = null;
        if (!SUPPORTED) {
            Class hand = XReflection.getNMSClass((String)"EnumHand");
            Class entityPlayer = XReflection.getNMSClass((String)"EntityPlayer");
            Class nmsItemStack = XReflection.getNMSClass((String)"ItemStack");
            Class craftItemStack = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "inventory").named(new String[]{"CraftItemStack"}).unreflect();
            try {
                mainHand = hand.getField("MAIN_HAND").get(null);
                asNMSCopy = lookup.findStatic(craftItemStack, "asNMSCopy", MethodType.methodType(nmsItemStack, ItemStack.class));
                openBookMethod = XReflection.supports((int)9) ? lookup.findVirtual(entityPlayer, "a", MethodType.methodType(Void.TYPE, nmsItemStack, hand)) : lookup.findVirtual(entityPlayer, "openBook", MethodType.methodType(Void.TYPE, nmsItemStack));
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        MAIN_HAND = mainHand;
        OPEN_BOOK_METHOD = openBookMethod;
        AS_NMS_COPY = asNMSCopy;
    }
}

