/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.managers.holograms.Hologram;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.display.models.ArmorStandEntityVisualModel;
import org.kingdoms.utils.display.models.HologramVisualModel;
import org.kingdoms.utils.display.models.TextDisplayEntitySettings;
import org.kingdoms.utils.display.models.TextDisplayEntityVisualModel;
import org.kingdoms.utils.nms.EntityFactory;
import org.kingdoms.utils.nms.EntitySpawner;
import org.kingdoms.utils.nms.FakeArmorStand;
import org.kingdoms.utils.nms.TemporaryEntity;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class HologramFactory {
    private static final MethodHandle ENTITY_ARMOR_STAND_CTOR;
    private static final MethodHandle PACKET_PLAY_OUT_ENTITY_METADATA_CTOR;
    private static final MethodHandle GET_ENTITY_HANDLE;
    private static final MethodHandle SET_MARKER;
    private static final MethodHandle SET_INVISIBLE;
    private static final MethodHandle SET_CUSTOM_NAME_VISIBLE;
    private static final MethodHandle SET_CUSTOM_NAME;
    private static final MethodHandle FROM_STRING_OR_NULL;
    private static final MethodHandle WATCHER_PACK;
    private static final PotionEffect LEVITATION;

    public static void updateHolograms(Collection<? extends Player> showTo, Collection<FakeArmorStand> holograms) {
        ArrayList<Object> metaPackets = new ArrayList<Object>(holograms.size());
        for (FakeArmorStand hologram : holograms) {
            try {
                Object object = GET_ENTITY_HANDLE.invoke(hologram.getEntity());
                hologram.setMetadataPacket(HologramFactory.createMetadataPacket(object));
                metaPackets.add(hologram.getMetadataPacket());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        Object[] metaPacketArray = metaPackets.toArray();
        for (Player player : showTo) {
            MinecraftConnection.sendPacket((Player)player, (Object[])metaPacketArray);
        }
    }

    public static void spawn(Location location, String text) {
        Set<GroupedHologram> holograms = Collections.singleton(new GroupedHologram(new Hologram(new TextDisplayEntitySettings(new StaticMessenger(text), null, null, null, null, null, null, null, null, null, null)), Vector3.ZERO));
        HologramVisualModel model = VersionSupport.SUPPORTS_TEXT_DISPLAYS ? new TextDisplayEntityVisualModel(holograms) : new ArmorStandEntityVisualModel(holograms);
        model.visibleTo(location.getWorld().getPlayers().stream().map(Entity::getUniqueId).collect(Collectors.toSet()));
        model.spawn(BukkitAdapter.adapt(location), MessagePlaceholderProvider.DEFAULT);
        Kingdoms.taskScheduler().sync().delayed(Duration.ofSeconds(5L), model::remove);
    }

    public static ArmorStand spawnUpwards(Location location, String text) {
        ArmorStand armorstand = EntitySpawner.of(ArmorStand.class).at(location.add(0.0, -0.6, 0.0)).modify(entity2 -> {
            entity2.setVisible(false);
            entity2.addPotionEffect(LEVITATION);
            entity2.setCustomName(text);
            entity2.setCustomNameVisible(true);
        }).spawn();
        TemporaryEntity.addTemporaryEntity((Entity)armorstand);
        Kingdoms.taskScheduler().sync().delayed(Duration.ofSeconds(5L), () -> ((ArmorStand)armorstand).remove());
        return armorstand;
    }

    public static ArmorStand spawn(Location location, Collection<? extends Player> showTo, @NonNull String description) {
        return HologramFactory.spawn(location, showTo, (ArmorStand armorStand) -> {
            armorStand.setVisible(false);
            armorStand.setMarker(true);
            armorStand.setCustomNameVisible(true);
            armorStand.setCustomName(description);
        });
    }

    private static MethodHandle getDataWatcher() throws Exception {
        Class DataWatcherClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "SynchedEntityData").map(MinecraftMapping.SPIGOT, "DataWatcher").unreflect();
        Class DataWatcherObjectClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "EntityDataAccessor").map(MinecraftMapping.SPIGOT, "DataWatcherObject").unreflect();
        MinecraftClassHandle nmsEntity = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named(new String[]{"Entity"});
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        return nmsEntity.method().returns(DataWatcherClass).map(MinecraftMapping.MOJANG, "getEntityData").map(MinecraftMapping.OBFUSCATED, (String)XReflection.v((int)20, (int)5, (Object)"ap").v(20, 4, (Object)"an").v(20, 2, (Object)"al").v(19, (Object)"aj").v(18, (Object)"ai").orElse((Object)"getDataWatcher")).reflect();
    }

    public static ArmorStand spawn(Location location, Collection<? extends Player> showTo, @NonNull Consumer<ArmorStand> handler) {
        Objects.requireNonNull(showTo);
        FakeArmorStand fakeArmorStand = HologramFactory.createHologram(location, handler);
        HologramFactory.spawn(showTo, Collections.singleton(fakeArmorStand));
        return fakeArmorStand.getEntity();
    }

    public static void spawn(Collection<? extends Player> showTo, @NonNull Collection<FakeArmorStand> fakeArmorStand) {
        Objects.requireNonNull(showTo);
        Object[] mergedPackets = fakeArmorStand.stream().flatMap(x -> Stream.of(x.getPackets())).toArray();
        for (Player player : showTo) {
            MinecraftConnection.sendPacket((Player)player, (Object[])mergedPackets);
        }
    }

    public static FakeArmorStand createHologram(Location location, @NonNull Consumer<ArmorStand> handler) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(handler);
        Object nmsArmorStand = null;
        try {
            nmsArmorStand = ENTITY_ARMOR_STAND_CTOR.invoke(EntityFactory.getNMSWorld(location.getWorld()), location.getX(), location.getY(), location.getZ());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        ArmorStand armorStand = (ArmorStand)EntityFactory.getBukkitEntity(nmsArmorStand);
        handler.accept(armorStand);
        Object spawnPacket = EntityFactory.createSpawnPacket(nmsArmorStand);
        Object packetPlayOutEntityMetadata = HologramFactory.createMetadataPacket(nmsArmorStand);
        return new FakeArmorStand(armorStand, spawnPacket, packetPlayOutEntityMetadata);
    }

    private static Object createMetadataPacket(Object nmsArmorStand) {
        Object packetPlayOutEntityMetadata;
        try {
            Object watcher = HologramFactory.getDataWatcher().invoke(nmsArmorStand);
            packetPlayOutEntityMetadata = XReflection.supports((int)19) ? PACKET_PLAY_OUT_ENTITY_METADATA_CTOR.invoke(nmsArmorStand.hashCode(), WATCHER_PACK.invoke(watcher)) : PACKET_PLAY_OUT_ENTITY_METADATA_CTOR.invoke(nmsArmorStand.hashCode(), watcher, false);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return packetPlayOutEntityMetadata;
    }

    static {
        Class craftChatMessage = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "util").named(new String[]{"CraftChatMessage"}).unreflect();
        Class CraftArmorStand = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named(new String[]{"CraftArmorStand"}).unreflect();
        Class CraftEntityClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named(new String[]{"CraftEntity"}).unreflect();
        MinecraftClassHandle IChatBaseComponent = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").map(MinecraftMapping.MOJANG, "Component").map(MinecraftMapping.SPIGOT, "IChatBaseComponent");
        MinecraftClassHandle EntityArmorStand = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity.decoration").map(MinecraftMapping.MOJANG, "ArmorStand").map(MinecraftMapping.SPIGOT, "EntityArmorStand");
        MinecraftClassHandle PacketPlayOutEntityMetadata = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundSetEntityDataPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutEntityMetadata");
        Class DataWatcher = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "SynchedEntityData").map(MinecraftMapping.SPIGOT, "DataWatcher").unreflect();
        Class NMSEntity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "Entity").map(MinecraftMapping.SPIGOT, "Entity").unreflect();
        Class NMSWorld = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.level").map(MinecraftMapping.MOJANG, "Level").map(MinecraftMapping.SPIGOT, "World").unreflect();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle fromStringOrNull = null;
        MethodHandle EntityArmorStandCtor = null;
        MethodHandle PacketPlayOutEntityMetadataCtor = null;
        MethodHandle watcherPack = null;
        MethodHandle setMarker = null;
        MethodHandle setCustomNameVisible = null;
        MethodHandle setInvisible = null;
        MethodHandle setCustomName = null;
        MethodHandle getHandle = null;
        try {
            getHandle = lookup.findVirtual(CraftEntityClass, "getHandle", MethodType.methodType(NMSEntity));
            EntityArmorStandCtor = (MethodHandle)EntityArmorStand.constructor(new Class[]{NMSWorld, Double.TYPE, Double.TYPE, Double.TYPE}).unreflect();
            PacketPlayOutEntityMetadataCtor = (MethodHandle)PacketPlayOutEntityMetadata.constructor((Class[])XReflection.v((int)19, (Object)new Class[]{Integer.TYPE, List.class}).orElse((Object)new Class[]{Integer.TYPE, DataWatcher, Boolean.TYPE})).unreflect();
            watcherPack = lookup.findVirtual(DataWatcher, "b", MethodType.methodType(List.class));
            setMarker = lookup.findVirtual(CraftArmorStand, "setMarker", MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setCustomNameVisible = lookup.findVirtual(CraftArmorStand, "setCustomNameVisible", MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setInvisible = lookup.findVirtual(CraftArmorStand, (String)XReflection.v((int)13, (Object)"setInvisible").orElse((Object)"setVisible"), MethodType.methodType(Void.TYPE, Boolean.TYPE));
            setCustomName = lookup.findVirtual(CraftArmorStand, "setCustomName", MethodType.methodType(Void.TYPE, String.class));
            fromStringOrNull = lookup.findStatic(craftChatMessage, (String)XReflection.v((int)13, (Object)"fromStringOrNull").orElse((Object)"fromString"), (MethodType)XReflection.v((int)13, (Object)MethodType.methodType((Class)IChatBaseComponent.unreflect(), String.class, Boolean.TYPE)).orElse((Object)MethodType.methodType((Class)IChatBaseComponent.asArray().unreflect(), String.class, Boolean.TYPE)));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        GET_ENTITY_HANDLE = getHandle;
        ENTITY_ARMOR_STAND_CTOR = EntityArmorStandCtor;
        PACKET_PLAY_OUT_ENTITY_METADATA_CTOR = PacketPlayOutEntityMetadataCtor;
        SET_MARKER = setMarker;
        SET_INVISIBLE = setInvisible;
        SET_CUSTOM_NAME_VISIBLE = setCustomNameVisible;
        SET_CUSTOM_NAME = setCustomName;
        FROM_STRING_OR_NULL = fromStringOrNull;
        WATCHER_PACK = watcherPack;
        LEVITATION = XPotion.LEVITATION.buildPotionEffect(200, 1);
    }
}

