/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.network;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.admin.CommandAdminAddons;
import org.kingdoms.commands.admin.CommandAdminLanguagePack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

public final class UpdateChecker
implements Listener {
    private static final int $RESOURCE_ID = 77670;
    private static final String REPO = "https://repo1.maven.org/maven2/com/github/cryptomorin/kingdoms/";
    private static final String REQUEST = "https://api.spigotmc.org/simple/0.1/index.php?action=getResource&id=77670";
    private static final String SPIGET = "http://api.spiget.org/v2/resources/77670/download/";
    private static final String USER_AGENT = "KingdomsX-Update-Checker";
    private static final Plugin PLUGIN = Kingdoms.get();
    private static final String CURRENT_VERSION = PLUGIN.getDescription().getVersion();
    private static int lastHttpResponseCode;
    private static String latestVersion;
    private static boolean canUpdate;

    public UpdateChecker() {
        if (KingdomsConfig.MAIN.getConfig().getBoolean("updates", "check")) {
            UpdateChecker.checkForUpdates().thenAcceptAsync(x -> {
                UpdateChecker.sendUpdates();
                if (canUpdate && KingdomsConfig.MAIN.getConfig().getBoolean("updates", "download")) {
                    UpdateChecker.downloadRepositoryToConfiguredPath();
                }
            });
            Kingdoms.taskScheduler().async().delayed(Duration.ofSeconds(10L), () -> {
                CommandAdminAddons.checkForUpdates();
                CommandAdminAddons.notifyAboutUpdates((CommandSender)Bukkit.getConsoleSender());
                CommandAdminLanguagePack.checkForUpdates();
                CommandAdminLanguagePack.notifyAboutUpdates((CommandSender)Bukkit.getConsoleSender());
            });
            Bukkit.getPluginManager().registerEvents((Listener)this, PLUGIN);
        }
    }

    private static List<Integer> cleanVersion(String str, int upTo) {
        int len = str.length();
        char[] chs = new char[len];
        int endIndex = 0;
        ArrayList<Integer> splits = new ArrayList<Integer>(10);
        int previousSplit = 0;
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '.') {
                if (previousSplit >= endIndex) {
                    return null;
                }
                splits.add(UpdateChecker.charsToInt(chs, previousSplit, endIndex));
                if (upTo == splits.size()) {
                    return splits;
                }
                previousSplit = ++endIndex;
            }
            if (ch < '0' || ch > '9') continue;
            chs[endIndex++] = ch;
        }
        if (endIndex != 0) {
            splits.add(UpdateChecker.charsToInt(chs, previousSplit, endIndex));
        }
        return splits.isEmpty() ? null : splits;
    }

    private static int charsToInt(char[] digits, int index, int endIndex) {
        int result = 0;
        while (index < endIndex) {
            int digit = digits[index] - 48;
            result *= 10;
            result += digit;
            ++index;
        }
        return result;
    }

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static int getLastHttpResponseCode() {
        return lastHttpResponseCode;
    }

    public static CompletableFuture<Void> checkForUpdates() {
        return ((CompletableFuture)UpdateChecker.fetchLatestVersion().thenAcceptAsync(result -> {
            latestVersion = result;
            canUpdate = UpdateChecker.isHigher(CURRENT_VERSION, result);
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static boolean canUpdate() {
        return canUpdate;
    }

    public static String getLatestVersion() {
        return latestVersion;
    }

    public static void sendUpdates() {
        if (!KingdomsConfig.MAIN.getConfig().getBoolean("updates", "check")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously(PLUGIN, () -> {
            if (canUpdate) {
                UpdateChecker.sendMessages(UpdateChecker.updateText());
            } else if (latestVersion != null) {
                UpdateChecker.sendMessages("&2No update found &7- &8(&6v" + CURRENT_VERSION + "&8)");
            }
        });
    }

    @EventHandler
    public static void onJoinNotify(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission(PLUGIN.getName() + ".updates")) {
            return;
        }
        if (canUpdate && KingdomsConfig.MAIN.getConfig().getBoolean("updates", "check")) {
            UpdateChecker.sendMessages((CommandSender)player, UpdateChecker.updateText());
        }
        Kingdoms.taskScheduler().async().delayed(Duration.ofSeconds(10L), () -> {
            CommandAdminLanguagePack.notifyAboutUpdates((CommandSender)player);
            CommandAdminAddons.notifyAboutUpdates((CommandSender)player);
        });
    }

    private static void sendMessages(@NotNull String msg) {
        UpdateChecker.sendMessages((CommandSender)Bukkit.getConsoleSender(), msg);
    }

    private static void sendMessages(@NotNull CommandSender receiver, @NotNull String msg) {
        MessageHandler.sendPluginMessage(receiver, msg);
    }

    public static String updateText() {
        return "&8-=-=-=-=-=-=-=-=-=-=-=-=-\n&2There is an update available!\nCurrent Version&8: &6v" + CURRENT_VERSION + "\n&2Latest Version&8: &6v" + latestVersion + '\n' + "&8-=-=-=-=-=-=-=-=-=-=-=-=-";
    }

    @NotNull
    public static CompletableFuture<String> fetchLatestVersionLegacy() {
        return Kingdoms.taskScheduler().async().supplyFuture(() -> {
            String string;
            block15: {
                URL url = new URL(REQUEST);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                con.setConnectTimeout(2000);
                con.setReadTimeout(2000);
                con.setDoOutput(true);
                UpdateChecker.sendMessages("&2Checking for updates...");
                lastHttpResponseCode = con.getResponseCode();
                InputStream response = con.getResponseCode() == 200 ? con.getInputStream() : con.getErrorStream();
                try {
                    String version;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(response, StandardCharsets.ISO_8859_1));){
                        version = br.lines().collect(Collectors.joining(" "));
                    }
                    String string2 = string = version.isEmpty() ? null : version;
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        UpdateChecker.sendMessages("&cFailed to check for updates&8: &e" + ex.getMessage() + " (internet connection problems?)");
                        if (KingdomsConfig.MAIN.getConfig().getBoolean("debug")) {
                            ex.printStackTrace();
                        }
                        return null;
                    }
                }
                response.close();
            }
            return string;
        }).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static CompletableFuture<String> fetchLatestVersion() {
        return Kingdoms.taskScheduler().async().supplyFuture(() -> {
            try {
                UpdateChecker.sendMessages("&2Checking for updates...");
                URL url = new URL(REQUEST);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                con.addRequestProperty("User-Agent", USER_AGENT);
                con.setConnectTimeout(2000);
                con.setReadTimeout(2000);
                con.setDoOutput(true);
                lastHttpResponseCode = con.getResponseCode();
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(con.getInputStream()));
                JsonElement json = new JsonParser().parse(reader);
                return json.getAsJsonObject().get("current_version").getAsString();
            }
            catch (Throwable ex) {
                UpdateChecker.sendMessages("&cFailed to check for updates&8: &e" + ex.getMessage() + " (internet connection problems?)");
                if (KLogger.isDebugging()) {
                    ex.printStackTrace();
                }
                return null;
            }
        }).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public static CompletableFuture<Void> downloadUpdate() {
        return Kingdoms.taskScheduler().async().runFuture(() -> {
            try {
                URL link = new URL(SPIGET);
                ReadableByteChannel readChan = Channels.newChannel(link.openStream());
                FileOutputStream output = new FileOutputStream(new File(PLUGIN.getDataFolder(), PLUGIN.getName() + '-' + latestVersion + ".jar"));
                FileChannel writeChan = output.getChannel();
                writeChan.transferFrom(readChan, 0L, Long.MAX_VALUE);
                output.flush();
                readChan.close();
                writeChan.close();
                UpdateChecker.sendMessages("&2Successfully downloaded the plugin. Check the plugin folder.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static boolean isHigher(String currentVer, @Nullable String newVer) {
        int min;
        if (Strings.isNullOrEmpty((String)newVer)) {
            return false;
        }
        if (currentVer.equalsIgnoreCase(newVer)) {
            return false;
        }
        List<Integer> oldVersionSegments = UpdateChecker.cleanVersion(currentVer, 0);
        if (oldVersionSegments == null || oldVersionSegments.isEmpty()) {
            throw new IllegalArgumentException("Cannot parse numbers of version '" + currentVer + "' compared to: " + newVer);
        }
        List<Integer> newVersionSegments = UpdateChecker.cleanVersion(newVer, oldVersionSegments.size() + 1);
        if (newVersionSegments == null) {
            throw new IllegalArgumentException("Unknown newer version: " + newVer);
        }
        int max = Math.max(oldVersionSegments.size(), newVersionSegments.size());
        boolean notSameLength = max != (min = Math.min(oldVersionSegments.size(), newVersionSegments.size()));
        for (int i = 0; i < max; ++i) {
            if (notSameLength && i == min) {
                return max == newVersionSegments.size();
            }
            int older = oldVersionSegments.get(i);
            int newer = newVersionSegments.get(i);
            if (newer == older) continue;
            return newer > older;
        }
        return false;
    }

    public static String getJarName() {
        return PLUGIN.getName().toLowerCase(Locale.ENGLISH) + '-' + latestVersion + ".jar";
    }

    public static Path getDownloadPath() {
        String path = KingdomsConfig.MAIN.getConfig().getString("updates.path");
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        path = org.kingdoms.utils.string.Strings.replace(org.kingdoms.utils.string.Strings.replace(path, "version", CURRENT_VERSION), "latest_version", latestVersion);
        return PLUGIN.getDataFolder().toPath().resolve(path);
    }

    public static CompletableFuture<Void> downloadRepositoryToConfiguredPath() {
        Path path = UpdateChecker.getDownloadPath();
        if (path == null) {
            return CompletableFuture.completedFuture(null);
        }
        return UpdateChecker.downloadRepository(path);
    }

    @Nonnull
    public static CompletableFuture<Void> downloadRepository(Path to) {
        return Kingdoms.taskScheduler().async().runFuture(() -> {
            try {
                URL link = new URL(REPO + latestVersion + '/' + UpdateChecker.getJarName());
                ReadableByteChannel readChan = Channels.newChannel(link.openStream());
                Files.createDirectories(to.getParent(), new FileAttribute[0]);
                FileChannel writeChan = FileChannel.open(to, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                writeChan.transferFrom(readChan, 0L, Integer.MAX_VALUE);
                writeChan.close();
                readChan.close();
                UpdateChecker.sendMessages("&2Successfully downloaded the plugin to&8: &6" + to.toAbsolutePath());
            }
            catch (IOException ex) {
                UpdateChecker.sendMessages("&4Failed to download the plugin&8:");
                if (ex instanceof FileNotFoundException) {
                    UpdateChecker.sendMessages("&cCannot find the version &e" + latestVersion + " &cin the repository.");
                }
                ex.printStackTrace();
            }
        });
    }
}

