/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.network;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import org.kingdoms.utils.gson.KingdomsGson;

public abstract class SocketJsonCommunicator {
    private final ServerSocket serverSocket;
    private Socket socket;
    private final Thread dataListener;
    private final Logger logger;

    public SocketJsonCommunicator(int port, Logger logger) {
        this(null, port, logger);
    }

    public SocketJsonCommunicator(InetAddress ip, int port, Logger logger) {
        this.logger = logger;
        try {
            this.serverSocket = new ServerSocket(port, 10, ip);
            this.log("Socket server started.");
            this.log("Creating data listener thread...");
            this.dataListener = new Thread(new Listener());
            this.dataListener.start();
            this.log("Listener thread has started.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void log(String info) {
        this.logger.info("[Socket][" + this.serverSocket.getInetAddress() + ':' + this.serverSocket.getLocalPort() + "] " + info);
    }

    public abstract void onReceive(JsonElement var1);

    public JsonElement receive() {
        try {
            InputStream is = this.socket.getInputStream();
            byte[] lenBytes = new byte[4];
            is.read(lenBytes, 0, 4);
            int len = (lenBytes[3] & 0xFF) << 24 | (lenBytes[2] & 0xFF) << 16 | (lenBytes[1] & 0xFF) << 8 | lenBytes[0] & 0xFF;
            byte[] receivedBytes = new byte[len];
            is.read(receivedBytes, 0, len);
            String data = new String(receivedBytes, 0, len);
            this.log("Received: " + data);
            return KingdomsGson.fromString(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(JsonElement data) {
        try (OutputStream os = this.socket.getOutputStream();){
            String jsonStr = KingdomsGson.toString(data);
            this.log("Sending: " + jsonStr);
            byte[] toSendBytes = jsonStr.getBytes();
            int toSendLen = toSendBytes.length;
            byte[] toSendLenBytes = new byte[]{(byte)(toSendLen & 0xFF), (byte)(toSendLen >> 8 & 0xFF), (byte)(toSendLen >> 16 & 0xFF), (byte)(toSendLen >> 24 & 0xFF)};
            os.write(toSendLenBytes);
            os.write(toSendBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.socket.close();
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final class Listener
    extends Thread {
        private Listener() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    SocketJsonCommunicator.this.log("Accepting socket data...");
                    SocketJsonCommunicator.this.socket = SocketJsonCommunicator.this.serverSocket.accept();
                    SocketJsonCommunicator.this.log("Reading received data...");
                    try {
                        JsonElement data = SocketJsonCommunicator.this.receive();
                        SocketJsonCommunicator.this.onReceive(data);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

