/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.tracker;

import java.util.Iterator;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableIterator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\r\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u0015\u001a\u00020\u0006H\u0096\u0003R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/utils/internal/tracker/TrackedIterator;", "K", "", "original", "onRemove", "Ljava/util/function/Function;", "", "<init>", "(Ljava/util/Iterator;Ljava/util/function/Function;)V", "getOriginal", "()Ljava/util/Iterator;", "getOnRemove", "()Ljava/util/function/Function;", "next", "getNext", "()Ljava/lang/Object;", "setNext", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "remove", "", "hasNext", "shared"})
public final class TrackedIterator<K>
implements Iterator<K>,
KMutableIterator {
    @NotNull
    private final Iterator<K> original;
    @NotNull
    private final Function<K, Boolean> onRemove;
    @Nullable
    private K next;

    public TrackedIterator(@NotNull Iterator<? extends K> original, @NotNull Function<K, Boolean> onRemove) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(onRemove, (String)"onRemove");
        this.original = original;
        this.onRemove = onRemove;
    }

    @NotNull
    public final Iterator<K> getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function<K, Boolean> getOnRemove() {
        return this.onRemove;
    }

    @Nullable
    public final K getNext() {
        return this.next;
    }

    public final void setNext(@Nullable K k) {
        this.next = k;
    }

    @Override
    public void remove() {
        if (this.next == null) {
            this.original.remove();
        }
        K k = this.next;
        Intrinsics.checkNotNull(k);
        if (!this.onRemove.apply(k).booleanValue()) {
            return;
        }
        this.original.remove();
    }

    @Override
    public K next() {
        K n = this.original.next();
        this.next = n;
        return n;
    }

    @Override
    public boolean hasNext() {
        return this.original.hasNext();
    }
}

