/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.tracker;

import java.util.Collection;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.CollectionToArray;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableCollection;
import org.kingdoms.utils.internal.tracker.TrackedCollectionIterator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0096\u0002J\u0015\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u001a\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u001f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0096\u0001J\t\u0010 \u001a\u00020\u0006H\u0096\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0012\u0010!\u001a\u00020\"X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lorg/kingdoms/utils/internal/tracker/TrackedCollection;", "K", "", "original", "onAdd", "Ljava/util/function/Function;", "", "onRemove", "<init>", "(Ljava/util/Collection;Ljava/util/function/Function;Ljava/util/function/Function;)V", "getOriginal", "()Ljava/util/Collection;", "getOnAdd", "()Ljava/util/function/Function;", "getOnRemove", "addAll", "elements", "", "clear", "", "iterator", "Lorg/kingdoms/utils/internal/tracker/TrackedCollectionIterator;", "add", "element", "(Ljava/lang/Object;)Z", "remove", "removeAll", "retainAll", "toString", "", "contains", "containsAll", "isEmpty", "size", "", "getSize", "()I", "shared"})
public final class TrackedCollection<K>
implements Collection<K>,
KMutableCollection {
    @NotNull
    private final Collection<K> original;
    @NotNull
    private final Function<K, Boolean> onAdd;
    @NotNull
    private final Function<K, Boolean> onRemove;

    public TrackedCollection(@NotNull Collection<K> original, @NotNull Function<K, Boolean> onAdd, @NotNull Function<K, Boolean> onRemove) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(onAdd, (String)"onAdd");
        Intrinsics.checkNotNullParameter(onRemove, (String)"onRemove");
        this.original = original;
        this.onAdd = onAdd;
        this.onRemove = onRemove;
    }

    @NotNull
    public final Collection<K> getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function<K, Boolean> getOnAdd() {
        return this.onAdd;
    }

    @NotNull
    public final Function<K, Boolean> getOnRemove() {
        return this.onRemove;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends K> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : elements) {
            if (!this.original.add(element)) continue;
            this.onAdd.apply(element);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        for (K element : this.original) {
            this.onRemove.apply(element);
        }
        this.original.clear();
    }

    @Override
    @NotNull
    public TrackedCollectionIterator<K> iterator() {
        return new TrackedCollectionIterator<K>(this.original.iterator(), this.onRemove);
    }

    @Override
    public boolean add(K element) {
        if (this.original.add(element)) {
            this.onAdd.apply(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object element) {
        if (this.original.remove(element)) {
            this.onRemove.apply(element);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (Object object : elements) {
            if (!this.original.remove(object)) continue;
            this.onRemove.apply(object);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean changed = false;
        for (K element : this.original) {
            if (elements.contains(element)) continue;
            this.onRemove.apply(element);
            changed = true;
        }
        return changed;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.original + ')';
    }

    public int getSize() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.original.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.original.containsAll(elements);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

