/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Deprecated;
import org.kingdoms.libs.kotlin.DeprecationLevel;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.ReplaceWith;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b\"\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0017R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/utils/internal/string/StringPadder;", "", "<init>", "()V", "sentences", "", "Lorg/kingdoms/utils/internal/string/StringPadder$Sentence;", "expectedSentenceWordCount", "", "pad", "words", "", "([Ljava/lang/Object;)Lorg/kingdoms/utils/internal/string/StringPadder;", "getPadded", "", "", "getPaddedString", "separator", "toString", "", "Sentence", "shared"})
@SourceDebugExtension(value={"SMAP\nStringPadder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringPadder.kt\norg/kingdoms/utils/internal/string/StringPadder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n11158#3:60\n11493#3,3:61\n1948#4,14:64\n1557#4:78\n1628#4,3:79\n*S KotlinDebug\n*F\n+ 1 StringPadder.kt\norg/kingdoms/utils/internal/string/StringPadder\n*L\n25#1:60\n25#1:61,3\n37#1:64,14\n47#1:78\n47#1:79,3\n*E\n"})
public final class StringPadder {
    @NotNull
    private final List<Sentence> sentences = new ArrayList();
    private int expectedSentenceWordCount = -1;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StringPadder pad(Object ... words) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)words, (String)"words");
        if (!(!(words.length == 0))) {
            boolean $i$a$-require-StringPadder$pad$32 = false;
            String $i$a$-require-StringPadder$pad$32 = "Cannot pad sentence with no words";
            throw new IllegalArgumentException($i$a$-require-StringPadder$pad$32.toString());
        }
        if (!(this.expectedSentenceWordCount == -1 || words.length == this.expectedSentenceWordCount)) {
            boolean $i$a$-require-StringPadder$pad$42 = false;
            StringBuilder stringBuilder = new StringBuilder().append("Expected sentence word count ").append(this.expectedSentenceWordCount).append(" but this one is ").append(words.length).append(" (");
            String string = Arrays.toString(words);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String $i$a$-require-StringPadder$pad$42 = stringBuilder.append(string).append(')').toString();
            throw new IllegalArgumentException($i$a$-require-StringPadder$pad$42.toString());
        }
        this.expectedSentenceWordCount = words.length;
        Object[] objectArray = words;
        List<Sentence> list = this.sentences;
        boolean $i$f$map = false;
        void var4_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_15 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        List list2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        list.add(new Sentence(list2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPadded() {
        void $this$mapTo$iv$iv;
        Object padded;
        Iterable<String> words;
        if (!(this.expectedSentenceWordCount != -1)) {
            boolean $i$a$-require-StringPadder$getPadded$22 = false;
            String $i$a$-require-StringPadder$getPadded$22 = "No sentences added to pad (" + this.sentences + ')';
            throw new IllegalArgumentException($i$a$-require-StringPadder$getPadded$22.toString());
        }
        int $i$a$-require-StringPadder$getPadded$22 = this.expectedSentenceWordCount;
        for (int i = 0; i < $i$a$-require-StringPadder$getPadded$22; ++i) {
            Object t;
            words = new ArrayList(this.sentences.size());
            for (Sentence sentence : this.sentences) {
                ((ArrayList)words).add(sentence.getWords().get(i));
            }
            Iterable $this$maxBy$iv = words;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                String it = (String)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.length();
                do {
                    Object e$iv = iterator$iv.next();
                    String it2 = (String)e$iv;
                    $i$a$-maxByOrThrow-StringPadder$getPadded$maxLength$1 = false;
                    int v$iv = it2.length();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            int maxLength = ((String)t).length();
            for (Sentence sentence : this.sentences) {
                String word = sentence.getWords().get(i);
                if (word.length() >= maxLength) continue;
                padded = StringsKt.padEnd((String)word, (int)maxLength, (char)' ');
                sentence.getWords().set(i, (String)padded);
            }
        }
        Iterable $this$map$iv = this.sentences;
        boolean $i$f$map = false;
        words = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            padded = (Sentence)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CollectionsKt.joinToString$default((Iterable)it.getWords(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getPaddedString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return CollectionsKt.joinToString$default((Iterable)this.getPadded(), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @Deprecated(message="Use getPadded() instead", replaceWith=@ReplaceWith(expression="getPadded()", imports={}), level=DeprecationLevel.ERROR)
    @NotNull
    public Void toString() {
        throw new UnsupportedOperationException("Use getPadded() instead");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/kingdoms/utils/internal/string/StringPadder$Sentence;", "", "words", "", "", "<init>", "(Ljava/util/List;)V", "getWords", "()Ljava/util/List;", "setWords", "shared"})
    private static final class Sentence {
        @NotNull
        private List<String> words;

        public Sentence(@NotNull List<String> words) {
            Intrinsics.checkNotNullParameter(words, (String)"words");
            this.words = words;
        }

        @NotNull
        public final List<String> getWords() {
            return this.words;
        }

        public final void setWords(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.words = list;
        }
    }
}

