/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.Locale;
import java.util.Objects;
import java.util.stream.IntStream;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;

public class QuantumString
implements CharSequence,
Cloneable {
    private final @Nullable String original;
    private final @NonNull String quantumValue;

    public static QuantumString of(String original) {
        return new QuantumString(original, true);
    }

    public QuantumString(@NonNull String original, boolean quantum) {
        Objects.requireNonNull(original, "Quantum original string cannot be null");
        this.original = quantum ? original : null;
        this.quantumValue = quantum ? original.toLowerCase(Locale.ENGLISH) : original;
    }

    public static QuantumString empty() {
        return new QuantumString("", false);
    }

    public boolean isQuantum() {
        return this.original != null;
    }

    public int hashCode() {
        return this.quantumValue.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof QuantumString && this.quantumValue.equals(((QuantumString)obj).quantumValue);
    }

    @Override
    public String toString() {
        return "QuantumString:[quantum= " + this.isQuantum() + ", original=" + this.original + ", quantumValue=" + this.quantumValue + ']';
    }

    @Override
    public int length() {
        return this.quantumValue.length();
    }

    @Override
    public boolean isEmpty() {
        return this.quantumValue.isEmpty();
    }

    @Override
    public char charAt(int index) {
        return this.getQuantum().charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.getQuantum().subSequence(start, end);
    }

    @Override
    @NotNull
    public IntStream chars() {
        return this.getQuantum().chars();
    }

    @Override
    @NotNull
    public IntStream codePoints() {
        return this.getQuantum().codePoints();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public @Nullable String getOriginal() {
        return this.original;
    }

    public @NonNull String getQuantumValue() {
        return this.quantumValue;
    }

    public @NonNull String getQuantum() {
        return this.isQuantum() ? this.original : this.quantumValue;
    }
}

