/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.Arrays;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.numbers.AnyNumber;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\bf\u0018\u0000 \u00122\u00020\u0001:\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher;", "", "matches", "", "number", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "asString", "", "getAsString", "()Ljava/lang/String;", "Exact", "LessThan", "LessThanOrEqual", "GreaterThan", "GreaterThanOrEqual", "Range", "Multiple", "Parser", "Companion", "shared"})
public interface NumberMatcher {
    @NotNull
    public static final Companion Companion = org.kingdoms.utils.internal.string.NumberMatcher$Companion.$$INSTANCE;

    public boolean matches(@NotNull AnyNumber var1);

    @NotNull
    public String getAsString();

    @JvmStatic
    @Nullable
    public static NumberMatcher parse(@Nullable String value) {
        return Companion.parse(value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Companion;", "", "<init>", "()V", "parse", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "value", "", "shared"})
    @SourceDebugExtension(value={"SMAP\nNumberMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberMatcher.kt\norg/kingdoms/utils/internal/string/NumberMatcher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final NumberMatcher parse(@Nullable String value) {
            CharSequence charSequence = value;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            String sanitized = StringsKt.replace$default((String)value, (String)" ", (String)"", (boolean)false, (int)4, null);
            AnyNumber anyNumber = AnyNumber.Companion.of(sanitized);
            if (anyNumber != null) {
                AnyNumber it = anyNumber;
                boolean bl = false;
                return new Exact(it);
            }
            return new Parser(sanitized).parse();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Exact;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "number", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "matches", "", "asString", "", "getAsString", "()Ljava/lang/String;", "shared"})
    public static final class Exact
    implements NumberMatcher {
        @NotNull
        private final AnyNumber number;

        public Exact(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            this.number = number;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return Intrinsics.areEqual((Object)this.number, (Object)number);
        }

        @Override
        @NotNull
        public String getAsString() {
            return "Exact:" + this.number;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$GreaterThan;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "greaterThan", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "matches", "", "number", "asString", "", "getAsString", "()Ljava/lang/String;", "toString", "shared"})
    public static final class GreaterThan
    implements NumberMatcher {
        @NotNull
        private final AnyNumber greaterThan;

        public GreaterThan(@NotNull AnyNumber greaterThan) {
            Intrinsics.checkNotNullParameter((Object)greaterThan, (String)"greaterThan");
            this.greaterThan = greaterThan;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return number.compareTo(this.greaterThan) < 0;
        }

        @Override
        @NotNull
        public String getAsString() {
            return "" + '<' + this.greaterThan.getValue();
        }

        @NotNull
        public String toString() {
            return "GreaterThan(" + this.greaterThan + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$GreaterThanOrEqual;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "greaterThan", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "matches", "", "number", "asString", "", "getAsString", "()Ljava/lang/String;", "shared"})
    public static final class GreaterThanOrEqual
    implements NumberMatcher {
        @NotNull
        private final AnyNumber greaterThan;

        public GreaterThanOrEqual(@NotNull AnyNumber greaterThan) {
            Intrinsics.checkNotNullParameter((Object)greaterThan, (String)"greaterThan");
            this.greaterThan = greaterThan;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return number.compareTo(this.greaterThan) <= 0;
        }

        @Override
        @NotNull
        public String getAsString() {
            return "<=" + this.greaterThan.getValue();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$LessThan;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "lessThan", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "matches", "", "number", "asString", "", "getAsString", "()Ljava/lang/String;", "shared"})
    public static final class LessThan
    implements NumberMatcher {
        @NotNull
        private final AnyNumber lessThan;

        public LessThan(@NotNull AnyNumber lessThan) {
            Intrinsics.checkNotNullParameter((Object)lessThan, (String)"lessThan");
            this.lessThan = lessThan;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return number.compareTo(this.lessThan) > 0;
        }

        @Override
        @NotNull
        public String getAsString() {
            return "" + '>' + this.lessThan.getValue();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$LessThanOrEqual;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "lessThan", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "(Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "matches", "", "number", "asString", "", "getAsString", "()Ljava/lang/String;", "shared"})
    public static final class LessThanOrEqual
    implements NumberMatcher {
        @NotNull
        private final AnyNumber lessThan;

        public LessThanOrEqual(@NotNull AnyNumber lessThan) {
            Intrinsics.checkNotNullParameter((Object)lessThan, (String)"lessThan");
            this.lessThan = lessThan;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return number.compareTo(this.lessThan) >= 0;
        }

        @Override
        @NotNull
        public String getAsString() {
            return ">=" + this.lessThan.getValue();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Multiple;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "list", "", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "<init>", "([Lorg/kingdoms/utils/internal/numbers/AnyNumber;)V", "[Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "matches", "", "number", "asString", "", "getAsString", "()Ljava/lang/String;", "toString", "shared"})
    public static final class Multiple
    implements NumberMatcher {
        @NotNull
        private final AnyNumber[] list;

        public Multiple(@NotNull AnyNumber[] list) {
            Intrinsics.checkNotNullParameter((Object)list, (String)"list");
            this.list = list;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            for (AnyNumber num : this.list) {
                if (!Intrinsics.areEqual((Object)number, (Object)num)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public String getAsString() {
            return '[' + ArraysKt.joinToString$default((Object[])this.list, (CharSequence)", ", null, null, (int)0, null, Multiple::_get_asString_$lambda$0, (int)30, null) + ']';
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder().append("NumberMatcher::Multiple(");
            String string = Arrays.toString(this.list);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return stringBuilder.append(string).append(')').toString();
        }

        private static final CharSequence _get_asString_$lambda$0(AnyNumber it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getValue().toString();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0002J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010 J\n\u0010!\u001a\u0004\u0018\u00010\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Parser;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "chars", "", "getChars", "()[C", "len", "", "getLen", "()I", "i", "getI", "setI", "(I)V", "parse", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "symbolToMatcher", "symbol", "num", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "numSide", "Lorg/kingdoms/utils/internal/string/NumberMatcher$Parser$Side;", "checkSymbol", "symbolOrNull", "", "char", "(C)Ljava/lang/Character;", "checkNumber", "Side", "shared"})
    private static final class Parser {
        @NotNull
        private final String value;
        @NotNull
        private final char[] chars;
        private final int len;
        private int i;

        public Parser(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            char[] cArray = this.value.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            this.chars = cArray;
            this.len = this.chars.length;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final char[] getChars() {
            return this.chars;
        }

        public final int getLen() {
            return this.len;
        }

        public final int getI() {
            return this.i;
        }

        public final void setI(int n) {
            this.i = n;
        }

        @NotNull
        public final NumberMatcher parse() {
            String symbol = this.checkSymbol();
            if (symbol != null) {
                AnyNumber anyNumber = this.checkNumber();
                if (anyNumber == null) {
                    throw new IllegalArgumentException("Expected a number after comparison symbol in " + this.value);
                }
                AnyNumber num = anyNumber;
                return this.symbolToMatcher(symbol, num, Side.RIGHT_HAND);
            }
            AnyNumber number = this.checkNumber();
            if (number != null) {
                if (this.chars[this.i] == ',') {
                    char[] cArray = new char[]{','};
                    A[] AArray = StringsKt.split$default((CharSequence)this.value, (char[])cArray, (boolean)false, (int)0, (int)6, null).stream().map(arg_0 -> Parser.parse$lambda$1(Parser::parse$lambda$0, arg_0)).toArray(Parser::parse$lambda$2);
                    Intrinsics.checkNotNullExpressionValue(AArray, (String)"toArray(...)");
                    return new Multiple((AnyNumber[])AArray);
                }
                String firstSym = this.checkSymbol();
                if (firstSym == null) {
                    throw new IllegalArgumentException("Cant find first symbol for ternary number comparison in " + this.value);
                }
                if (this.i >= this.len) {
                    return this.symbolToMatcher(firstSym, number, Side.LEFT_HAND);
                }
                int n = this.i;
                this.i = n + 1;
                char x = this.chars[n];
                if (x != 'x') {
                    throw new IllegalArgumentException("Variable 'x' is not used (instead '" + x + "') for ternary number comparison in " + this.value);
                }
                String secSym = this.checkSymbol();
                if (secSym == null) {
                    throw new IllegalArgumentException("Cant find second symbol for ternary number comparison in " + this.value);
                }
                AnyNumber secNum = this.checkNumber();
                if (secNum == null) {
                    throw new IllegalArgumentException("Cant find end number for ternary number comparison in " + this.value);
                }
                return new Range(this.symbolToMatcher(firstSym, number, Side.LEFT_HAND), this.symbolToMatcher(secSym, secNum, Side.RIGHT_HAND));
            }
            throw new IllegalArgumentException("Invalid number matcher format: " + this.value);
        }

        private final NumberMatcher symbolToMatcher(String symbol, AnyNumber num, Side numSide) {
            NumberMatcher numberMatcher;
            block6 : switch (symbol) {
                case ">": {
                    switch (WhenMappings.$EnumSwitchMapping$0[numSide.ordinal()]) {
                        case 1: {
                            numberMatcher = new LessThan(num);
                            break block6;
                        }
                        case 2: {
                            numberMatcher = new GreaterThan(num);
                            break block6;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case ">=": {
                    switch (WhenMappings.$EnumSwitchMapping$0[numSide.ordinal()]) {
                        case 1: {
                            numberMatcher = new LessThanOrEqual(num);
                            break block6;
                        }
                        case 2: {
                            numberMatcher = new GreaterThanOrEqual(num);
                            break block6;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case "<": {
                    switch (WhenMappings.$EnumSwitchMapping$0[numSide.ordinal()]) {
                        case 1: {
                            numberMatcher = new GreaterThan(num);
                            break block6;
                        }
                        case 2: {
                            numberMatcher = new LessThan(num);
                            break block6;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case "<=": {
                    switch (WhenMappings.$EnumSwitchMapping$0[numSide.ordinal()]) {
                        case 1: {
                            numberMatcher = new GreaterThanOrEqual(num);
                            break block6;
                        }
                        case 2: {
                            numberMatcher = new LessThanOrEqual(num);
                            break block6;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new IllegalArgumentException("Unknown number comparison symbol '" + symbol + "' in " + this.value);
                }
            }
            return numberMatcher;
        }

        private final String checkSymbol() {
            if (this.i >= this.len) {
                throw new IllegalArgumentException("Expected a number comparison symbol at " + this.i + " but reached the end in " + this.value);
            }
            char firstChar = this.chars[this.i];
            Character firstSym = this.symbolOrNull(firstChar);
            if (firstSym == null) {
                return null;
            }
            if (this.i + 1 < this.len) {
                char secChar = this.chars[this.i + 1];
                Character secSym = this.symbolOrNull(secChar);
                if (secSym == null) {
                    int n = this.i;
                    this.i = n + 1;
                    return firstSym.toString();
                }
                this.i += 2;
                return "" + firstSym + secSym;
            }
            int n = this.i;
            this.i = n + 1;
            return firstSym.toString();
        }

        private final Character symbolOrNull(char c) {
            Character c2;
            switch (c) {
                case '<': 
                case '=': 
                case '>': {
                    c2 = Character.valueOf(c);
                    break;
                }
                default: {
                    c2 = null;
                }
            }
            return c2;
        }

        private final AnyNumber checkNumber() {
            char c = '\u0000';
            StringBuilder number = new StringBuilder(10);
            int i = this.i;
            boolean sawSign = false;
            boolean sawDecimal = false;
            while (i < this.len) {
                StringBuilder stringBuilder;
                char c2;
                if ((c2 = (c = this.chars[i++])) == '-') {
                    if (sawSign) {
                        return null;
                    }
                    sawSign = true;
                    stringBuilder = number.append(c);
                    continue;
                }
                if (c2 == '.') {
                    if (sawDecimal) {
                        return null;
                    }
                    sawDecimal = true;
                    stringBuilder = number.append(c);
                    continue;
                }
                boolean bl = '0' <= c2 ? c2 < ':' : false;
                if (bl) {
                    stringBuilder = number.append(c);
                    continue;
                }
                if (((CharSequence)number).length() == 0) {
                    return null;
                }
                this.i = --i;
                String string = number.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return AnyNumber.Companion.of(string);
            }
            if (((CharSequence)number).length() == 0) {
                return null;
            }
            this.i = i;
            String string = number.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return AnyNumber.Companion.of(string);
        }

        private static final AnyNumber parse$lambda$0(String it) {
            Intrinsics.checkNotNull((Object)it);
            AnyNumber anyNumber = AnyNumber.Companion.of(it);
            Intrinsics.checkNotNull((Object)anyNumber);
            return anyNumber;
        }

        private static final AnyNumber parse$lambda$1(Function1 $tmp0, Object p0) {
            return (AnyNumber)$tmp0.invoke(p0);
        }

        private static final AnyNumber[] parse$lambda$2(int len) {
            return new AnyNumber[len];
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Parser$Side;", "", "<init>", "(Ljava/lang/String;I)V", "RIGHT_HAND", "LEFT_HAND", "shared"})
        private static final class Side
        extends Enum<Side> {
            public static final /* enum */ Side RIGHT_HAND = new Side();
            public static final /* enum */ Side LEFT_HAND = new Side();
            private static final /* synthetic */ Side[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Side[] values() {
                return (Side[])$VALUES.clone();
            }

            public static Side valueOf(String value) {
                return Enum.valueOf(Side.class, value);
            }

            @NotNull
            public static EnumEntries<Side> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sideArray = new Side[]{Side.RIGHT_HAND, Side.LEFT_HAND};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Side.values().length];
                try {
                    nArray[Side.RIGHT_HAND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Side.LEFT_HAND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/internal/string/NumberMatcher$Range;", "Lorg/kingdoms/utils/internal/string/NumberMatcher;", "first", "second", "<init>", "(Lorg/kingdoms/utils/internal/string/NumberMatcher;Lorg/kingdoms/utils/internal/string/NumberMatcher;)V", "matches", "", "number", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "asString", "", "getAsString", "()Ljava/lang/String;", "toString", "shared"})
    public static final class Range
    implements NumberMatcher {
        @NotNull
        private final NumberMatcher first;
        @NotNull
        private final NumberMatcher second;

        public Range(@NotNull NumberMatcher first, @NotNull NumberMatcher second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean matches(@NotNull AnyNumber number) {
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            return this.first.matches(number) && this.second.matches(number);
        }

        @Override
        @NotNull
        public String getAsString() {
            return "" + '(' + this.first + " && " + this.second + ')';
        }

        @NotNull
        public String toString() {
            return "NumberMatcher::Range(" + this.first + " && " + this.second + ')';
        }
    }
}

