/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.string;

import java.util.Arrays;
import java.util.StringJoiner;

public final class CommaDataSplitStrategy {
    private final String data;
    private final int len;
    private int index;
    private final int expectedComponentCount;
    private final String[] components;

    public CommaDataSplitStrategy(String data, int expectedComponentCount) {
        if (data == null || data.isEmpty()) {
            throw new IllegalArgumentException("Data cannot be null or empty: " + data);
        }
        if (expectedComponentCount < 1) {
            throw new IllegalArgumentException("expectedComponentCount must be greater than zero: " + expectedComponentCount);
        }
        this.expectedComponentCount = expectedComponentCount;
        this.components = new String[expectedComponentCount];
        this.data = data;
        this.len = data.length();
        this.parseAllComponenets();
    }

    public void missing() {
        throw new IllegalStateException("Components missing. Expected " + this.expectedComponentCount + ": " + this.data);
    }

    private void parseAllComponenets() {
        int i = 0;
        int start = 0;
        for (int j = 0; j < this.expectedComponentCount; ++j) {
            String component = null;
            if (i >= this.len) {
                this.missing();
            }
            while (i < this.len) {
                if (this.data.charAt(i) == ',') {
                    component = this.data.substring(start, i);
                    start = i += 2;
                    break;
                }
                ++i;
            }
            if (component == null) {
                component = this.data.substring(start, this.len);
            }
            if (component == null || component.isEmpty()) {
                this.missing();
            }
            this.components[j] = component;
        }
        if (i < this.len) {
            throw new IllegalStateException("Only expected " + this.expectedComponentCount + " componenets but got more: " + this.data);
        }
    }

    public String nextString() {
        int nextIndex;
        if ((nextIndex = this.index++) >= this.components.length) {
            throw new IllegalStateException("Only expected " + this.expectedComponentCount + " componenets but requested more: " + this.data);
        }
        return this.components[nextIndex];
    }

    private RuntimeException numberError(String str) {
        return new IllegalStateException("Expected an integer for " + this.index + " but got '" + str + "' in: " + this.data);
    }

    public int nextInt() {
        String str = this.nextString();
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw this.numberError(str);
        }
    }

    public double nextDouble() {
        String str = this.nextString();
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw this.numberError(str);
        }
    }

    public float nextFloat() {
        String str = this.nextString();
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException ex) {
            throw this.numberError(str);
        }
    }

    public static String toString(Object ... components) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Object component : components) {
            String str = component.toString();
            if (str == null || str.isEmpty()) {
                throw new IllegalArgumentException("Data component is null or empty '" + str + "' in: " + Arrays.toString(components));
            }
            joiner.add(str);
        }
        return joiner.toString();
    }
}

