/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.stacktrace;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.utils.cache.caffeine.CacheHandler;

public final class StackTraces {
    private static final Cache<Thread, ThreadInfo> TRACED_THREADS = CacheHandler.newBuilder().weakKeys().build();
    private static final boolean THREAD_LINKING_ENABLED = false;

    private StackTraces() {
    }

    public static String stacktrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Exception().printStackTrace(pw);
        return sw.toString();
    }

    public static void linkThreads(Thread parent, Thread child) {
        try {
            StackTraces.linkThreads0(parent, child);
        }
        catch (Throwable ex) {
            new Exception("Error while attempting to link parent thread " + parent + " to child " + child, ex).printStackTrace();
        }
    }

    private static void linkThreads0(Thread parent, Thread child) {
    }

    private static boolean isCircular(Thread parent, Thread child) {
        ThreadInfo currentThread;
        HashSet<Thread> parents = null;
        Thread current = parent;
        while ((currentThread = (ThreadInfo)TRACED_THREADS.getIfPresent((Object)current)) != null) {
            if (parents == null) {
                parents = new HashSet<Thread>(10);
                parents.add(child);
                parents.add(parent);
            }
            if (parents.add(current = currentThread.parent)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement createInfoElement(String message) {
        return new StackTraceElement(message, "", null, 0);
    }

    public static <T extends Throwable> T absoluteStackTrace(T exception) {
        return exception;
    }

    public static List<Throwable> getCausationChain(Throwable ex) {
        ArrayList<Throwable> causes = new ArrayList<Throwable>(5);
        Set circularCause = Collections.newSetFromMap(new IdentityHashMap(5));
        Throwable cause = ex;
        while (cause != null && !circularCause.contains(cause)) {
            causes.add(ex);
            cause = ex.getCause();
            circularCause.add(cause);
        }
        return causes;
    }

    public static void printStackTrace() {
        StackTraces.printStackTrace("", new Throwable().getStackTrace(), null, 1);
    }

    public static void printStackTrace(Throwable exception) {
        exception.printStackTrace();
    }

    public static void printStackTrace(String header) {
        StackTraces.printStackTrace("  ", new Throwable().getStackTrace(), header, 1);
    }

    public static void printStackTrace(String prefix, StackTraceElement[] stackTraceElements, String header, int skip) {
        MessageHandler.sendConsolePluginMessage("&f--------------------------------------------");
        if (header != null) {
            MessageHandler.sendConsolePluginMessage(header);
        }
        Arrays.stream(stackTraceElements).skip(skip).forEach(stack -> {
            String clazz = stack.getClassName();
            String color = clazz.startsWith("net.minecraft") ? "&6" : (clazz.startsWith("org.bukkit") ? "&d" : (clazz.startsWith("co.aikar") || clazz.startsWith("io.papermc") || clazz.startsWith("com.destroystokyo") ? "&d" : (clazz.startsWith("java") ? "&c" : "&2")));
            MessageHandler.sendConsolePluginMessage(prefix + color + stack.getClassName() + "&8.&9" + stack.getMethodName() + "&8: &5" + stack.getLineNumber());
        });
        MessageHandler.sendConsolePluginMessage("&f--------------------------------------------");
    }

    public static boolean isCalledFromClass(Class<?> clazz) {
        String name = clazz.getSimpleName().concat(".java");
        return Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).anyMatch(stack -> name.equalsIgnoreCase(stack.getFileName()));
    }

    private static /* synthetic */ StackTraceElement[] lambda$absoluteStackTrace$1(int x$0) {
        return new StackTraceElement[x$0];
    }

    private static /* synthetic */ ThreadInfo lambda$linkThreads0$0(StackTraceElement[] stackTrace, Thread parent, Thread k) {
        return new ThreadInfo(stackTrace, parent);
    }

    private static final class ThreadInfo {
        private final StackTraceElement[] creationStackTrace;
        private final Thread parent;

        private ThreadInfo(StackTraceElement[] creationStackTrace, Thread parent) {
            this.creationStackTrace = creationStackTrace;
            this.parent = parent;
        }

        static /* synthetic */ StackTraceElement[] access$100(ThreadInfo x0) {
            return x0.creationStackTrace;
        }
    }
}

