/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.reflection;

import java.util.Objects;
import java.util.function.Function;

public final class ClassHierarchyWalker<V> {
    private final Class<?> base;
    private final Function<Class<?>, V> find;

    private ClassHierarchyWalker(Class<?> base, Function<Class<?>, V> find) {
        this.base = Objects.requireNonNull(base);
        this.find = Objects.requireNonNull(find);
        if (base == Class.class) {
            throw new IllegalArgumentException("Recursive class parameter: " + base);
        }
    }

    private V check(Class<?> check) {
        V any;
        if (check == Object.class) {
            return null;
        }
        V found = this.find.apply(check);
        if (found != null) {
            return found;
        }
        Class<?> superClass = check.getSuperclass();
        if (superClass != null && (any = this.check(superClass)) != null) {
            return any;
        }
        for (Class<?> interfacee : check.getInterfaces()) {
            V any2 = this.check(interfacee);
            if (any2 == null) continue;
            return any2;
        }
        return null;
    }

    public V find() {
        return this.check(this.base);
    }

    public static <V> V walk(Class<?> base, Function<Class<?>, V> find) {
        return new ClassHierarchyWalker<V>(base, find).find();
    }
}

