/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.numbers;

import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Numbers {
    private static final DecimalFormat CURRENCY_FORMAT = new DecimalFormat("#,###.##", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat CURRENCY_DEC_3_FORMAT = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat CURRENCY_DEC_4_FORMAT = new DecimalFormat("0.####", new DecimalFormatSymbols(Locale.ENGLISH));
    private static final DecimalFormat SCIENTIFIC_FORMAT = new DecimalFormat("00E0", new DecimalFormatSymbols(Locale.ENGLISH));

    private Numbers() {
    }

    public static boolean isEnglishDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static String toOrdinalNumeral(int num) {
        if (num <= 0) {
            throw new IllegalArgumentException("Ordinal numerals must start from 1");
        }
        String str = Integer.toString(num);
        char lastDigit = str.charAt(str.length() - 1);
        if (lastDigit == '1') {
            return str + "st";
        }
        if (lastDigit == '2') {
            return str + "nd";
        }
        if (lastDigit == '3') {
            return str + "rd";
        }
        return str + "th";
    }

    public static boolean containsNumber(@Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!Numbers.isEnglishDigit(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAnyLangNumber(@Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (!Character.isDigit(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(@Nullable String str) {
        char first;
        if (str == null) {
            return false;
        }
        int len = str.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        if (len != 1 && ((first = str.charAt(0)) == '-' || first == '+')) {
            i = 1;
        }
        while (i < len) {
            if (Numbers.isEnglishDigit(str.charAt(i++))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPureNumber(@Nullable String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Numbers.isEnglishDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static int getPositionOfFirstNonZeroDecimal(double number) {
        if (number >= 1.0) {
            throw new IllegalArgumentException("Number is greater than 1.0");
        }
        return (int)Math.abs(Math.floor(Math.log10(Math.abs(number))));
    }

    @Nonnull
    public static String toFancyNumber(double number) {
        boolean positive;
        if (number == 0.0) {
            return "0";
        }
        boolean bl = positive = number >= 0.0;
        DecimalFormat format = (positive ? number >= 0.01 : number <= -0.01) ? CURRENCY_FORMAT : ((positive ? number >= 0.001 : number <= -0.001) ? CURRENCY_DEC_3_FORMAT : ((positive ? number >= 1.0E-4 : number <= -1.0E-4) ? CURRENCY_DEC_4_FORMAT : SCIENTIFIC_FORMAT));
        return format.format(number);
    }
}

