/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.numbers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.numbers.NumberDecorator;
import org.kingdoms.utils.internal.numbers.NumberFailReason;
import org.kingdoms.utils.internal.numbers.NumberType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u0019\u001a\u00020\u00002\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u001a\"\u00020\u000f\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\u001f\u0010\u001d\u001a\u00020\u00002\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001a\"\u00020\u0011\u00a2\u0006\u0002\u0010\u001eJ\u0006\u0010\u001f\u001a\u00020\nJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\nH\u0002J\u0006\u0010%\u001a\u00020#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010 \u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lorg/kingdoms/utils/internal/numbers/NumberProcessor;", "", "string", "", "<init>", "(Ljava/lang/String;)V", "getString", "()Ljava/lang/String;", "failedConstraints", "", "Lorg/kingdoms/utils/internal/numbers/NumberFailReason;", "getFailedConstraints", "()Ljava/util/Set;", "constraints", "", "Lorg/kingdoms/utils/internal/numbers/NumberConstraint;", "decorators", "Lorg/kingdoms/utils/internal/numbers/NumberDecorator;", "_number", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "processed", "", "number", "getNumber", "()Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "withConstraints", "", "([Lorg/kingdoms/utils/internal/numbers/NumberConstraint;)Lorg/kingdoms/utils/internal/numbers/NumberProcessor;", "withAllDecorators", "withDecorators", "([Lorg/kingdoms/utils/internal/numbers/NumberDecorator;)Lorg/kingdoms/utils/internal/numbers/NumberProcessor;", "getMostImportantFailure", "isSuccessful", "()Z", "fail", "", "reason", "process", "Companion", "shared"})
@SourceDebugExtension(value={"SMAP\nNumberProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberProcessor.kt\norg/kingdoms/utils/internal/numbers/NumberProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n2341#3,14:98\n*S KotlinDebug\n*F\n+ 1 NumberProcessor.kt\norg/kingdoms/utils/internal/numbers/NumberProcessor\n*L\n38#1:98,14\n*E\n"})
public final class NumberProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String string;
    @NotNull
    private final Set<NumberFailReason> failedConstraints;
    @NotNull
    private Set<? extends NumberConstraint> constraints;
    @NotNull
    private Set<? extends NumberDecorator> decorators;
    @Nullable
    private AnyNumber _number;
    private boolean processed;
    @NotNull
    private static final Set<NumberDecorator> ALL_DECORATORS = ArraysKt.toSet((Object[])NumberDecorator.values());

    public NumberProcessor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.string = string;
        this.failedConstraints = new HashSet();
        this.constraints = new HashSet();
        this.decorators = new HashSet();
    }

    @NotNull
    public final String getString() {
        return this.string;
    }

    @NotNull
    public final Set<NumberFailReason> getFailedConstraints() {
        return this.failedConstraints;
    }

    @Nullable
    public final AnyNumber getNumber() {
        return this._number;
    }

    @NotNull
    public final NumberProcessor withConstraints(NumberConstraint ... constraints) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.constraints = ArraysKt.toSet((Object[])constraints);
        return this;
    }

    @NotNull
    public final NumberProcessor withAllDecorators() {
        this.decorators = ALL_DECORATORS;
        return this;
    }

    @NotNull
    public final NumberProcessor withDecorators(NumberDecorator ... decorators) {
        Intrinsics.checkNotNullParameter((Object)decorators, (String)"decorators");
        this.decorators = ArraysKt.toSet((Object[])decorators);
        return this;
    }

    @NotNull
    public final NumberFailReason getMostImportantFailure() {
        Object v0;
        if (!(!((Collection)this.failedConstraints).isEmpty())) {
            boolean $i$a$-require-NumberProcessor$getMostImportantFailure$22 = false;
            String $i$a$-require-NumberProcessor$getMostImportantFailure$22 = "Number processor did not fail";
            throw new IllegalArgumentException($i$a$-require-NumberProcessor$getMostImportantFailure$22.toString());
        }
        Iterable $this$minByOrNull$iv = this.failedConstraints;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                NumberFailReason it = (NumberFailReason)((Object)minElem$iv);
                boolean bl = false;
                int minValue$iv = it.ordinal();
                do {
                    Object e$iv = iterator$iv.next();
                    NumberFailReason it2 = (NumberFailReason)((Object)e$iv);
                    $i$a$-minByOrNull-NumberProcessor$getMostImportantFailure$2 = false;
                    int v$iv = it2.ordinal();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    public final boolean isSuccessful() {
        if (!this.processed) {
            boolean bl = false;
            String string = this.string + " is not processed yet";
            throw new IllegalArgumentException(string.toString());
        }
        return this.failedConstraints.isEmpty();
    }

    private final void fail(NumberFailReason reason) {
        this.failedConstraints.add(reason);
    }

    public final void process() {
        AnyNumber _number;
        if (!(!this.processed)) {
            boolean $i$a$-require-NumberProcessor$process$22 = false;
            String $i$a$-require-NumberProcessor$process$22 = this.string + " is already processed";
            throw new IllegalArgumentException($i$a$-require-NumberProcessor$process$22.toString());
        }
        this.processed = true;
        Integer mod = null;
        String it = this.string;
        boolean bl = false;
        String str = it;
        if (this.decorators.contains((Object)NumberDecorator.SUFFIX)) {
            String string;
            if (StringsKt.endsWith((CharSequence)str, (char)'K', (boolean)true)) {
                mod = 1000;
                String string2 = str.substring(0, str.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = str = str;
            }
        }
        if (this.decorators.contains((Object)NumberDecorator.COMMA)) {
            str = StringsKt.replace$default((String)str, (String)",", (String)"", (boolean)false, (int)4, null);
        }
        it = str;
        boolean bl2 = false;
        AnyNumber anyNumber = NumberType.INT.parseString(it);
        if (anyNumber == null) {
            anyNumber = NumberType.DOUBLE.parseString(it);
        }
        if ((_number = anyNumber) == null) {
            this.fail(NumberFailReason.NOT_A_NUMBER);
            return;
        }
        this._number = mod == null ? _number : _number.times(AnyNumber.Companion.getAbstractNumber(((Number)mod).intValue()));
        if (_number.getType() != NumberType.INT && this.constraints.contains((Object)NumberConstraint.INTEGER_ONLY)) {
            this.fail(NumberFailReason.INTEGER_ONLY);
        }
        if (_number.compareTo(AnyNumber.Companion.getAbstractNumber(_number.getType().getMinValue())) <= 0 || _number.compareTo(AnyNumber.Companion.getAbstractNumber(_number.getType().getMaxValue())) >= 0) {
            this.fail(NumberFailReason.OUT_OF_BOUNDS);
        }
        if (this.constraints.contains((Object)NumberConstraint.POSITIVE) && _number.compareTo(AnyNumber.Companion.of(0)) <= 0) {
            this.fail(NumberFailReason.POSITIVE);
        }
        if (this.constraints.contains((Object)NumberConstraint.ZERO_OR_POSITIVE) && _number.compareTo(AnyNumber.Companion.of(0)) < 0) {
            this.fail(NumberFailReason.ZERO_OR_POSITIVE);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/internal/numbers/NumberProcessor$Companion;", "", "<init>", "()V", "ALL_DECORATORS", "", "Lorg/kingdoms/utils/internal/numbers/NumberDecorator;", "getALL_DECORATORS$annotations", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getALL_DECORATORS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

