/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.numbers;

import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.numbers.NumberType;
import org.kingdoms.utils.internal.numbers._Double;
import org.kingdoms.utils.internal.numbers._Float;
import org.kingdoms.utils.internal.numbers._Int;
import org.kingdoms.utils.internal.numbers._Long;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\bf\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u001eJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\t\u0010\u0014\u001a\u00020\u0000H\u00a6\u0002J\t\u0010\u0015\u001a\u00020\u0000H\u00a6\u0002J\t\u0010\u0016\u001a\u00020\u0000H\u00a6\u0002J\t\u0010\u0017\u001a\u00020\u0000H\u00a6\u0002J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u00a6\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u00a6\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u00a6\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u00a6\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000H\u00a6\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001f\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "", "Lorg/kingdoms/constants/DataStringRepresentation;", "value", "", "getValue", "()Ljava/lang/Number;", "type", "Lorg/kingdoms/utils/internal/numbers/NumberType;", "getType", "()Lorg/kingdoms/utils/internal/numbers/NumberType;", "constructNew", "isNegative", "", "()Z", "isPositive", "isZero", "isEven", "isOdd", "abs", "unaryMinus", "unaryPlus", "inc", "dec", "plus", "other", "minus", "times", "div", "rem", "Companion", "shared"})
public interface AnyNumber
extends Comparable<AnyNumber>,
DataStringRepresentation {
    @NotNull
    public static final Companion Companion = org.kingdoms.utils.internal.numbers.AnyNumber$Companion.$$INSTANCE;

    @NotNull
    public Number getValue();

    @NotNull
    public NumberType getType();

    @NotNull
    public AnyNumber constructNew(@NotNull Number var1);

    public boolean isNegative();

    public boolean isPositive();

    public boolean isZero();

    default public boolean isEven() {
        return Intrinsics.areEqual((Object)this.rem(org.kingdoms.utils.internal.numbers.AnyNumber$Companion.TWO), (Object)org.kingdoms.utils.internal.numbers.AnyNumber$Companion.ZERO);
    }

    default public boolean isOdd() {
        return !this.isEven();
    }

    @NotNull
    default public AnyNumber abs() {
        return this.compareTo(org.kingdoms.utils.internal.numbers.AnyNumber$Companion.ZERO) < 0 ? this.unaryMinus() : this;
    }

    @NotNull
    public AnyNumber unaryMinus();

    @NotNull
    public AnyNumber unaryPlus();

    @NotNull
    public AnyNumber inc();

    @NotNull
    public AnyNumber dec();

    @NotNull
    public AnyNumber plus(@NotNull AnyNumber var1);

    @NotNull
    public AnyNumber minus(@NotNull AnyNumber var1);

    @NotNull
    public AnyNumber times(@NotNull AnyNumber var1);

    @NotNull
    public AnyNumber div(@NotNull AnyNumber var1);

    @NotNull
    public AnyNumber rem(@NotNull AnyNumber var1);

    public static /* synthetic */ AnyNumber getAbstractNumber(Number $this$getAbstractNumber) {
        return Companion.getAbstractNumber($this$getAbstractNumber);
    }

    public static /* synthetic */ AnyNumber getAbstractNumber(float $this$getAbstractNumber) {
        return Companion.getAbstractNumber($this$getAbstractNumber);
    }

    public static /* synthetic */ AnyNumber getAbstractNumber(int $this$getAbstractNumber) {
        return Companion.getAbstractNumber($this$getAbstractNumber);
    }

    public static /* synthetic */ AnyNumber getAbstractNumber(double $this$getAbstractNumber) {
        return Companion.getAbstractNumber($this$getAbstractNumber);
    }

    @JvmStatic
    @NotNull
    public static AnyNumber of(@NotNull Number number) {
        return Companion.of(number);
    }

    @JvmStatic
    @NotNull
    public static AnyNumber of(long l) {
        return Companion.of(l);
    }

    @JvmStatic
    @NotNull
    public static AnyNumber of(float f) {
        return Companion.of(f);
    }

    @JvmStatic
    @NotNull
    public static AnyNumber of(int n) {
        return Companion.of(n);
    }

    @JvmStatic
    @NotNull
    public static AnyNumber of(double d) {
        return Companion.of(d);
    }

    @JvmStatic
    @Nullable
    public static AnyNumber of(@NotNull String string) {
        return Companion.of(string);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\bH\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\rH\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0010H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\u0005*\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0007\u001a\u00020\u0005*\u00020\r8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u000e\u001a\u0004\b\u000b\u0010\u000fR\u001e\u0010\u0007\u001a\u00020\u0005*\u00020\u00108FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0011\u001a\u0004\b\u000b\u0010\u0012R\u001e\u0010\u0007\u001a\u00020\u0005*\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0014\u001a\u0004\b\u000b\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/utils/internal/numbers/AnyNumber$Companion;", "", "<init>", "()V", "TWO", "Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "ZERO", "abstractNumber", "", "getAbstractNumber$annotations", "(Ljava/lang/Number;)V", "getAbstractNumber", "(Ljava/lang/Number;)Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "", "(F)V", "(F)Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "", "(I)V", "(I)Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "", "(D)V", "(D)Lorg/kingdoms/utils/internal/numbers/AnyNumber;", "of", "number", "float", "", "int", "double", "string", "", "shared"})
    @SourceDebugExtension(value={"SMAP\nAnyNumber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnyNumber.kt\norg/kingdoms/utils/internal/numbers/AnyNumber$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final AnyNumber TWO;
        @NotNull
        private static final AnyNumber ZERO;

        private Companion() {
        }

        public final /* synthetic */ AnyNumber getAbstractNumber(Number $this$abstractNumber) {
            Intrinsics.checkNotNullParameter((Object)$this$abstractNumber, (String)"<this>");
            return this.of($this$abstractNumber);
        }

        @JvmStatic
        public static /* synthetic */ void getAbstractNumber$annotations(Number number) {
        }

        public final /* synthetic */ AnyNumber getAbstractNumber(float $this$abstractNumber) {
            return new _Float($this$abstractNumber);
        }

        @JvmStatic
        public static /* synthetic */ void getAbstractNumber$annotations(float f) {
        }

        public final /* synthetic */ AnyNumber getAbstractNumber(int $this$abstractNumber) {
            return new _Int($this$abstractNumber);
        }

        @JvmStatic
        public static /* synthetic */ void getAbstractNumber$annotations(int n) {
        }

        public final /* synthetic */ AnyNumber getAbstractNumber(double $this$abstractNumber) {
            return new _Double($this$abstractNumber);
        }

        @JvmStatic
        public static /* synthetic */ void getAbstractNumber$annotations(double d) {
        }

        @JvmStatic
        @NotNull
        public final AnyNumber of(@NotNull Number number) {
            AnyNumber anyNumber;
            Intrinsics.checkNotNullParameter((Object)number, (String)"number");
            Number number2 = number;
            if (number2 instanceof Integer) {
                anyNumber = new _Int(number.intValue());
            } else if (number2 instanceof Float) {
                anyNumber = new _Float(number.floatValue());
            } else if (number2 instanceof Double) {
                anyNumber = new _Double(number.doubleValue());
            } else if (number2 instanceof Long) {
                anyNumber = new _Long(number.longValue());
            } else {
                throw new UnsupportedOperationException("Unsupported number format: " + number + " (" + number.getClass() + ')');
            }
            return anyNumber;
        }

        @JvmStatic
        @NotNull
        public final AnyNumber of(long l) {
            return new _Long(l);
        }

        @JvmStatic
        @NotNull
        public final AnyNumber of(float f) {
            return new _Float(f);
        }

        @JvmStatic
        @NotNull
        public final AnyNumber of(int n) {
            return new _Int(n);
        }

        @JvmStatic
        @NotNull
        public final AnyNumber of(double d) {
            return new _Double(d);
        }

        @JvmStatic
        @Nullable
        public final AnyNumber of(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (StringsKt.contains$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) {
                return NumberType.DOUBLE.parseString(string);
            }
            NumberType[] numberTypeArray = new NumberType[]{NumberType.INT, NumberType.LONG, NumberType.DOUBLE};
            for (NumberType type : numberTypeArray) {
                AnyNumber anyNumber = type.parseString(string);
                if (anyNumber == null) continue;
                AnyNumber it = anyNumber;
                boolean bl = false;
                return it;
            }
            return null;
        }

        static {
            $$INSTANCE = new Companion();
            TWO = $$INSTANCE.of(2);
            ZERO = $$INSTANCE.of(0);
        }
    }
}

