/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangedIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private final int limit;
    private int totalSkip;
    private Boolean cachedHasNext;
    private int skip;
    private int counted;

    public RangedIterator(Iterator<E> iterator, int skip, int limit) {
        this.iterator = iterator;
        this.skip(skip);
        if (limit < 0) {
            throw new IllegalArgumentException("Negative number for limit is not allowed, consider using Integer.MAX_VALUE instead for unlimited: " + limit);
        }
        this.limit = limit;
    }

    public static <T> Iterator<T> skipped(Iterator<T> iterator, int skip) {
        if (skip == 0) {
            return iterator;
        }
        return new RangedIterator<T>(iterator, skip, Integer.MAX_VALUE);
    }

    public void resetIndex() {
        this.counted = 0;
    }

    public RangedIterator<E> skip(int elements) {
        if (elements < 0) {
            throw new IllegalArgumentException("Cannot skip negative elements: " + elements);
        }
        this.totalSkip = this.skip += elements;
        return this;
    }

    private void skip() {
        while (this.iterator.hasNext() && this.skip > 0) {
            --this.skip;
            this.iterator.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cachedHasNext != null) {
            return this.cachedHasNext;
        }
        this.skip();
        this.cachedHasNext = this.counted < this.limit && this.iterator.hasNext();
        return this.cachedHasNext;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator already reached the end: " + this);
        }
        ++this.counted;
        this.cachedHasNext = null;
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SubIterator{iterator=" + this.iterator + ", skip=" + this.totalSkip + ", limit=" + this.limit + ", counted=" + this.counted + '}';
    }
}

