/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.IntRange;
import org.kingdoms.libs.kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\n\"\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u000bJ7\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\n\"\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u000f\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00112\u0006\u0010\u0012\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u0013J%\u0010\u0014\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00112\u0006\u0010\u0012\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0015\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00112\u0006\u0010\u0017\u001a\u0002H\u00062\u0006\u0010\u0018\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001a\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00112\u0006\u0010\u0012\u001a\u0002H\u00062\u0006\u0010\u001b\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/utils/internal/iterator/ListUtils;", "", "<init>", "()V", "plusAt", "", "T", "index", "", "elements", "", "(Ljava/util/List;I[Ljava/lang/Object;)Ljava/util/List;", "separatedBy", "separator", "(Ljava/util/List;[Ljava/lang/Object;)Ljava/util/List;", "moveOneElementCloserToStart", "", "", "element", "(Ljava/util/List;Ljava/lang/Object;)Z", "moveOneElementCloserToEnd", "replace", "", "old", "new", "(Ljava/util/List;Ljava/lang/Object;Ljava/lang/Object;)V", "moveElement", "relativeIndex", "(Ljava/util/List;Ljava/lang/Object;I)Z", "shared"})
public final class ListUtils {
    @NotNull
    public static final ListUtils INSTANCE = new ListUtils();

    private ListUtils() {
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> plusAt(@NotNull List<? extends T> $this$plusAt, int index, T ... elements) {
        Intrinsics.checkNotNullParameter($this$plusAt, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArrayList result = new ArrayList();
        result.addAll(CollectionsKt.slice($this$plusAt, (IntRange)new IntRange(0, index)));
        CollectionsKt.addAll((Collection)result, (Object[])elements);
        result.addAll(CollectionsKt.slice($this$plusAt, (IntRange)RangesKt.until((int)index, (int)$this$plusAt.size())));
        return result;
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> separatedBy(@NotNull List<? extends T> $this$separatedBy, T ... separator) {
        Intrinsics.checkNotNullParameter($this$separatedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter(separator, (String)"separator");
        ArrayList<T> result = new ArrayList<T>($this$separatedBy.size() * 2);
        for (T element : $this$separatedBy) {
            if (!((Collection)result).isEmpty()) {
                CollectionsKt.addAll((Collection)result, (Object[])separator);
            }
            result.add(element);
        }
        return result;
    }

    @JvmStatic
    public static final <T> boolean moveOneElementCloserToStart(@NotNull List<T> $this$moveOneElementCloserToStart, T element) {
        Intrinsics.checkNotNullParameter($this$moveOneElementCloserToStart, (String)"<this>");
        return ListUtils.moveElement($this$moveOneElementCloserToStart, element, -1);
    }

    @JvmStatic
    public static final <T> boolean moveOneElementCloserToEnd(@NotNull List<T> $this$moveOneElementCloserToEnd, T element) {
        Intrinsics.checkNotNullParameter($this$moveOneElementCloserToEnd, (String)"<this>");
        return ListUtils.moveElement($this$moveOneElementCloserToEnd, element, 1);
    }

    @JvmStatic
    public static final <T> void replace(@NotNull List<T> $this$replace, T old, T t) {
        Intrinsics.checkNotNullParameter($this$replace, (String)"<this>");
        int elementIndex = $this$replace.indexOf(old);
        if (elementIndex == -1) {
            throw new IllegalArgumentException(old + " is not in " + $this$replace);
        }
        $this$replace.set(elementIndex, t);
    }

    @JvmStatic
    public static final <T> boolean moveElement(@NotNull List<T> $this$moveElement, T element, int relativeIndex) {
        Intrinsics.checkNotNullParameter($this$moveElement, (String)"<this>");
        int elementIndex = $this$moveElement.indexOf(element);
        if (elementIndex == -1) {
            throw new IllegalArgumentException(element + " is not in " + $this$moveElement);
        }
        int targetIndex = elementIndex + relativeIndex;
        if (targetIndex < 0 || targetIndex >= $this$moveElement.size()) {
            return false;
        }
        T replacingElement = $this$moveElement.get(targetIndex);
        $this$moveElement.set(targetIndex, element);
        $this$moveElement.set(elementIndex, replacingElement);
        return true;
    }
}

