/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.functional;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;

public final class Fn {
    public static final Runnable EMPTY_RUNNABLE = () -> {};
    private static final Predicate<?> TRUE_PREDICATE = x -> true;
    private static final Predicate<?> FALSE_PREDICATE = x -> false;
    private static final Supplier<?> NULL_SUPPLIER = new ConstantSupplier(null);

    public static <T> Supplier<T> supply(Supplier<T> supplier) {
        return supplier;
    }

    public static <T> Supplier<T> supply(T constant) {
        return new ConstantSupplier(constant);
    }

    public static <T> Callable<T> call(Callable<T> callable) {
        return callable;
    }

    public static <T> Predicate<T> predicate(Predicate<T> predicate) {
        return predicate;
    }

    public static <T> Consumer<T> consume(Consumer<T> consumer) {
        return consumer;
    }

    public static Runnable run(Runnable runnable) {
        return runnable;
    }

    public static <T, R> Function<T, R> function(Function<T, R> function) {
        return function;
    }

    public static <T, U, R> BiFunction<T, U, R> function(BiFunction<T, U, R> function) {
        return function;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T> @Nullable T safeCast(@NonNull Object object, Class<T> clazz) {
        Objects.requireNonNull(object, "Cannot safely cast null to generic type");
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        return null;
    }

    public static <T> Supplier<T> nullSupplier() {
        return NULL_SUPPLIER;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE_PREDICATE;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE_PREDICATE;
    }

    public static <T> @NonNull ChainedCallable<T> take(Callable<T> supplier) {
        return new ChainedCallable(supplier);
    }

    private static final class ConstantSupplier<T>
    implements Supplier<T> {
        private final T obj;

        private ConstantSupplier(T obj) {
            this.obj = obj;
        }

        @Override
        public T get() {
            return this.obj;
        }
    }

    public static final class ChainedCallable<R> {
        private Callable<R> handle;
        private boolean hasResult;
        private R result;
        private RuntimeException error;

        private ChainedCallable(Callable<R> handle2) {
            this.handle = Objects.requireNonNull(handle2);
            this.checkResult();
        }

        private void fail(Throwable ex) {
            if (this.error == null) {
                this.error = new RuntimeException("All possibilities failed");
            }
            this.error.addSuppressed(ex);
        }

        private boolean checkResult() {
            try {
                this.result = this.handle.call();
                this.hasResult = true;
                return true;
            }
            catch (Throwable e) {
                this.fail(e);
                return false;
            }
        }

        public @NonNull ChainedCallable<R> or(Callable<R> other) {
            if (!this.hasResult) {
                this.handle = other;
                this.checkResult();
            }
            return this;
        }

        public @NonNull ChainedCallable<R> or(@Nullable R other) {
            if (other == null) {
                return this;
            }
            return this.or((R)new ConstantCallable(other));
        }

        public @Nullable R orNull() {
            return (R)this.orElse(new ConstantCallable(null));
        }

        public boolean isPresent() {
            return this.result != null;
        }

        public @Nullable R get() {
            return this.result;
        }

        public @NonNull R orElse(R finalCheck) {
            Objects.requireNonNull(finalCheck, "Final non-lambda object cannot be null");
            return (R)this.orElse(new ConstantCallable(finalCheck));
        }

        public @Nullable R orElse(Callable<R> finalCheck) {
            if (!this.hasResult) {
                this.handle = finalCheck;
                this.checkResult();
            }
            if (this.hasResult) {
                return this.result;
            }
            throw this.error;
        }
    }

    private static final class ConstantCallable<T>
    implements Callable<T> {
        private final T obj;

        private ConstantCallable(T obj) {
            this.obj = obj;
        }

        @Override
        public T call() {
            return this.obj;
        }
    }
}

