/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.functional;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Finalizer
implements Runnable {
    private final List<Runnable> tasks = new ArrayList<Runnable>(5);
    private boolean ran = false;

    private void ensureOpen() {
        if (this.ran) {
            throw new IllegalStateException("Finalizer was already executed");
        }
    }

    public void add(Finalizer finalizer) {
        this.ensureOpen();
        this.tasks.addAll(finalizer.tasks);
    }

    public void add(Runnable runnable) {
        this.ensureOpen();
        Objects.requireNonNull(runnable, "Cannot add null task");
        this.tasks.add(runnable);
    }

    @Override
    public void run() {
        this.ensureOpen();
        this.ran = true;
        for (Runnable task : this.tasks) {
            task.run();
        }
    }
}

